/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.internal;

import java.io.IOException;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lfs.Protocol;
import org.eclipse.jgit.lfs.errors.LfsConfigInvalidException;
import org.eclipse.jgit.lfs.internal.LfsText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.HttpSupport;
import org.eclipse.jgit.util.SshSupport;

public class LfsConnectionFactory {
    private static final int SSH_AUTH_TIMEOUT_SECONDS = 30;
    private static final String SCHEME_HTTPS = "https";
    private static final String SCHEME_SSH = "ssh";
    private static final Map<String, AuthCache> sshAuthCache = new TreeMap<String, AuthCache>();

    public static HttpConnection getLfsConnection(Repository db, String method, String purpose) throws IOException {
        StoredConfig config = db.getConfig();
        TreeMap<String, String> additionalHeaders = new TreeMap<String, String>();
        String lfsUrl = LfsConnectionFactory.getLfsUrl(db, purpose, additionalHeaders);
        URL url = new URL(String.valueOf(lfsUrl) + "/objects/batch");
        HttpConnection connection = HttpTransport.getConnectionFactory().create(url, HttpSupport.proxyFor((ProxySelector)ProxySelector.getDefault(), (URL)url));
        connection.setDoOutput(true);
        if (url.getProtocol().equals(SCHEME_HTTPS) && !config.getBoolean("http", "sslVerify", true)) {
            HttpSupport.disableSslVerify((HttpConnection)connection);
        }
        connection.setRequestMethod(method);
        connection.setRequestProperty("Accept", "application/vnd.git-lfs+json; charset=utf-8");
        connection.setRequestProperty("Content-Type", "application/vnd.git-lfs+json; charset=utf-8");
        additionalHeaders.forEach((k, v) -> connection.setRequestProperty(k, v));
        return connection;
    }

    private static String getLfsUrl(Repository db, String purpose, Map<String, String> additionalHeaders) throws LfsConfigInvalidException {
        StoredConfig config = db.getConfig();
        String lfsUrl = config.getString("lfs", null, "url");
        Throwable ex = null;
        if (lfsUrl == null) {
            String remoteUrl = null;
            for (String remote : db.getRemoteNames()) {
                lfsUrl = config.getString("lfs", remote, "url");
                if (lfsUrl != null || !remote.equals("origin")) continue;
                remoteUrl = config.getString("remote", remote, "url");
                break;
            }
            if (lfsUrl == null && remoteUrl != null) {
                try {
                    lfsUrl = LfsConnectionFactory.discoverLfsUrl(db, purpose, additionalHeaders, remoteUrl);
                }
                catch (IOException | URISyntaxException | CommandFailedException e) {
                    ex = e;
                }
            } else {
                lfsUrl = String.valueOf(lfsUrl) + "/info/lfs";
            }
        }
        if (lfsUrl == null) {
            if (ex != null) {
                throw new LfsConfigInvalidException(LfsText.get().lfsNoDownloadUrl, (Exception)ex);
            }
            throw new LfsConfigInvalidException(LfsText.get().lfsNoDownloadUrl);
        }
        return lfsUrl;
    }

    private static String discoverLfsUrl(Repository db, String purpose, Map<String, String> additionalHeaders, String remoteUrl) throws URISyntaxException, IOException, CommandFailedException {
        URIish u = new URIish(remoteUrl);
        if (u.getScheme() == null || SCHEME_SSH.equals(u.getScheme())) {
            Protocol.ExpiringAction action = LfsConnectionFactory.getSshAuthentication(db, purpose, remoteUrl, u);
            additionalHeaders.putAll(action.header);
            return action.href;
        }
        return String.valueOf(remoteUrl) + "/info/lfs";
    }

    private static Protocol.ExpiringAction getSshAuthentication(Repository db, String purpose, String remoteUrl, URIish u) throws IOException, CommandFailedException {
        AuthCache cached = sshAuthCache.get(remoteUrl);
        Protocol.ExpiringAction action = null;
        if (cached != null && cached.validUntil > System.currentTimeMillis()) {
            action = cached.cachedAction;
        }
        if (action == null) {
            String json = SshSupport.runSshCommand((URIish)u.setPath(""), null, (FS)db.getFS(), (String)("git-lfs-authenticate " + LfsConnectionFactory.extractProjectName(u) + " " + purpose), (int)30);
            action = (Protocol.ExpiringAction)Protocol.gson().fromJson(json, Protocol.ExpiringAction.class);
            AuthCache c = new AuthCache(action);
            sshAuthCache.put(remoteUrl, c);
        }
        return action;
    }

    @NonNull
    public static HttpConnection getLfsContentConnection(Repository repo, Protocol.Action action, String method) throws IOException {
        URL contentUrl = new URL(action.href);
        HttpConnection contentServerConn = HttpTransport.getConnectionFactory().create(contentUrl, HttpSupport.proxyFor((ProxySelector)ProxySelector.getDefault(), (URL)contentUrl));
        contentServerConn.setRequestMethod(method);
        if (action.header != null) {
            action.header.forEach((k, v) -> contentServerConn.setRequestProperty(k, v));
        }
        if (contentUrl.getProtocol().equals(SCHEME_HTTPS) && !repo.getConfig().getBoolean("http", "sslVerify", true)) {
            HttpSupport.disableSslVerify((HttpConnection)contentServerConn);
        }
        contentServerConn.setRequestProperty("Accept-Encoding", "gzip");
        return contentServerConn;
    }

    private static String extractProjectName(URIish u) {
        String path = u.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith(".git")) {
            return path.substring(0, path.length() - 4);
        }
        return path;
    }

    public static Protocol.Request toRequest(String operation, LfsPointer ... resources) {
        Protocol.Request req = new Protocol.Request();
        req.operation = operation;
        if (resources != null) {
            req.objects = new LinkedList<Protocol.ObjectSpec>();
            LfsPointer[] lfsPointerArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                LfsPointer res = lfsPointerArray[n2];
                Protocol.ObjectSpec o = new Protocol.ObjectSpec();
                o.oid = res.getOid().getName();
                o.size = res.getSize();
                req.objects.add(o);
                ++n2;
            }
        }
        return req;
    }

    private static final class AuthCache {
        private static final long AUTH_CACHE_EAGER_TIMEOUT = 500L;
        private static final DateTimeFormatter ISO_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        long validUntil;
        Protocol.ExpiringAction cachedAction;

        public AuthCache(Protocol.ExpiringAction action) {
            this.cachedAction = action;
            try {
                this.validUntil = action.expiresIn != null && !action.expiresIn.isEmpty() ? System.currentTimeMillis() + Long.parseLong(action.expiresIn) - 500L : (action.expiresAt != null && !action.expiresAt.isEmpty() ? LocalDateTime.parse(action.expiresAt, ISO_FORMAT).atZone(ZoneOffset.UTC).toInstant().toEpochMilli() - 500L : System.currentTimeMillis());
            }
            catch (Exception e) {
                this.validUntil = System.currentTimeMillis();
            }
        }
    }
}

