/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.m2e.pde.MavenTargetLocation;

public final class MavenTargetDependency
extends Dependency {
    private MavenTargetLocation location;

    public MavenTargetDependency(String groupId, String artifactId, String version, String artifactType, String classifier) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
        if (artifactType != null && !artifactType.isBlank()) {
            this.setType(artifactType);
        } else {
            this.setType("jar");
        }
        this.setClassifier(classifier);
    }

    public MavenTargetLocation getTargetLocation() {
        return this.location;
    }

    public List<DependencyNode> getDependencyNodes() {
        if (this.location == null) {
            return null;
        }
        return this.location.getDependencyNodes(this);
    }

    public String getKey() {
        String type;
        String key = String.valueOf(this.getGroupId()) + ":" + this.getArtifactId();
        String classifier = this.getClassifier();
        if (classifier != null && !classifier.isBlank()) {
            key = String.valueOf(key) + ":" + classifier;
        }
        if ((type = this.getType()) != null && !type.isBlank()) {
            key = String.valueOf(key) + ":" + type;
        }
        key = String.valueOf(key) + ":" + this.getVersion();
        return key;
    }

    public void bind(MavenTargetLocation mavenTargetLocation) {
        if (this.location != null) {
            throw new IllegalStateException("already bound!");
        }
        this.location = mavenTargetLocation;
    }

    public MavenTargetDependency copy() {
        return new MavenTargetDependency(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getClassifier());
    }
}

