/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.BreakpointData;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.NewBreakpointData;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMRequest;

public class VMBreakpointRequest
extends VMRequest {
    private static final long serialVersionUID = -313847657694333827L;
    private final long fBreakpointID;
    private final ActionKind actionKind;
    private final BreakpointData[] data;

    private VMBreakpointRequest(long uniqueID, ActionKind actionKind) {
        this.actionKind = actionKind;
        this.fBreakpointID = uniqueID;
        this.data = null;
    }

    private VMBreakpointRequest(long uniqueID, BreakpointData[] data, ActionKind actionKind) {
        this.actionKind = actionKind;
        this.data = data;
        this.fBreakpointID = uniqueID;
    }

    public long getBreakpointID() {
        return this.fBreakpointID;
    }

    public ActionKind getActionKind() {
        return this.actionKind;
    }

    public List<BreakpointData> getBreakpointData() {
        return Collections.unmodifiableList(Arrays.asList(this.data));
    }

    public BreakpointData getFirstBreakpointData() {
        return this.data != null && this.data.length > 0 ? this.data[0] : null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " fBreakpointID:" + this.fBreakpointID + " action:" + (Object)((Object)this.actionKind);
    }

    public static VMBreakpointRequest createRemove(long id) {
        return new VMBreakpointRequest(id, ActionKind.REMOVE);
    }

    public static VMBreakpointRequest createAdd(NewBreakpointData[] bpData) {
        return new VMBreakpointRequest(-1L, bpData, ActionKind.ADD);
    }

    public static VMBreakpointRequest createAdd(NewBreakpointData bpData) {
        return new VMBreakpointRequest(-1L, new NewBreakpointData[]{bpData}, ActionKind.ADD);
    }

    public static VMBreakpointRequest createChange(long id, BreakpointData bpData) {
        return new VMBreakpointRequest(-1L, new BreakpointData[]{bpData}, ActionKind.CHANGE);
    }

    public static enum ActionKind {
        ADD,
        REMOVE,
        CHANGE;

    }
}

