/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.concurrent.Access;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.IRWOLockManager;
import org.eclipse.net4j.util.concurrent.ReentrantReadWriteAccess;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class RWOLockManager<OBJECT, CONTEXT>
extends Lifecycle
implements IRWOLockManager<OBJECT, CONTEXT> {
    private static final IRWLockManager.LockType[][] LOCK_TYPE_ARRAYS = new IRWLockManager.LockType[][]{{IRWLockManager.LockType.values()[0]}, {IRWLockManager.LockType.values()[1]}, {IRWLockManager.LockType.values()[2]}};
    private static final IRWLockManager.LockType[] ALL_LOCK_TYPES_ARRAY = IRWLockManager.LockType.values();
    protected final ReentrantReadWriteAccess rwAccess = new ReentrantReadWriteAccess(true);
    protected final Access read = this.rwAccess.readAccess();
    protected final Access write = this.rwAccess.writeAccess();
    private final Condition unlocked = this.rwAccess.newCondition();
    private final Map<OBJECT, LockState<OBJECT, CONTEXT>> objectToLockStateMap = this.createObjectToLocksMap();
    private final Map<CONTEXT, Set<LockState<OBJECT, CONTEXT>>> contextToLockStates = this.createContextToLocksMap();
    private volatile long modCount;

    @Override
    public long getModCount() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Access access = this.read.access();){
            return this.modCount;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long lock(CONTEXT context, Collection<? extends OBJECT> objects, IRWLockManager.LockType lockType, int count, long timeout, IRWOLockManager.LockDeltaHandler<OBJECT, CONTEXT> deltaHandler, Consumer<LockState<OBJECT, CONTEXT>> stateHandler) throws InterruptedException, TimeoutRuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LockState<OBJECT, CONTEXT> getOrCreateLockState(OBJECT object) {
        return this.objectToLockStateMap.computeIfAbsent(object, o -> new LockState(o));
    }

    private void addContextToLockStateMapping(CONTEXT context, LockState<OBJECT, CONTEXT> lockState) {
        this.contextToLockStates.computeIfAbsent(context, c -> new HashSet()).add(lockState);
    }

    @Override
    public long unlock(CONTEXT context, Collection<? extends OBJECT> objects, IRWLockManager.LockType lockType, int count, IRWOLockManager.LockDeltaHandler<OBJECT, CONTEXT> deltaHandler, Consumer<LockState<OBJECT, CONTEXT>> stateHandler) {
        CheckUtil.checkArg(context, "context");
        CheckUtil.checkArg(count >= -1, "count >= -1");
        IRWLockManager.LockType[] lockTypes = lockType == null ? ALL_LOCK_TYPES_ARRAY : LOCK_TYPE_ARRAYS[lockType.ordinal()];
        ArrayList<LockState<OBJECT, CONTEXT>> modifiedLockStates = new ArrayList<LockState<OBJECT, CONTEXT>>();
        Throwable throwable = null;
        Object var10_11 = null;
        try (Access access = this.write.access();){
            if (objects == null) {
                if (count == 0) {
                    return this.modCount;
                }
                Set<LockState<OBJECT, CONTEXT>> lockStates = this.contextToLockStates.get(context);
                if (lockStates == null) {
                    return this.modCount;
                }
                for (LockState<OBJECT, CONTEXT> lockState : lockStates) {
                    OBJECT object = lockState.getLockedObject();
                    this.doUnlock(context, object, lockTypes, count, deltaHandler, stateHandler, lockState, modifiedLockStates);
                }
            } else {
                if (objects.isEmpty()) {
                    return this.modCount;
                }
                for (OBJECT object : objects) {
                    LockState<OBJECT, CONTEXT> lockState = this.objectToLockStateMap.get(object);
                    if (lockState == null) continue;
                    this.doUnlock(context, object, lockTypes, count, deltaHandler, stateHandler, lockState, modifiedLockStates);
                }
            }
            this.removeLockStates(context, modifiedLockStates);
            this.unlocked.signalAll();
            this.modCount = this.modCount + 1L;
            return this.modCount;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void doUnlock(CONTEXT context, OBJECT object, IRWLockManager.LockType[] lockTypes, int count, IRWOLockManager.LockDeltaHandler<OBJECT, CONTEXT> deltaHandler, Consumer<LockState<OBJECT, CONTEXT>> stateHandler, LockState<OBJECT, CONTEXT> lockState, List<LockState<OBJECT, CONTEXT>> modifiedLockStates) {
        IRWLockManager.LockType[] lockTypeArray = lockTypes;
        int n = lockTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IRWLockManager.LockType lockType = lockTypeArray[n2];
            if (lockState.canUnlock(lockType, context)) {
                int oldCount = lockState.getLockCount(lockType, context);
                int newCount = lockState.unlock(lockType, context, count);
                if (newCount != oldCount) {
                    modifiedLockStates.add(lockState);
                    if (deltaHandler != null) {
                        deltaHandler.handleLockDelta(context, lockState.getLockedObject(), lockType, oldCount, newCount);
                    }
                }
                if (stateHandler != null) {
                    stateHandler.accept(lockState);
                }
            }
            ++n2;
        }
    }

    private void removeLockStates(CONTEXT context, List<LockState<OBJECT, CONTEXT>> modifiedLockStates) {
        for (LockState<OBJECT, CONTEXT> lockState : modifiedLockStates) {
            if (!lockState.hasLocks(context)) {
                this.removeLockStateForContext(context, lockState);
            }
            if (!lockState.hasNoLocks()) continue;
            this.objectToLockStateMap.remove(lockState.getLockedObject());
        }
    }

    private void removeLockStateForContext(CONTEXT context, LockState<OBJECT, CONTEXT> lockState) {
        Set<LockState<OBJECT, CONTEXT>> lockStates = this.contextToLockStates.get(context);
        if (lockStates != null) {
            lockStates.remove(lockState);
            if (lockStates.isEmpty()) {
                this.contextToLockStates.remove(context);
            }
        }
    }

    @Override
    public boolean hasLock(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Access access = this.read.access();){
            LockState<OBJECT, CONTEXT> lockState = this.objectToLockStateMap.get(objectToLock);
            boolean bl = lockState != null && lockState.hasLock(type, context, false);
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean hasLockByOthers(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Access access = this.read.access();){
            LockState<OBJECT, CONTEXT> lockState = this.objectToLockStateMap.get(objectToLock);
            boolean bl = lockState != null && lockState.hasLock(type, context, true);
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public LockState<OBJECT, CONTEXT> getLockState(OBJECT key) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Access access = this.read.access();){
            return this.objectToLockStateMap.get(key);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getLockStates(Collection<OBJECT> keys, BiConsumer<OBJECT, LockState<OBJECT, CONTEXT>> consumer) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Access access = this.read.access();){
            keys.forEach(key -> {
                LockState<OBJECT, CONTEXT> lockState = this.objectToLockStateMap.get(key);
                consumer.accept(key, lockState);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void getLockStates(Consumer<LockState<OBJECT, CONTEXT>> consumer) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Access access = this.read.access();){
            this.objectToLockStateMap.values().forEach(consumer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void changeContext(CONTEXT oldContext, CONTEXT newContext) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Access access = this.write.access();){
            for (LockState<OBJECT, CONTEXT> lockState : this.objectToLockStateMap.values()) {
                lockState.replaceContext(oldContext, newContext);
            }
            Set<LockState<OBJECT, CONTEXT>> lockStates = this.contextToLockStates.remove(oldContext);
            if (lockStates != null) {
                this.contextToLockStates.put(newContext, lockStates);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected final Map<OBJECT, LockState<OBJECT, CONTEXT>> getObjectToLocksMap() {
        return this.objectToLockStateMap;
    }

    protected final Map<CONTEXT, Set<LockState<OBJECT, CONTEXT>>> getContextToLocksMap() {
        return this.contextToLockStates;
    }

    protected Map<OBJECT, LockState<OBJECT, CONTEXT>> createObjectToLocksMap() {
        return new HashMap();
    }

    protected Map<CONTEXT, Set<LockState<OBJECT, CONTEXT>>> createContextToLocksMap() {
        return new HashMap();
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Deprecated
    public List<LockState<OBJECT, CONTEXT>> getLockStates() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setLockState(OBJECT key, LockState<OBJECT, CONTEXT> lockState) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Access access = this.write.access();){
            CONTEXT writeOptionOwner;
            this.objectToLockStateMap.put(key, lockState);
            for (CONTEXT readLockOwner : lockState.getReadLockOwners()) {
                this.addContextToLockStateMapping(readLockOwner, lockState);
            }
            CONTEXT writeLockOwner = lockState.getWriteLockOwner();
            if (writeLockOwner != null) {
                this.addContextToLockStateMapping(writeLockOwner, lockState);
            }
            if ((writeOptionOwner = lockState.getWriteOptionOwner()) != null) {
                this.addContextToLockStateMapping(writeOptionOwner, lockState);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Deprecated
    public void lock(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToLock, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<LockState<OBJECT, CONTEXT>> lock2(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToLock, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void lock(IRWLockManager.LockType type, CONTEXT context, OBJECT objectToLock, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unlock(IRWLockManager.LockType type, CONTEXT context, Collection<? extends OBJECT> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unlock(CONTEXT context) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<LockState<OBJECT, CONTEXT>> unlock2(CONTEXT context) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<LockState<OBJECT, CONTEXT>> unlock2(CONTEXT context, Collection<? extends OBJECT> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<LockState<OBJECT, CONTEXT>> unlock2(IRWLockManager.LockType lockType, CONTEXT context, Collection<? extends OBJECT> objectsToUnlock) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void setUnlockAll(boolean on) {
        throw new UnsupportedOperationException();
    }

    public static class LockState<OBJECT, CONTEXT> {
        private final OBJECT lockedObject;
        private HashBag<CONTEXT> readLockOwners;
        private CONTEXT writeLockOwner;
        private CONTEXT writeOptionOwner;
        private int writeLockCounter;

        LockState(OBJECT lockedObject) {
            CheckUtil.checkArg(lockedObject, "lockedObject");
            this.lockedObject = lockedObject;
        }

        public OBJECT getLockedObject() {
            return this.lockedObject;
        }

        public int getLockCount(IRWLockManager.LockType type, CONTEXT context) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    return this.readLockOwners == null ? 0 : this.readLockOwners.getCounterFor(context);
                }
                case WRITE: {
                    return this.writeLockOwner == context ? this.writeLockCounter : 0;
                }
                case OPTION: {
                    return this.writeOptionOwner == context ? 1 : 0;
                }
            }
            throw new AssertionError();
        }

        public boolean hasLock(IRWLockManager.LockType type, CONTEXT context, boolean byOthers) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    if (this.readLockOwners == null) {
                        return false;
                    }
                    if (byOthers) {
                        return this.readLockOwners.size() > 1 || this.readLockOwners.size() == 1 && !this.readLockOwners.contains(context);
                    }
                    return this.readLockOwners.contains(context);
                }
                case WRITE: {
                    if (byOthers) {
                        return this.writeLockOwner != null && this.writeLockOwner != context;
                    }
                    return this.writeLockOwner == context;
                }
                case OPTION: {
                    if (byOthers) {
                        return this.writeOptionOwner != null && this.writeOptionOwner != context;
                    }
                    return this.writeOptionOwner == context;
                }
            }
            throw new AssertionError();
        }

        public boolean hasLock(IRWLockManager.LockType type) {
            switch (type) {
                case READ: {
                    return this.readLockOwners != null && this.readLockOwners.size() > 0;
                }
                case WRITE: {
                    return this.writeLockOwner != null;
                }
                case OPTION: {
                    return this.writeOptionOwner != null;
                }
            }
            throw new AssertionError();
        }

        public Set<CONTEXT> getReadLockOwners() {
            if (this.readLockOwners == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(this.readLockOwners);
        }

        public CONTEXT getWriteLockOwner() {
            return this.writeLockOwner;
        }

        public CONTEXT getWriteOptionOwner() {
            return this.writeOptionOwner;
        }

        public int hashCode() {
            return this.lockedObject.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LockState)) {
                return false;
            }
            LockState other = (LockState)obj;
            return this.lockedObject.equals(other.lockedObject);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("LockState[target=");
            builder.append(this.lockedObject);
            if (this.readLockOwners != null && this.readLockOwners.size() > 0) {
                builder.append(", read=");
                boolean first = true;
                for (CONTEXT context : this.readLockOwners) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(context);
                }
                builder.deleteCharAt(builder.length() - 1);
            }
            if (this.writeLockOwner != null) {
                builder.append(", write=");
                builder.append(this.writeLockOwner);
            }
            if (this.writeOptionOwner != null) {
                builder.append(", option=");
                builder.append(this.writeOptionOwner);
            }
            builder.append(']');
            return builder.toString();
        }

        boolean canLock(IRWLockManager.LockType type, CONTEXT context) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    return this.canLockRead(context);
                }
                case WRITE: {
                    return this.canLockWrite(context);
                }
                case OPTION: {
                    return this.canLockOption(context);
                }
            }
            throw new AssertionError();
        }

        boolean canUnlock(IRWLockManager.LockType type, CONTEXT context) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    return this.canUnlockRead(context);
                }
                case WRITE: {
                    return this.canUnlockWrite(context);
                }
                case OPTION: {
                    return this.canUnlockOption(context);
                }
            }
            throw new AssertionError();
        }

        int lock(IRWLockManager.LockType type, CONTEXT context, int count) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    return this.doLockRead(context, count);
                }
                case WRITE: {
                    return this.doLockWrite(context, count);
                }
                case OPTION: {
                    return this.doLockOption(context, count);
                }
            }
            throw new AssertionError();
        }

        int unlock(IRWLockManager.LockType type, CONTEXT context, int count) {
            CheckUtil.checkArg(context, "context");
            switch (type) {
                case READ: {
                    return this.doUnlockRead(context, count);
                }
                case WRITE: {
                    return this.doUnlockWrite(context, count);
                }
                case OPTION: {
                    return this.doUnlockOption(context, count);
                }
            }
            throw new AssertionError();
        }

        void replaceContext(CONTEXT oldContext, CONTEXT newContext) {
            int readLocksOwnedByOldView;
            if (this.readLockOwners != null && (readLocksOwnedByOldView = this.readLockOwners.getCounterFor(oldContext)) > 0) {
                int i = 0;
                while (i < readLocksOwnedByOldView) {
                    this.readLockOwners.remove(oldContext);
                    this.readLockOwners.add(newContext);
                    ++i;
                }
            }
            if (ObjectUtil.equals(this.writeLockOwner, oldContext)) {
                this.writeLockOwner = newContext;
            }
            if (ObjectUtil.equals(this.writeOptionOwner, oldContext)) {
                this.writeOptionOwner = newContext;
            }
        }

        boolean hasNoLocks() {
            return ObjectUtil.isEmpty(this.readLockOwners) && this.writeLockOwner == null && this.writeOptionOwner == null;
        }

        boolean hasLocks(CONTEXT context) {
            return this.readLockOwners != null && this.readLockOwners.contains(context) || this.writeLockOwner == context || this.writeOptionOwner == context;
        }

        private boolean canLockRead(CONTEXT context) {
            return this.writeLockOwner == null || this.writeLockOwner == context;
        }

        private boolean canLockWrite(CONTEXT context) {
            if (this.writeLockOwner != null && this.writeLockOwner != context) {
                return false;
            }
            if (this.writeOptionOwner != null && this.writeOptionOwner != context) {
                return false;
            }
            if (this.readLockOwners != null) {
                if (this.readLockOwners.size() > 1) {
                    return false;
                }
                if (this.readLockOwners.size() == 1 && !this.readLockOwners.contains(context)) {
                    return false;
                }
            }
            return true;
        }

        private boolean canLockOption(CONTEXT context) {
            if (this.writeOptionOwner != null && this.writeOptionOwner != context) {
                return false;
            }
            return this.writeLockOwner == null || this.writeLockOwner == context;
        }

        private boolean canUnlockRead(CONTEXT context) {
            return this.readLockOwners == null || this.readLockOwners.contains(context);
        }

        private boolean canUnlockWrite(CONTEXT context) {
            return this.writeLockOwner == context;
        }

        private boolean canUnlockOption(CONTEXT context) {
            return this.writeOptionOwner == context;
        }

        private int doLockRead(CONTEXT context, int count) {
            if (this.readLockOwners == null) {
                this.readLockOwners = new HashBag();
            }
            return this.readLockOwners.addAndGet(context, count);
        }

        private int doLockWrite(CONTEXT context, int count) {
            this.writeLockOwner = context;
            return this.writeLockCounter += count;
        }

        private int doLockOption(CONTEXT context, int count) {
            this.writeOptionOwner = context;
            return 1;
        }

        private int doUnlockRead(CONTEXT context, int count) {
            if (this.readLockOwners == null) {
                return 0;
            }
            if (count == -1) {
                this.readLockOwners.removeCounterFor(context);
                if (this.readLockOwners.isEmpty()) {
                    this.readLockOwners = null;
                }
                return 0;
            }
            int newCount = this.readLockOwners.removeAndGet(context, count);
            if (this.readLockOwners.isEmpty()) {
                this.readLockOwners = null;
            }
            return newCount;
        }

        private int doUnlockWrite(CONTEXT context, int count) {
            if (count == -1) {
                this.writeLockOwner = null;
                this.writeLockCounter = 0;
                return 0;
            }
            this.writeLockCounter -= count;
            if (this.writeLockCounter == 0) {
                this.writeLockOwner = null;
            }
            return this.writeLockCounter;
        }

        private int doUnlockOption(CONTEXT context, int count) {
            this.writeOptionOwner = null;
            return 0;
        }
    }
}

