/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.core.internal.exported;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.papyrus.emf.facet.custom.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.EClassCustomization;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.FacetCustomization;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.papyrus.emf.facet.util.core.Logger;

public final class CustomizationUtils {
    private static final String FILE_EXTENSION = "custom";

    private CustomizationUtils() {
    }

    public static EPackage getCustomizedEPackage(Customization customization) {
        EPackage result = null;
        block0: for (EClassifier eClassifier : customization.getEClassifiers()) {
            for (EPackage ePackage : CustomizationUtils.getExtendedEPackage(eClassifier)) {
                if (ePackage == null || ePackage instanceof FacetSet) continue;
                result = ePackage;
                continue block0;
            }
        }
        return result;
    }

    private static List<EPackage> getExtendedEPackage(EClassifier eClassifier) {
        ArrayList<EClass> extended = new ArrayList<EClass>();
        if (eClassifier instanceof FacetCustomization) {
            FacetCustomization facetCustom = (FacetCustomization)eClassifier;
            extended.addAll((Collection<EClass>)facetCustom.getExtendedFacets());
        } else if (eClassifier instanceof EClassCustomization) {
            EClassCustomization eClassCustom = (EClassCustomization)eClassifier;
            extended.add(eClassCustom.getExtendedMetaclass());
        }
        LinkedList<EPackage> ePackages = new LinkedList<EPackage>();
        for (EClassifier eClassifier2 : extended) {
            if (eClassifier2 == null) continue;
            ePackages.add(eClassifier2.getEPackage());
        }
        return ePackages;
    }

    public static String getDefaultFileExtension() {
        return FILE_EXTENSION;
    }

    public static Customization getCustomization(Collection<Customization> customizations, String name) {
        Customization result = null;
        for (Customization customization : customizations) {
            if (!name.equals(customization.getName())) continue;
            result = customization;
        }
        return result;
    }

    public static <T> T getPropertyValue(ICustomizationManager customManager, Object element, FacetOperation property, ETypedElement eTypedElement, Class<T> classs) {
        Object result = null;
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            try {
                result = eTypedElement == null ? customManager.getCustomValueOf(eObject, property, classs) : customManager.getCustomValueOf(eObject, eTypedElement, property, classs);
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (String)("Failed to get the value of '" + property.getName() + "' for " + element), (Plugin)Activator.getDefault());
            }
        }
        if (result instanceof StyledString && !classs.isInstance(result)) {
            result = result.toString();
        }
        return (T)result;
    }
}

