/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.nattable.celleditor.config.IAxisCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class CellEditorConfigurationFactory {
    private Map<Integer, Collection<IAxisCellEditorConfiguration>> registry;
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.celleditor.configuration";
    public static final String CELL_EDITOR_CONFIGURATION_CLASS_ATTRIBUTE = "class";
    public static final String ORDER_ATTRIBUTE = "order";
    public static final CellEditorConfigurationFactory INSTANCE = new CellEditorConfigurationFactory();
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.papyrus.infra.nattable.celleditor";
    public static final String EXTENSION_POINT_NAME = "configuration";

    private CellEditorConfigurationFactory() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        this.registry = new TreeMap<Integer, Collection<IAxisCellEditorConfiguration>>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            if (EXTENSION_POINT_NAME.equals(iConfigurationElement.getName())) {
                Integer order = new Integer(iConfigurationElement.getAttribute(ORDER_ATTRIBUTE));
                try {
                    IAxisCellEditorConfiguration factory = (IAxisCellEditorConfiguration)iConfigurationElement.createExecutableExtension(CELL_EDITOR_CONFIGURATION_CLASS_ATTRIBUTE);
                    if (factory != null) {
                        if (!this.registry.containsKey(order)) {
                            this.registry.put(order, new HashSet());
                        }
                        this.registry.get(order).add(factory);
                    }
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            ++n2;
        }
    }

    @Deprecated
    public IAxisCellEditorConfiguration getCellEditorConfigruation(String configurationId) {
        return this.getCellEditorConfiguration(configurationId);
    }

    public IAxisCellEditorConfiguration getCellEditorConfiguration(String configurationId) {
        Assert.isNotNull((Object)configurationId);
        IAxisCellEditorConfiguration result = null;
        Iterator<Integer> orders = this.registry.keySet().iterator();
        while (orders.hasNext() && result == null) {
            Integer order = orders.next();
            Iterator<IAxisCellEditorConfiguration> configurations = this.registry.get(order).iterator();
            while (configurations.hasNext() && result == null) {
                IAxisCellEditorConfiguration current = configurations.next();
                if (!configurationId.equals(current.getEditorConfigId())) continue;
                result = current;
            }
        }
        return result;
    }

    public IAxisCellEditorConfiguration getFirstCellEditorConfiguration(Table table, Object obj) {
        List<IAxisCellEditorConfiguration> factories = this.getCellEditorConfigurationFactories(table, obj);
        if (!factories.isEmpty()) {
            return factories.get(0);
        }
        return null;
    }

    public List<IAxisCellEditorConfiguration> getCellEditorConfigurationFactories(Table table, Object obj) {
        ArrayList<IAxisCellEditorConfiguration> factories = new ArrayList<IAxisCellEditorConfiguration>();
        for (Collection<IAxisCellEditorConfiguration> configurations : this.registry.values()) {
            for (IAxisCellEditorConfiguration current : configurations) {
                if (!current.handles(table, obj)) continue;
                factories.add(current);
            }
        }
        return factories;
    }
}

