/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.provider.ConfigurationElementItemProvider;

public class ElementTypeConfigurationItemProvider
extends ConfigurationElementItemProvider {
    public ElementTypeConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdentifierPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
            this.addHintPropertyDescriptor(object);
            this.addKindPropertyDescriptor(object);
            this.addOwnedConfigurationsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIdentifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_IdentifiedConfiguration_identifier_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_IdentifiedConfiguration_identifier_feature", "_UI_IdentifiedConfiguration_type"), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.IDENTIFIED_CONFIGURATION__IDENTIFIER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_NamedConfiguration_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_NamedConfiguration_name_feature", "_UI_NamedConfiguration_type"), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.NAMED_CONFIGURATION__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addHintPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ElementTypeConfiguration_hint_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ElementTypeConfiguration_hint_feature", "_UI_ElementTypeConfiguration_type"), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__HINT, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addKindPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ElementTypeConfiguration_kind_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ElementTypeConfiguration_kind_feature", "_UI_ElementTypeConfiguration_type"), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__KIND, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addOwnedConfigurationsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ElementTypeConfiguration_ownedConfigurations_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ElementTypeConfiguration_ownedConfigurations_feature", "_UI_ElementTypeConfiguration_type"), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_CONFIGURATIONS, false, false, false, null, null, null));
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__ICON_ENTRY);
            this.childrenFeatures.add(ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_ADVICE);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        EStructuralFeature result = null;
        for (EStructuralFeature eStructuralFeature : this.sortChildrenFeatures(this.getChildrenFeatures(object))) {
            if (!this.isValidValue(object, child, eStructuralFeature)) continue;
            result = eStructuralFeature;
            break;
        }
        return result;
    }

    protected List<? extends EStructuralFeature> sortChildrenFeatures(Collection<? extends EStructuralFeature> features) {
        ArrayList<? extends EStructuralFeature> result = new ArrayList<EStructuralFeature>(features);
        Collections.sort(result, this::compareFeatures);
        return result;
    }

    protected int compareFeatures(EStructuralFeature a, EStructuralFeature b) {
        if (a.isMany() && !b.isMany()) {
            return 1;
        }
        if (b.isMany() && !a.isMany()) {
            return -1;
        }
        if (this.isSubset(a, b)) {
            return 1;
        }
        if (this.isSubset(b, a)) {
            return -1;
        }
        return 0;
    }

    protected boolean isSubset(EStructuralFeature possibleSubset, EStructuralFeature possibleSuperset) {
        EAnnotation subsetAnnotation = possibleSubset.getEAnnotation("subsets");
        return subsetAnnotation != null && subsetAnnotation.getReferences().contains((Object)possibleSuperset);
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        Object result = value;
        if (feature instanceof EReference) {
            EStructuralFeature previousSubset = null;
            EContentsEList.FeatureIterator iter = (EContentsEList.FeatureIterator)object.eCrossReferences().iterator();
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (next != value || next.eContainmentFeature() != ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_CONFIGURATIONS || !this.isSubset(iter.feature(), (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_CONFIGURATIONS)) continue;
                if (previousSubset != null && previousSubset != iter.feature()) {
                    result = new DelegatingWrapperItemProvider(value, object, feature, index, this.adapterFactory){

                        public String getText(Object object) {
                            return NLS.bind((String)"{0} as {1}", (Object)super.getText(object), (Object)ElementTypeConfigurationItemProvider.this.getFeatureText(this.feature));
                        }
                    };
                    break;
                }
                previousSubset = iter.feature();
            }
        } else {
            result = super.createWrapper(object, feature, value, index);
        }
        return result;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        if (feature.isDerived() && this.isSubset(feature, (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_CONFIGURATIONS)) {
            feature = ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_CONFIGURATIONS;
        }
        return super.createAddCommand(domain, owner, feature, collection, index);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        Command result = this.isSubset(feature, (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_CONFIGURATIONS) ? this.createRemoveCommand(domain, owner, (EStructuralFeature)ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_CONFIGURATIONS, collection) : super.createRemoveCommand(domain, owner, feature, collection);
        return result;
    }

    @Override
    public String getText(Object object) {
        String label = ((ElementTypeConfiguration)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_ElementTypeConfiguration_type") : String.valueOf(this.getString("_UI_ElementTypeConfiguration_type")) + " " + label;
    }

    public void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ElementTypeConfiguration.class)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 7: 
            case 8: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.notifyChangedGen(notification);
        switch (notification.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                switch (notification.getFeatureID(ElementTypeConfiguration.class)) {
                    case 10: {
                        if (this.childrenStoreMap != null) {
                            this.childrenStoreMap.remove(notification.getNotifier());
                        }
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                        return;
                    }
                }
            }
        }
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__ICON_ENTRY, ElementTypesConfigurationsFactory.eINSTANCE.createIconEntry()));
        newChildDescriptors.add(this.createChildParameter(ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_ADVICE, ElementTypesConfigurationsFactory.eINSTANCE.createAdviceBindingConfiguration()));
        newChildDescriptors.add(this.createChildParameter(ElementTypesConfigurationsPackage.Literals.ELEMENT_TYPE_CONFIGURATION__OWNED_ADVICE, ElementTypesConfigurationsFactory.eINSTANCE.createExternallyRegisteredAdvice()));
    }
}

