/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.service.types.request.MoveOperandFragmentEditRequest;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;

public class MoveOperandFragmentsCommand
extends EditElementCommand {
    private InteractionFragment parent;
    private EList<InteractionFragment> fragmentsToMove;
    private InteractionOperand sourceOperand;
    private CombinedFragment combinedFragment;

    public MoveOperandFragmentsCommand(CombinedFragment cf, InteractionOperand op, MoveOperandFragmentEditRequest editRequest) {
        super(null, (EObject)editRequest.getElementToEdit(), (IEditCommandRequest)editRequest);
        InteractionOperand enclosingOp = cf.getEnclosingOperand();
        if (enclosingOp != null) {
            Element owner = enclosingOp.getOwner();
            if (owner instanceof CombinedFragment) {
                this.parent = enclosingOp;
            }
        } else {
            Element owner = cf.getOwner();
            if (owner instanceof Interaction) {
                this.parent = (InteractionFragment)owner;
            }
        }
        this.sourceOperand = op;
        this.combinedFragment = cf;
        this.fragmentsToMove = op.getFragments();
    }

    public boolean canExecute() {
        return this.sourceOperand != null && this.combinedFragment != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.parent != null && !this.fragmentsToMove.isEmpty()) {
            if (this.parent instanceof InteractionOperand) {
                ((InteractionOperand)this.parent).getFragments().addAll(this.fragmentsToMove);
            } else if (this.parent instanceof Interaction) {
                ((Interaction)this.parent).getFragments().addAll(this.fragmentsToMove);
            }
        }
        this.sourceOperand.getFragments().clear();
        return CommandResult.newOKCommandResult();
    }
}

