/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.engine;

import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.profile.core.data.ProfilerCallTrace;
import org.eclipse.php.profile.core.data.ProfilerData;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerFunctionData;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.core.engine.ZProfiler;

public class DefaultProfilerDB
implements ProfilerDB {
    private IntHashtable fFunctionsHash = new IntHashtable();
    private Map<String, ProfilerFileData> fFilesHash = new Hashtable<String, ProfilerFileData>();
    private ProfilerData fProfilerData;
    private Date fProfileDate;

    public DefaultProfilerDB(ZProfiler connectionManager) {
        this.fProfilerData = connectionManager.getProfilerData();
        this.buildFilesHashtable();
        this.buildFunctionsHashtable();
        this.fProfileDate = new Date();
    }

    public DefaultProfilerDB(ProfilerData data, Date date) {
        this.fProfilerData = data;
        this.fProfileDate = date;
        this.buildFilesHashtable();
        this.buildFunctionsHashtable();
    }

    private void buildFilesHashtable() {
        this.fFilesHash.clear();
        ProfilerFileData[] files = this.getProfilerData().getFiles();
        int i = 0;
        while (i < files.length) {
            ProfilerFileData file = files[i];
            this.fFilesHash.put(file.getName(), file);
            ++i;
        }
    }

    private void buildFunctionsHashtable() {
        this.fFunctionsHash.clear();
        ProfilerFileData[] files = this.getProfilerData().getFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                ProfilerFileData fileData = files[i];
                ProfilerFunctionData[] functionsData = fileData.getFunctions();
                if (functionsData != null) {
                    int j = 0;
                    while (j < functionsData.length) {
                        this.fFunctionsHash.put(functionsData[j].getID(), (Object)functionsData[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public ProfilerFunctionData getFunctionData(int id) {
        return (ProfilerFunctionData)this.fFunctionsHash.get(id);
    }

    @Override
    public ProfilerFileData getFileData(String fileName) {
        if (this.fFilesHash.get(fileName) != null) {
            return this.fFilesHash.get(fileName);
        }
        return null;
    }

    @Override
    public ProfilerFileData getFileData(int fileNumber) {
        ProfilerFileData[] filesList = this.getProfilerData().getFiles();
        if (filesList != null && filesList.length > fileNumber) {
            return filesList[fileNumber];
        }
        return null;
    }

    @Override
    public ProfilerFileData[] getFiles() {
        return this.fProfilerData.getFiles();
    }

    @Override
    public List<ProfilerFileData> getFilesList() {
        return this.fProfilerData.getFilesList();
    }

    @Override
    public ProfilerCallTrace getCallTrace() {
        return this.getProfilerData().getCallTrace();
    }

    @Override
    public ProfilerGlobalData getGlobalData() {
        return this.getProfilerData().getGlobalData();
    }

    @Override
    public void clearAll() {
        this.fFunctionsHash.clear();
        this.fFilesHash.clear();
        this.fProfilerData = null;
    }

    @Override
    public ProfilerData getProfilerData() {
        if (this.fProfilerData == null) {
            this.fProfilerData = new ProfilerData();
        }
        return this.fProfilerData;
    }

    @Override
    public void setProfilerData(ProfilerData profiler) {
        this.fProfilerData = profiler;
    }

    @Override
    public Date getProfileDate() {
        return this.fProfileDate;
    }
}

