/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.page;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.core.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.page.PageNewOperation;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.s2e.ui.internal.page.PageNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.ui.wizard.WizardFinishTask;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class PageNewWizard
extends AbstractWizard
implements INewWizard {
    private static volatile Class<? extends PageNewWizardPage> pageClass = PageNewWizardPage.class;
    private PageNewWizardPage m_page1;
    private WizardFinishTask<PageNewOperation> m_finishTask;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_page1 = this.initNewClassWizardWithPage(PageNewWizard.getPage1Class(), S2eUiUtils.getClientPackageOfSelection((ISelection)selection));
        this.m_finishTask = new WizardFinishTask(workbench.getDisplay());
        this.m_finishTask.withOperation(PageNewOperation::new).withMapper(this::mapPageToOperation).withUiAction((op, d) -> {
            org.eclipse.scout.sdk.core.model.api.IType type = (org.eclipse.scout.sdk.core.model.api.IType)op.getCreatedPage().result();
            d.asyncExec(() -> S2eUiUtils.openInEditor(type, false));
        });
    }

    public WizardFinishTask<PageNewOperation> getFinishTask() {
        return this.m_finishTask;
    }

    protected void mapPageToOperation(WizardFinishTask.PageToOperationMappingInput input, PageNewOperation op) {
        IJavaProject serverProject;
        IPackageFragmentRoot selectedServerFolder;
        op.setCreateAbstractPage(this.m_page1.isCreateAbstractPage());
        op.setClientSourceFolder(input.environment().toScoutSourceFolder(this.m_page1.getSourceFolder()));
        op.setPackage(this.m_page1.getTargetPackage());
        op.setPageName(this.m_page1.getIcuName());
        IPackageFragmentRoot selectedSharedFolder = this.m_page1.getSharedSourceFolder();
        if (JdtUtils.exists((IJavaElement)selectedSharedFolder)) {
            op.setSharedSourceFolder(input.environment().toScoutSourceFolder(selectedSharedFolder));
            IPackageFragmentRoot dtoSourceFolder = S2eUtils.getDtoSourceFolder((IPackageFragmentRoot)selectedSharedFolder);
            op.setPageDataSourceFolder(input.environment().toScoutSourceFolder(dtoSourceFolder));
        }
        if (JdtUtils.exists((IJavaElement)(selectedServerFolder = this.m_page1.getServerSourceFolder()))) {
            IPackageFragmentRoot serviceTestSourceFolder;
            serverProject = selectedServerFolder.getJavaProject();
            IClasspathEntry serverSourceFolder = input.environment().toScoutSourceFolder(selectedServerFolder);
            op.setServerSourceFolder(serverSourceFolder);
            IScoutApi scoutApi = (IScoutApi)serverSourceFolder.javaEnvironment().requireApi(IScoutApi.class);
            if (op.getTestSourceFolder() == null && (serviceTestSourceFolder = S2eUiUtils.getTestSourceFolder((IJavaElement)selectedServerFolder, scoutApi.ServerTestRunner().fqn(), "service test")) != null) {
                op.setTestSourceFolder(input.environment().toScoutSourceFolder(serviceTestSourceFolder));
            }
        } else {
            serverProject = null;
        }
        op.setSuperType(this.m_page1.getSuperType().getFullyQualifiedName());
        op.setServerSession((String)S2eUtils.getSession((IJavaProject)serverProject, (ScoutTier)ScoutTier.Server, (IProgressMonitor)input.progress().monitor()).map(IType::getFullyQualifiedName).orElse(null));
    }

    public static Class<? extends PageNewWizardPage> getPage1Class() {
        return pageClass;
    }

    public static void setPage1Class(Class<? extends PageNewWizardPage> page1Class) {
        pageClass = page1Class;
    }
}

