/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;

public class WebResource
extends ModuleArtifactDelegate {
    private IPath path;

    public WebResource(IModule module, IPath path) {
        super(module);
        this.path = path;
    }

    public WebResource() {
    }

    public IPath getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        if (this.path == null || this.path.toString().length() == 0) {
            return this.getModule().getName();
        }
        return this.path.toString();
    }

    @Override
    public void deserialize(String s) {
        int ind = s.indexOf("//");
        super.deserialize(s.substring(0, ind));
        this.path = new Path(s.substring(ind + 2));
    }

    @Override
    public String serialize() {
        StringBuffer sb = new StringBuffer(super.serialize());
        sb.append("//");
        sb.append(this.path.toPortableString());
        return sb.toString();
    }

    public String toString() {
        return "WebResource [module=" + this.getModule() + ", path=" + this.path + "]";
    }
}

