/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.CpuStats;

final class ImmutableCpuStats
implements CpuStats {
    private final CpuStats.CpuUsage cpuUsage;
    @Nullable
    private final Long systemCpuUsage;
    private final CpuStats.ThrottlingData throttlingData;

    private ImmutableCpuStats(CpuStats.CpuUsage cpuUsage, @Nullable Long systemCpuUsage, CpuStats.ThrottlingData throttlingData) {
        this.cpuUsage = cpuUsage;
        this.systemCpuUsage = systemCpuUsage;
        this.throttlingData = throttlingData;
    }

    @Override
    @JsonProperty(value="cpu_usage")
    public CpuStats.CpuUsage cpuUsage() {
        return this.cpuUsage;
    }

    @Override
    @JsonProperty(value="system_cpu_usage")
    @Nullable
    public Long systemCpuUsage() {
        return this.systemCpuUsage;
    }

    @Override
    @JsonProperty(value="throttling_data")
    public CpuStats.ThrottlingData throttlingData() {
        return this.throttlingData;
    }

    public final ImmutableCpuStats withCpuUsage(CpuStats.CpuUsage value) {
        if (this.cpuUsage == value) {
            return this;
        }
        CpuStats.CpuUsage newValue = Objects.requireNonNull(value, "cpuUsage");
        return new ImmutableCpuStats(newValue, this.systemCpuUsage, this.throttlingData);
    }

    public final ImmutableCpuStats withSystemCpuUsage(@Nullable Long value) {
        if (Objects.equals(this.systemCpuUsage, value)) {
            return this;
        }
        return new ImmutableCpuStats(this.cpuUsage, value, this.throttlingData);
    }

    public final ImmutableCpuStats withThrottlingData(CpuStats.ThrottlingData value) {
        if (this.throttlingData == value) {
            return this;
        }
        CpuStats.ThrottlingData newValue = Objects.requireNonNull(value, "throttlingData");
        return new ImmutableCpuStats(this.cpuUsage, this.systemCpuUsage, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCpuStats && this.equalTo((ImmutableCpuStats)another);
    }

    private boolean equalTo(ImmutableCpuStats another) {
        return this.cpuUsage.equals(another.cpuUsage) && Objects.equals(this.systemCpuUsage, another.systemCpuUsage) && this.throttlingData.equals(another.throttlingData);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cpuUsage.hashCode();
        h += (h << 5) + Objects.hashCode(this.systemCpuUsage);
        h += (h << 5) + this.throttlingData.hashCode();
        return h;
    }

    public String toString() {
        return "CpuStats{cpuUsage=" + this.cpuUsage + ", systemCpuUsage=" + this.systemCpuUsage + ", throttlingData=" + this.throttlingData + "}";
    }

    public static ImmutableCpuStats copyOf(CpuStats instance) {
        if (instance instanceof ImmutableCpuStats) {
            return (ImmutableCpuStats)instance;
        }
        return ImmutableCpuStats.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_CPU_USAGE = 1L;
        private static final long INIT_BIT_THROTTLING_DATA = 2L;
        private long initBits = 3L;
        private CpuStats.CpuUsage cpuUsage;
        private Long systemCpuUsage;
        private CpuStats.ThrottlingData throttlingData;

        private Builder() {
        }

        public final Builder from(CpuStats instance) {
            Objects.requireNonNull(instance, "instance");
            this.cpuUsage(instance.cpuUsage());
            Long systemCpuUsageValue = instance.systemCpuUsage();
            if (systemCpuUsageValue != null) {
                this.systemCpuUsage(systemCpuUsageValue);
            }
            this.throttlingData(instance.throttlingData());
            return this;
        }

        @JsonProperty(value="cpu_usage")
        public final Builder cpuUsage(CpuStats.CpuUsage cpuUsage) {
            this.cpuUsage = Objects.requireNonNull(cpuUsage, "cpuUsage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="system_cpu_usage")
        public final Builder systemCpuUsage(@Nullable Long systemCpuUsage) {
            this.systemCpuUsage = systemCpuUsage;
            return this;
        }

        @JsonProperty(value="throttling_data")
        public final Builder throttlingData(CpuStats.ThrottlingData throttlingData) {
            this.throttlingData = Objects.requireNonNull(throttlingData, "throttlingData");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCpuStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCpuStats(this.cpuUsage, this.systemCpuUsage, this.throttlingData);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cpuUsage");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("throttlingData");
            }
            return "Cannot build CpuStats, some of required attributes are not set " + attributes;
        }
    }

    static final class CpuUsage
    implements CpuStats.CpuUsage {
        private final Long totalUsage;
        @Nullable
        private final List<Long> percpuUsage;
        private final Long usageInKernelmode;
        private final Long usageInUsermode;

        private CpuUsage(Long totalUsage, @Nullable List<Long> percpuUsage, Long usageInKernelmode, Long usageInUsermode) {
            this.totalUsage = totalUsage;
            this.percpuUsage = percpuUsage;
            this.usageInKernelmode = usageInKernelmode;
            this.usageInUsermode = usageInUsermode;
        }

        @Override
        @JsonProperty(value="total_usage")
        public Long totalUsage() {
            return this.totalUsage;
        }

        @Override
        @JsonProperty(value="percpu_usage")
        @Nullable
        public List<Long> percpuUsage() {
            return this.percpuUsage;
        }

        @Override
        @JsonProperty(value="usage_in_kernelmode")
        public Long usageInKernelmode() {
            return this.usageInKernelmode;
        }

        @Override
        @JsonProperty(value="usage_in_usermode")
        public Long usageInUsermode() {
            return this.usageInUsermode;
        }

        public final CpuUsage withTotalUsage(Long value) {
            Long newValue = Objects.requireNonNull(value, "totalUsage");
            if (this.totalUsage.equals(newValue)) {
                return this;
            }
            return new CpuUsage(newValue, this.percpuUsage, this.usageInKernelmode, this.usageInUsermode);
        }

        public final CpuUsage withPercpuUsage(long ... elements) {
            if (elements == null) {
                return new CpuUsage(this.totalUsage, null, this.usageInKernelmode, this.usageInUsermode);
            }
            ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
            for (long element : elements) {
                wrappedList.add(element);
            }
            List newValue = ImmutableCpuStats.createUnmodifiableList(false, wrappedList);
            return new CpuUsage(this.totalUsage, newValue, this.usageInKernelmode, this.usageInUsermode);
        }

        public final CpuUsage withPercpuUsage(@Nullable Iterable<Long> elements) {
            if (this.percpuUsage == elements) {
                return this;
            }
            List newValue = elements == null ? null : ImmutableCpuStats.createUnmodifiableList(false, ImmutableCpuStats.createSafeList(elements, true, false));
            return new CpuUsage(this.totalUsage, newValue, this.usageInKernelmode, this.usageInUsermode);
        }

        public final CpuUsage withUsageInKernelmode(Long value) {
            Long newValue = Objects.requireNonNull(value, "usageInKernelmode");
            if (this.usageInKernelmode.equals(newValue)) {
                return this;
            }
            return new CpuUsage(this.totalUsage, this.percpuUsage, newValue, this.usageInUsermode);
        }

        public final CpuUsage withUsageInUsermode(Long value) {
            Long newValue = Objects.requireNonNull(value, "usageInUsermode");
            if (this.usageInUsermode.equals(newValue)) {
                return this;
            }
            return new CpuUsage(this.totalUsage, this.percpuUsage, this.usageInKernelmode, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof CpuUsage && this.equalTo((CpuUsage)another);
        }

        private boolean equalTo(CpuUsage another) {
            return this.totalUsage.equals(another.totalUsage) && Objects.equals(this.percpuUsage, another.percpuUsage) && this.usageInKernelmode.equals(another.usageInKernelmode) && this.usageInUsermode.equals(another.usageInUsermode);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.totalUsage.hashCode();
            h += (h << 5) + Objects.hashCode(this.percpuUsage);
            h += (h << 5) + this.usageInKernelmode.hashCode();
            h += (h << 5) + this.usageInUsermode.hashCode();
            return h;
        }

        public String toString() {
            return "CpuUsage{totalUsage=" + this.totalUsage + ", percpuUsage=" + this.percpuUsage + ", usageInKernelmode=" + this.usageInKernelmode + ", usageInUsermode=" + this.usageInUsermode + "}";
        }

        public static CpuUsage copyOf(CpuStats.CpuUsage instance) {
            if (instance instanceof CpuUsage) {
                return (CpuUsage)instance;
            }
            return CpuUsage.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_TOTAL_USAGE = 1L;
            private static final long INIT_BIT_USAGE_IN_KERNELMODE = 2L;
            private static final long INIT_BIT_USAGE_IN_USERMODE = 4L;
            private long initBits = 7L;
            private Long totalUsage;
            private List<Long> percpuUsage = null;
            private Long usageInKernelmode;
            private Long usageInUsermode;

            private Builder() {
            }

            public final Builder from(CpuStats.CpuUsage instance) {
                Objects.requireNonNull(instance, "instance");
                this.totalUsage(instance.totalUsage());
                List<Long> percpuUsageValue = instance.percpuUsage();
                if (percpuUsageValue != null) {
                    this.addAllPercpuUsage(percpuUsageValue);
                }
                this.usageInKernelmode(instance.usageInKernelmode());
                this.usageInUsermode(instance.usageInUsermode());
                return this;
            }

            @JsonProperty(value="total_usage")
            public final Builder totalUsage(Long totalUsage) {
                this.totalUsage = Objects.requireNonNull(totalUsage, "totalUsage");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public final Builder percpuUsage(long element) {
                if (this.percpuUsage == null) {
                    this.percpuUsage = new ArrayList<Long>();
                }
                this.percpuUsage.add(element);
                return this;
            }

            public final Builder percpuUsage(long ... elements) {
                if (this.percpuUsage == null) {
                    this.percpuUsage = new ArrayList<Long>();
                }
                for (long element : elements) {
                    this.percpuUsage.add(element);
                }
                return this;
            }

            @JsonProperty(value="percpu_usage")
            public final Builder percpuUsage(@Nullable Iterable<Long> elements) {
                if (elements == null) {
                    this.percpuUsage = null;
                    return this;
                }
                this.percpuUsage = new ArrayList<Long>();
                return this.addAllPercpuUsage(elements);
            }

            public final Builder addAllPercpuUsage(Iterable<Long> elements) {
                Objects.requireNonNull(elements, "percpuUsage element");
                if (this.percpuUsage == null) {
                    this.percpuUsage = new ArrayList<Long>();
                }
                for (long element : elements) {
                    this.percpuUsage.add(Objects.requireNonNull(Long.valueOf(element), "percpuUsage element"));
                }
                return this;
            }

            @JsonProperty(value="usage_in_kernelmode")
            public final Builder usageInKernelmode(Long usageInKernelmode) {
                this.usageInKernelmode = Objects.requireNonNull(usageInKernelmode, "usageInKernelmode");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @JsonProperty(value="usage_in_usermode")
            public final Builder usageInUsermode(Long usageInUsermode) {
                this.usageInUsermode = Objects.requireNonNull(usageInUsermode, "usageInUsermode");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public CpuUsage build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new CpuUsage(this.totalUsage, this.percpuUsage == null ? null : ImmutableCpuStats.createUnmodifiableList(true, this.percpuUsage), this.usageInKernelmode, this.usageInUsermode);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("totalUsage");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("usageInKernelmode");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("usageInUsermode");
                }
                return "Cannot build CpuUsage, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class ThrottlingData
    implements CpuStats.ThrottlingData {
        private final Long periods;
        private final Long throttledPeriods;
        private final Long throttledTime;

        private ThrottlingData(Long periods, Long throttledPeriods, Long throttledTime) {
            this.periods = periods;
            this.throttledPeriods = throttledPeriods;
            this.throttledTime = throttledTime;
        }

        @Override
        @JsonProperty(value="periods")
        public Long periods() {
            return this.periods;
        }

        @Override
        @JsonProperty(value="throttled_periods")
        public Long throttledPeriods() {
            return this.throttledPeriods;
        }

        @Override
        @JsonProperty(value="throttled_time")
        public Long throttledTime() {
            return this.throttledTime;
        }

        public final ThrottlingData withPeriods(Long value) {
            Long newValue = Objects.requireNonNull(value, "periods");
            if (this.periods.equals(newValue)) {
                return this;
            }
            return new ThrottlingData(newValue, this.throttledPeriods, this.throttledTime);
        }

        public final ThrottlingData withThrottledPeriods(Long value) {
            Long newValue = Objects.requireNonNull(value, "throttledPeriods");
            if (this.throttledPeriods.equals(newValue)) {
                return this;
            }
            return new ThrottlingData(this.periods, newValue, this.throttledTime);
        }

        public final ThrottlingData withThrottledTime(Long value) {
            Long newValue = Objects.requireNonNull(value, "throttledTime");
            if (this.throttledTime.equals(newValue)) {
                return this;
            }
            return new ThrottlingData(this.periods, this.throttledPeriods, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ThrottlingData && this.equalTo((ThrottlingData)another);
        }

        private boolean equalTo(ThrottlingData another) {
            return this.periods.equals(another.periods) && this.throttledPeriods.equals(another.throttledPeriods) && this.throttledTime.equals(another.throttledTime);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.periods.hashCode();
            h += (h << 5) + this.throttledPeriods.hashCode();
            h += (h << 5) + this.throttledTime.hashCode();
            return h;
        }

        public String toString() {
            return "ThrottlingData{periods=" + this.periods + ", throttledPeriods=" + this.throttledPeriods + ", throttledTime=" + this.throttledTime + "}";
        }

        public static ThrottlingData copyOf(CpuStats.ThrottlingData instance) {
            if (instance instanceof ThrottlingData) {
                return (ThrottlingData)instance;
            }
            return ThrottlingData.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_PERIODS = 1L;
            private static final long INIT_BIT_THROTTLED_PERIODS = 2L;
            private static final long INIT_BIT_THROTTLED_TIME = 4L;
            private long initBits = 7L;
            private Long periods;
            private Long throttledPeriods;
            private Long throttledTime;

            private Builder() {
            }

            public final Builder from(CpuStats.ThrottlingData instance) {
                Objects.requireNonNull(instance, "instance");
                this.periods(instance.periods());
                this.throttledPeriods(instance.throttledPeriods());
                this.throttledTime(instance.throttledTime());
                return this;
            }

            @JsonProperty(value="periods")
            public final Builder periods(Long periods) {
                this.periods = Objects.requireNonNull(periods, "periods");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="throttled_periods")
            public final Builder throttledPeriods(Long throttledPeriods) {
                this.throttledPeriods = Objects.requireNonNull(throttledPeriods, "throttledPeriods");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @JsonProperty(value="throttled_time")
            public final Builder throttledTime(Long throttledTime) {
                this.throttledTime = Objects.requireNonNull(throttledTime, "throttledTime");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public ThrottlingData build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new ThrottlingData(this.periods, this.throttledPeriods, this.throttledTime);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("periods");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("throttledPeriods");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("throttledTime");
                }
                return "Cannot build ThrottlingData, some of required attributes are not set " + attributes;
            }
        }
    }
}

