/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.core;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.autotools.core.AutotoolsNewProjectNature;
import org.eclipse.cdt.autotools.core.IAutotoolsOption;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfigurationManager;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AutotoolsPlugin
extends AbstractUIPlugin {
    private static AutotoolsPlugin plugin;
    private ResourceBundle resourceBundle;
    public static final String PLUGIN_ID = "org.eclipse.cdt.autotools.core";
    public static final String AUTOTOOLS_PROJECT_TYPE_ID = "org.eclipse.linuxtools.cdt.autotools.core.projectType";

    public AutotoolsPlugin() {
        Assert.isTrue((plugin == null ? 1 : 0) != 0);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.autotools.core.Resources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static String getUniqueIdentifier() {
        if (AutotoolsPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return AutotoolsPlugin.getDefault().getBundle().getSymbolicName();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static AutotoolsPlugin getDefault() {
        return plugin;
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AutotoolsPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(AutotoolsPlugin.getResourceString(key), args);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static boolean hasTargetBuilder(IProject project) {
        try {
            IManagedBuildInfo info;
            IManagedProject m;
            if (project.getNature(ManagedCProjectNature.MNG_NATURE_ID) != null && (m = (info = ManagedBuildManager.getBuildInfo((IResource)project)).getManagedProject()) != null && m.getProjectType().getId().equals(AUTOTOOLS_PROJECT_TYPE_ID)) {
                AutotoolsNewProjectNature.addAutotoolsBuilder(project, (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        AutotoolsPlugin.log((IStatus)new Status(4, AutotoolsPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, AutotoolsPlugin.getUniqueIdentifier(), 0, e.getMessage(), e);
        AutotoolsPlugin.log(status);
    }

    public Map<String, IAutotoolsOption> getAutotoolCfgOptions(IProject project, String cfgId) throws CoreException {
        return AutotoolsConfigurationManager.getInstance().getAutotoolsCfgOptions(project, cfgId);
    }

    public void updateAutotoolCfgOptions(IProject project, String cfgId, Map<String, IAutotoolsOption> options) throws CoreException {
        AutotoolsConfigurationManager.getInstance().updateAutotoolCfgOptions(project, cfgId, options);
    }
}

