/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogColumn;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogView;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWIndex;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.impl.PrimaryKeyImpl;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogPrimaryKey
extends PrimaryKeyImpl
implements ICatalogObject {
    private boolean memberLoaded = false;
    private boolean dependencyLoaded = false;

    public void refresh() {
        if (this.memberLoaded) {
            this.members.clear();
            this.memberLoaded = false;
        }
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public EList getMembers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getMembers();
        }
        if (!this.memberLoaded) {
            this.loadMembers();
        }
        return this.members;
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 12) {
            this.getMembers();
        } else if (id == 2) {
            this.getDependencies();
        }
        return super.eIsSet(eFeature);
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    private synchronized void loadMembers() {
        if (this.memberLoaded) {
            return;
        }
        this.memberLoaded = true;
        EList memberList = super.getMembers();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        LUWIndex index = this.getImplementIndex();
        if (index != null) {
            for (IndexMember indexMemeber : index.getMembers()) {
                memberList.add((Object)indexMemeber.getColumn());
            }
        } else {
            try {
                Connection connection = this.getConnection();
                if (connection == null) {
                    return;
                }
                Statement s = connection.createStatement();
                ResultSet r = s.executeQuery("SELECT COLNAME FROM SYSCAT.KEYCOLUSE" + this.getWhereClause());
                while (r.next()) {
                    String colName = r.getString(1);
                    memberList.add((Object)this.getColumn(colName));
                }
                r.close();
                s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogPrimaryKey.loadDependencies(this.getConnection(), super.getDependencies(), (Constraint)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private String getWhereClause() {
        this.getBaseTable();
        return " WHERE CONSTNAME='" + LUWUtil.getIdentifier(this.getName()) + "' AND TABSCHEMA='" + LUWUtil.getIdentifier(this.getBaseTable().getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(this.getBaseTable().getName()) + "' ORDER BY COLSEQ";
    }

    private Column getColumn(String columnName) {
        Column c;
        BaseTable table = this.getBaseTable();
        if (table instanceof LUWCatalogTable && (c = ((LUWCatalogTable)table).getColumn(columnName)) != null) {
            return c;
        }
        for (Column c2 : table.getColumns()) {
            if (!c2.getName().equals(columnName)) continue;
            return c2;
        }
        LUWCatalogColumn column = new LUWCatalogColumn();
        column.setName(columnName);
        column.setTable((Table)table);
        Database database = table.getSchema().getDatabase();
        DatabaseDefinition def = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        CharacterStringDataType dataType = (CharacterStringDataType)def.getPredefinedDataType("Char");
        dataType.setLength(5);
        column.setContainedType((SQLDataType)dataType);
        return column;
    }

    public static void loadDependencies(Connection connection, EList dependencyList, Constraint constraint) throws SQLException {
        Table table = (Table)constraint.eContainer();
        Database database = table.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery("SELECT BSCHEMA, BNAME, BTYPE FROM SYSCAT.CONSTDEP WHERE CONSTNAME='" + LUWUtil.getIdentifier(constraint.getName()) + "' AND TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'");
        try {
            while (r.next()) {
                String bschema = r.getString(1).trim();
                String bname = r.getString(2);
                String btype = r.getString(3);
                Routine obj = null;
                if (btype.equals("F")) {
                    obj = LUWCatalogView.getRountine(table, bschema, bname);
                }
                if (btype.equals("I")) {
                    obj = LUWCatalogView.getIndex(table, bschema, bname);
                }
                if (!btype.equals("R") || (obj = LUWCatalogView.getUserDefinedType(table, bschema, bname)) == null) continue;
                Dependency dep = (Dependency)factory.create(SQLSchemaPackage.eINSTANCE.getDependency());
                dep.setTargetEnd((EObject)obj);
                dependencyList.add((Object)dep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private LUWIndex getImplementIndex() {
        for (LUWIndex index : this.getBaseTable().getIndex()) {
            if (!(index instanceof LUWCatalogIndex) || ((LUWCatalogIndex)index).getIndexUniqueRule() != LUWCatalogIndex.IndexUniqueRule.PRIMARYKEY) continue;
            return index;
        }
        return null;
    }
}

