/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.UnitOfWork;
import org.eclipse.egit.core.info.GitItemState;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.info.GitItemStateFactory;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.DecoratorRepositoryStateCache;
import org.eclipse.egit.ui.internal.decorators.GitDecorator;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.repository.RefCache;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class RepositoryTreeNodeDecorator
extends GitDecorator
implements IStateListener {
    private static final String HAS_CHANGES_PREFIX = "> ";
    private static final String OPEN_BRACKET = " [";
    private static final String OPEN_PARENTHESIS = " (";
    private static final String MULTIPLE_REPOSITORIES = "*";
    private final State verboseBranchModeState;
    private boolean verboseBranchMode = false;
    private final RefCache.Cache refCache = RefCache.get();

    public RepositoryTreeNodeDecorator() {
        ICommandService srv = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.verboseBranchModeState = srv.getCommand("org.eclipse.egit.ui.RepositoriesToggleBranchCommit").getState("org.eclipse.ui.commands.toggleState");
        this.verboseBranchModeState.addListener((IStateListener)this);
        try {
            this.verboseBranchMode = (Boolean)this.verboseBranchModeState.getValue();
        }
        catch (Exception e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    @Override
    public void dispose() {
        this.verboseBranchModeState.removeListener((IStateListener)this);
        this.refCache.dispose();
        super.dispose();
    }

    public void handleStateChange(State state, Object oldValue) {
        try {
            boolean newValue = (Boolean)state.getValue();
            if (newValue != this.verboseBranchMode) {
                this.verboseBranchMode = newValue;
                this.postLabelEvent();
            }
        }
        catch (Exception e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        Repository repository = node.getRepository();
        if (repository != null) {
            UnitOfWork.execute((Repository)repository, () -> this.decorateNode(node, repository, decoration));
        } else if (node.getType() == RepositoryTreeNodeType.REPOGROUP) {
            this.decorateRepositoryGroup(node, decoration);
        }
    }

    private void decorateNode(RepositoryTreeNode<?> node, @NonNull Repository repository, IDecoration decoration) {
        try {
            this.decorateText(node, repository, decoration);
            this.decorateIcon(node, repository, decoration);
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(UIText.GitLabelProvider_UnableToRetrieveLabel, node.toString()), e);
        }
    }

    private void decorateIcon(RepositoryTreeNode<?> node, @NonNull Repository repository, IDecoration decoration) throws IOException {
        switch (node.getType()) {
            case TAG: {
                String branchName = DecoratorRepositoryStateCache.INSTANCE.getFullBranchName(repository);
                if (branchName == null) {
                    return;
                }
                if (!branchName.equals(((TagNode)node).getCommitId())) break;
                decoration.addOverlay(UIIcons.OVR_CHECKEDOUT, 0);
                break;
            }
            case ADDITIONALREF: {
                Ref ref = this.refCache.findAdditional(repository, ((Ref)node.getObject()).getName());
                if (ref == null) break;
                this.decorateRefIcon(repository, ref, decoration);
                break;
            }
            case REF: {
                Ref ref = this.refCache.exact(repository, ((Ref)node.getObject()).getName());
                if (ref == null) break;
                this.decorateRefIcon(repository, ref, decoration);
                break;
            }
            case FOLDER: 
            case FILE: 
            case WORKINGDIR: {
                this.decorateConflict(node.getPath().toFile(), decoration);
                break;
            }
        }
    }

    private void decorateRefIcon(@NonNull Repository repository, Ref ref, IDecoration decoration) {
        String branchName = DecoratorRepositoryStateCache.INSTANCE.getFullBranchName(repository);
        if (branchName == null) {
            return;
        }
        String refName = ref.getName();
        Ref leaf = ref.getLeaf();
        String compareString = null;
        if (refName.startsWith("refs/heads/")) {
            compareString = refName;
        } else if (refName.startsWith("refs/remotes/")) {
            String leafName;
            ObjectId objectId = leaf.getObjectId();
            if (objectId != null && (leafName = objectId.getName()).equals(branchName)) {
                decoration.addOverlay(UIIcons.OVR_CHECKEDOUT, 0);
                return;
            }
        } else {
            if (refName.equals("HEAD")) {
                decoration.addOverlay(UIIcons.OVR_CHECKEDOUT, 0);
                return;
            }
            String leafname = leaf.getName();
            if (leafname.startsWith("refs/") && leafname.equals(branchName)) {
                decoration.addOverlay(UIIcons.OVR_CHECKEDOUT, 0);
                return;
            }
            ObjectId objectId = leaf.getObjectId();
            if (objectId != null && objectId.equals((AnyObjectId)DecoratorRepositoryStateCache.INSTANCE.getHead(repository))) {
                decoration.addOverlay(UIIcons.OVR_CHECKEDOUT, 0);
            }
            return;
        }
        if (branchName.equals(compareString)) {
            decoration.addOverlay(UIIcons.OVR_CHECKEDOUT, 0);
        }
    }

    private void decorateConflict(File file, IDecoration decoration) {
        GitItemState state = GitItemStateFactory.getInstance().get(file);
        if (state.hasConflicts()) {
            decoration.addOverlay(UIIcons.OVR_CONFLICT);
        }
    }

    private void decorateText(RepositoryTreeNode<?> node, @NonNull Repository repository, IDecoration decoration) throws IOException {
        switch (node.getType()) {
            case REPO: {
                this.decorateRepository(node, repository, decoration);
                break;
            }
            case ADDITIONALREF: {
                this.decorateAdditionalRef((AdditionalRefNode)node, decoration);
                break;
            }
            case REF: {
                this.decorateRef((RefNode)node, decoration);
                break;
            }
            case TAG: {
                this.decorateTag((TagNode)node, decoration);
                break;
            }
            case STASHED_COMMIT: {
                this.decorateStash((StashedCommitNode)node, decoration);
                break;
            }
            case SUBMODULES: {
                this.decorateSubmodules(repository, decoration);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void decorateAdditionalRef(AdditionalRefNode node, IDecoration decoration) throws IOException {
        String name = ((Ref)node.getObject()).getName();
        Ref ref = this.refCache.findAdditional(node.getRepository(), name);
        if (ref == null) {
            return;
        }
        StringBuilder suffix = new StringBuilder();
        if (ref.isSymbolic()) {
            suffix.append(OPEN_BRACKET).append(ref.getLeaf().getName()).append(']');
        }
        ObjectId refId = ref.getObjectId();
        suffix.append(' ');
        RevCommit commit = this.getLatestCommit(node.getRepository(), ref);
        if (commit != null) {
            suffix.append(this.abbreviate((ObjectId)commit)).append(' ').append(commit.getShortMessage());
        } else if (!ref.isSymbolic() || refId != null) {
            suffix.append(this.abbreviate(refId));
        } else {
            suffix.append(UIText.RepositoriesViewLabelProvider_UnbornBranchText);
        }
        decoration.addSuffix(suffix.toString());
    }

    private void decorateRef(RefNode node, IDecoration decoration) throws IOException {
        if (this.verboseBranchMode) {
            Ref ref = this.refCache.exact(node.getRepository(), ((Ref)node.getObject()).getName());
            if (ref == null) {
                return;
            }
            RevCommit latest = this.getLatestCommit(node.getRepository(), ref);
            if (latest != null) {
                decoration.addSuffix(" " + this.abbreviate((ObjectId)latest) + ' ' + latest.getShortMessage());
            }
        }
    }

    private void decorateRepository(RepositoryTreeNode<?> node, @NonNull Repository repository, IDecoration decoration) {
        boolean isSubModule;
        boolean bl = isSubModule = node.getParent() != null && node.getParent().getType() == RepositoryTreeNodeType.SUBMODULES;
        if (RepositoryUtil.hasChanges((Repository)repository)) {
            decoration.addPrefix(HAS_CHANGES_PREFIX);
        }
        StringBuilder suffix = new StringBuilder();
        if (isSubModule) {
            RevCommit commit;
            Ref head = DecoratorRepositoryStateCache.INSTANCE.getHeadRef(repository);
            if (head == null) {
                return;
            }
            suffix.append(OPEN_BRACKET);
            if (head.isSymbolic()) {
                suffix.append(Repository.shortenRefName((String)head.getLeaf().getName()));
            } else if (head.getObjectId() != null) {
                suffix.append(this.abbreviate(head.getObjectId()));
            }
            suffix.append(']');
            if (this.verboseBranchMode && head.getObjectId() != null && (commit = DecoratorRepositoryStateCache.INSTANCE.getHeadCommit(repository)) != null) {
                suffix.append(' ').append(commit.getShortMessage());
            }
        } else {
            RepositoryState repositoryState;
            String branch = DecoratorRepositoryStateCache.INSTANCE.getCurrentBranchLabel(repository);
            if (branch == null) {
                return;
            }
            suffix.append(OPEN_BRACKET);
            suffix.append(branch);
            String trackingStatus = DecoratorRepositoryStateCache.INSTANCE.getBranchStatus(repository);
            if (trackingStatus != null) {
                suffix.append(' ').append(trackingStatus);
            }
            if ((repositoryState = DecoratorRepositoryStateCache.INSTANCE.getRepositoryState(repository)) != RepositoryState.SAFE) {
                suffix.append(" - ").append(repositoryState.getDescription());
            }
            suffix.append(']');
        }
        decoration.addSuffix(suffix.toString());
    }

    private void decorateRepositoryGroup(RepositoryTreeNode<?> node, IDecoration decoration) {
        RepositoryGroup group = (RepositoryGroup)((RepositoryGroupNode)node).getObject();
        boolean markGroupDirty = false;
        int numberOfBranches = 0;
        String singleBranch = null;
        String singleRepoName = null;
        int numberOfDirectories = group.getRepositoryDirectories().size();
        for (File repoDir : group.getRepositoryDirectories()) {
            Repository repo = RepositoryCache.INSTANCE.getRepository(repoDir);
            if (repo == null) continue;
            if (numberOfDirectories == 1) {
                singleRepoName = DecoratorRepositoryStateCache.INSTANCE.getRepositoryNameAndState(repo);
            }
            if (!markGroupDirty && RepositoryUtil.hasChanges((Repository)repo)) {
                markGroupDirty = true;
            }
            if (numberOfBranches <= 1) {
                String thisBranch = Repository.shortenRefName((String)DecoratorRepositoryStateCache.INSTANCE.getFullBranchName(repo));
                if (!thisBranch.equals(singleBranch)) {
                    ++numberOfBranches;
                }
                if (singleBranch == null) {
                    singleBranch = thisBranch;
                }
            }
            if (markGroupDirty && numberOfBranches > 1) break;
        }
        if (markGroupDirty) {
            decoration.addPrefix(HAS_CHANGES_PREFIX);
        }
        if (numberOfBranches == 1) {
            String repoLabel = singleRepoName != null ? singleRepoName : MULTIPLE_REPOSITORIES;
            decoration.addSuffix(OPEN_BRACKET + repoLabel + ' ' + singleBranch + ']');
        } else if (numberOfDirectories > 1) {
            decoration.addSuffix(OPEN_PARENTHESIS + numberOfDirectories + ')');
        }
    }

    private void decorateStash(StashedCommitNode node, IDecoration decoration) {
        RevCommit commit = (RevCommit)node.getObject();
        decoration.addSuffix(OPEN_BRACKET + this.abbreviate((ObjectId)commit) + "] " + commit.getShortMessage());
    }

    private void decorateSubmodules(@NonNull Repository repository, IDecoration decoration) {
        if (this.haveSubmoduleChanges(repository)) {
            decoration.addPrefix(HAS_CHANGES_PREFIX);
        }
    }

    private void decorateTag(TagNode node, IDecoration decoration) {
        if (this.verboseBranchMode && node.getCommitId() != null && node.getCommitId().length() > 0) {
            decoration.addSuffix(" " + node.getCommitId().substring(0, 7) + ' ' + node.getCommitShortMessage());
        }
    }

    private RevCommit getLatestCommit(Repository repository, Ref ref) {
        ObjectId id = ref.isSymbolic() ? ref.getLeaf().getObjectId() : ref.getObjectId();
        if (id == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk walk = new RevWalk(repository);){
                walk.setRetainBody(true);
                return walk.parseCommit((AnyObjectId)id);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private String abbreviate(ObjectId id) {
        if (id != null) {
            return Utils.getShortObjectId((ObjectId)id);
        }
        return Utils.getShortObjectId((ObjectId)ObjectId.zeroId());
    }

    private boolean haveSubmoduleChanges(@NonNull Repository repository) {
        IndexDiffData data;
        IndexDiffCacheEntry entry = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repository);
        IndexDiffData indexDiffData = data = entry != null ? entry.getIndexDiff() : null;
        if (data == null) {
            return false;
        }
        Set modified = data.getModified();
        return data.getSubmodules().stream().anyMatch(modified::contains);
    }

    @Override
    protected String getName() {
        return UIText.RepositoryTreeNodeDecorator_name;
    }
}

