/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.notifications.AbstractNotificationPopup;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ServerMessageHandler {
    private ServerMessageHandler() {
    }

    public static void logMessage(LanguageServerWrapper wrapper, MessageParams params) {
        StringBuilder log = new StringBuilder();
        log.append('[');
        log.append(params.getType().toString());
        log.append(']');
        log.append('\t');
        log.append(params.getMessage());
        switch (params.getType()) {
            case Error: {
                LanguageServerPlugin.logError(log.toString(), null);
                break;
            }
            case Warning: {
                LanguageServerPlugin.logWarning(log.toString(), null);
                break;
            }
            default: {
                LanguageServerPlugin.logInfo(log.toString());
            }
        }
    }

    public static void showMessage(String title, MessageParams params) {
        Display.getDefault().asyncExec(() -> {
            LSPNotification notification = new LSPNotification(String.format("LSP (%s)", title), params);
            notification.open();
        });
    }

    public static CompletableFuture<MessageActionItem> showMessageRequest(LanguageServerWrapper wrapper, ShowMessageRequestParams params) {
        String[] options = (String[])params.getActions().stream().map(MessageActionItem::getTitle).toArray(String[]::new);
        CompletableFuture<MessageActionItem> future = new CompletableFuture<MessageActionItem>();
        Display.getDefault().asyncExec(() -> {
            Shell shell = new Shell(Display.getCurrent());
            MessageDialog dialog = new MessageDialog(shell, languageServerWrapper.serverDefinition.label, null, params.getMessage(), 2, 0, options);
            MessageActionItem result = new MessageActionItem();
            int dialogResult = dialog.open();
            if (dialogResult != -1) {
                result.setTitle(options[dialogResult]);
            }
            future.complete(result);
        });
        return future;
    }

    private static class LSPNotification
    extends AbstractNotificationPopup {
        private final String label;
        private final MessageParams messageParams;

        public LSPNotification(String label, MessageParams messageParams) {
            super(Display.getCurrent());
            this.setParentShell(UI.getActiveShell());
            this.label = label;
            this.messageParams = messageParams;
        }

        public String getPopupShellTitle() {
            return this.label;
        }

        protected void createContentArea(Composite parent) {
            Label label = new Label(parent, 64);
            label.setText(this.messageParams.getMessage());
        }

        public Image getPopupShellImage(int maximumHeight) {
            switch (this.messageParams.getType()) {
                case Error: {
                    return LSPImages.getSharedImage("IMG_OBJS_ERROR_TSK");
                }
                case Warning: {
                    return LSPImages.getSharedImage("IMG_OBJS_WARN_TSK");
                }
                case Info: {
                    return LSPImages.getSharedImage("IMG_OBJS_INFO_TSK");
                }
            }
            return null;
        }
    }
}

