/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codelens;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4e.operations.codelens.CodeLensProvider;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.events.MouseEvent;

public class LSPCodeMining
extends LineHeaderCodeMining {
    private CodeLens codeLens;
    private final LanguageServer languageServer;
    private final LanguageServersRegistry.LanguageServerDefinition languageServerDefinition;
    private final @Nullable IDocument document;

    public LSPCodeMining(CodeLens codeLens, IDocument document, LanguageServer languageServer, LanguageServersRegistry.LanguageServerDefinition languageServerDefinition, CodeLensProvider provider) throws BadLocationException {
        super(codeLens.getRange().getStart().getLine(), document, (ICodeMiningProvider)provider, null);
        this.codeLens = codeLens;
        this.languageServer = languageServer;
        this.languageServerDefinition = languageServerDefinition;
        this.document = document;
        this.setLabel(LSPCodeMining.getCodeLensString(codeLens));
    }

    protected static @Nullable String getCodeLensString(@NonNull CodeLens codeLens) {
        Command command = codeLens.getCommand();
        if (command == null || command.getTitle().isEmpty()) {
            return null;
        }
        return command.getTitle();
    }

    protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        if (!LanguageServiceAccessor.checkCapability(this.languageServer, capabilites -> capabilites.getCodeLensProvider().getResolveProvider())) {
            return CompletableFuture.completedFuture(null);
        }
        return this.languageServer.getTextDocumentService().resolveCodeLens(this.codeLens).thenAcceptAsync(resolvedCodeLens -> {
            this.codeLens = resolvedCodeLens;
            this.setLabel(LSPCodeMining.getCodeLensString(resolvedCodeLens));
        });
    }

    public final Consumer<MouseEvent> getAction() {
        Command command = this.codeLens.getCommand();
        if (command != null && command.getCommand() != null) {
            return this::performAction;
        }
        return null;
    }

    private void performAction(MouseEvent mouseEvent) {
        IDocument document = this.document;
        if (document != null) {
            CommandExecutor.executeCommand(this.codeLens.getCommand(), document, this.languageServerDefinition.id);
        }
    }
}

