/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.pde.MavenTargetLocation;
import org.eclipse.m2e.pde.ui.editor.Messages;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IIdentifiable;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTreeViewer;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.feature.BasePluginListPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class PluginListPage
extends BasePluginListPage {
    private CheckboxTreeViewer pluginViewer;
    private static final String S_INIT_LAUNCH = "initLaunch";
    private MavenTargetLocation targetLocation;
    private Map<String, String> id2version = new HashMap<String, String>();

    public PluginListPage(MavenTargetLocation targetLocation) {
        super("pluginListPage");
        this.targetLocation = targetLocation;
        this.setTitle(Messages.NewFeatureWizard_PlugPage_title);
        this.setDescription(Messages.NewFeatureWizard_PlugPage_desc);
    }

    public void createControl(Composite parent) {
        IFeature featureTemplate;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        this.treePart.createControl(container, 4, true);
        this.pluginViewer = this.treePart.getTreeViewer();
        PluginContentProvider provider = new PluginContentProvider();
        this.pluginViewer.setContentProvider((IContentProvider)provider);
        this.pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        GridData gd = (GridData)this.treePart.getControl().getLayoutData();
        gd.horizontalIndent = 0;
        gd.heightHint = 250;
        gd.widthHint = 300;
        this.pluginViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.treePart.setSelection(new Object[0]);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.new_feature_referenced_plugins");
        this.pluginViewer.addDoubleClickListener(event -> {
            TreeItem firstTI = this.pluginViewer.getTree().getSelection()[0];
            this.treePart.getTreeViewer().setChecked(firstTI.getData(), !firstTI.getChecked());
            this.treePart.updateCounterLabel();
        });
        if (this.targetLocation != null && (featureTemplate = this.targetLocation.getFeatureTemplate()) != null) {
            Map<String, List<IFeaturePlugin>> map = Arrays.stream(featureTemplate.getPlugins()).collect(Collectors.groupingBy(IIdentifiable::getId));
            TreeItem[] items = this.pluginViewer.getTree().getItems();
            CachedCheckboxTreeViewer treeViewer = this.treePart.getTreeViewer();
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                IPluginModelBase model = (IPluginModelBase)item.getData();
                String id = model.getPluginBase().getId();
                List list = map.getOrDefault(id, Collections.emptyList());
                if (list.size() > 0) {
                    treeViewer.setChecked((Object)model, true);
                    String definedVersions = list.stream().map(fp -> fp.getVersion()).filter(v -> !"0.0.0".equals(v)).findAny().orElse(null);
                    if (definedVersions != null) {
                        this.id2version.put(id, definedVersions);
                    }
                }
                ++n2;
            }
        }
    }

    public void update(IFeatureModel featureModel) throws CoreException {
        Object[] selected = this.treePart.getTreeViewer().getCheckedLeafElements();
        IFeaturePlugin[] added = new IFeaturePlugin[selected.length];
        int i = 0;
        while (i < selected.length) {
            IPluginBase plugin = ((IPluginModelBase)selected[i]).getPluginBase();
            FeaturePlugin fplugin = (FeaturePlugin)featureModel.getFactory().createPlugin();
            fplugin.loadFrom(plugin);
            fplugin.setVersion(this.id2version.getOrDefault(plugin.getId(), "0.0.0"));
            fplugin.setUnpack(CoreUtility.guessUnpack((BundleDescription)plugin.getPluginModel().getBundleDescription()));
            added[i] = fplugin;
            ++i;
        }
        IFeature feature = featureModel.getFeature();
        feature.removePlugins(feature.getPlugins());
        feature.addPlugins(added);
    }

    class PluginContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return this.getModels();
        }

        private IPluginModelBase[] getModels() {
            return PluginRegistry.getActiveModels();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && !PDECore.getDefault().areModelsInitialized()) {
                try {
                    PluginListPage.this.getContainer().run(true, false, monitor -> {
                        PDECore.getDefault().getModelManager().targetReloaded(monitor);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {}
            }
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

