/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.binding;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.DragBinding;
import org.eclipse.nebula.widgets.nattable.ui.binding.IUiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.binding.KeyBinding;
import org.eclipse.nebula.widgets.nattable.ui.binding.MouseBinding;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IKeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class UiBindingRegistry
implements IUiBindingRegistry {
    private static final Log log = LogFactory.getLog(UiBindingRegistry.class);
    private NatTable natTable;
    private LinkedList<KeyBinding> keyBindings = new LinkedList();
    private Map<MouseEventTypeEnum, LinkedList<MouseBinding>> mouseBindingsMap = new HashMap<MouseEventTypeEnum, LinkedList<MouseBinding>>();
    private LinkedList<DragBinding> dragBindings = new LinkedList();

    public UiBindingRegistry(NatTable natTable) {
        this.natTable = natTable;
    }

    @Override
    public IKeyAction getKeyEventAction(KeyEvent event) {
        for (KeyBinding keyBinding : this.keyBindings) {
            if (!keyBinding.getKeyEventMatcher().matches(event)) continue;
            return keyBinding.getAction();
        }
        return null;
    }

    @Override
    public IDragMode getDragMode(MouseEvent event) {
        LabelStack regionLabels = this.natTable.getRegionLabelsByXY(event.x, event.y);
        for (DragBinding dragBinding : this.dragBindings) {
            if (!dragBinding.getMouseEventMatcher().matches(this.natTable, event, regionLabels)) continue;
            return dragBinding.getDragMode();
        }
        return null;
    }

    @Override
    public IMouseAction getMouseMoveAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_MOVE, event);
    }

    @Override
    public IMouseAction getMouseDownAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_DOWN, event);
    }

    @Override
    public IMouseAction getSingleClickAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_SINGLE_CLICK, event);
    }

    @Override
    public IMouseAction getDoubleClickAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_DOUBLE_CLICK, event);
    }

    @Override
    public IMouseAction getMouseHoverAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_HOVER, event);
    }

    @Override
    public IMouseAction getMouseEnterAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_ENTER, event);
    }

    @Override
    public IMouseAction getMouseExitAction(MouseEvent event) {
        return this.getMouseEventAction(MouseEventTypeEnum.MOUSE_EXIT, event);
    }

    private IMouseAction getMouseEventAction(MouseEventTypeEnum mouseEventType, MouseEvent event) {
        try {
            LinkedList<MouseBinding> mouseEventBindings = this.mouseBindingsMap.get((Object)mouseEventType);
            if (mouseEventBindings != null) {
                LabelStack regionLabels = this.natTable.getRegionLabelsByXY(event.x, event.y);
                for (MouseBinding mouseBinding : mouseEventBindings) {
                    if (!mouseBinding.getMouseEventMatcher().matches(this.natTable, event, regionLabels)) continue;
                    return mouseBinding.getAction();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception on retrieving a mouse event action", (Throwable)e);
        }
        return null;
    }

    public void registerFirstKeyBinding(IKeyEventMatcher keyMatcher, IKeyAction action) {
        this.keyBindings.addFirst(new KeyBinding(keyMatcher, action));
    }

    public void registerKeyBinding(IKeyEventMatcher keyMatcher, IKeyAction action) {
        this.keyBindings.addLast(new KeyBinding(keyMatcher, action));
    }

    public void unregisterKeyBinding(IKeyEventMatcher keyMatcher) {
        for (KeyBinding keyBinding : this.keyBindings) {
            if (!keyBinding.getKeyEventMatcher().equals(keyMatcher)) continue;
            this.keyBindings.remove(keyBinding);
            return;
        }
    }

    public void registerFirstMouseDragMode(IMouseEventMatcher mouseEventMatcher, IDragMode dragMode) {
        this.dragBindings.addFirst(new DragBinding(mouseEventMatcher, dragMode));
    }

    public void registerMouseDragMode(IMouseEventMatcher mouseEventMatcher, IDragMode dragMode) {
        this.dragBindings.addLast(new DragBinding(mouseEventMatcher, dragMode));
    }

    public void unregisterMouseDragMode(IMouseEventMatcher mouseEventMatcher) {
        for (DragBinding dragBinding : this.dragBindings) {
            if (!dragBinding.getMouseEventMatcher().equals(mouseEventMatcher)) continue;
            this.dragBindings.remove(dragBinding);
            return;
        }
    }

    public void registerFirstMouseMoveBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_MOVE, mouseEventMatcher, action);
    }

    public void registerMouseMoveBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_MOVE, mouseEventMatcher, action);
    }

    public void unregisterMouseMoveBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_MOVE, mouseEventMatcher);
    }

    public void registerFirstMouseDownBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_DOWN, mouseEventMatcher, action);
    }

    public void registerMouseDownBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_DOWN, mouseEventMatcher, action);
    }

    public void unregisterMouseDownBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_DOWN, mouseEventMatcher);
    }

    public void registerFirstSingleClickBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_SINGLE_CLICK, mouseEventMatcher, action);
    }

    public void registerSingleClickBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_SINGLE_CLICK, mouseEventMatcher, action);
    }

    public void unregisterSingleClickBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_SINGLE_CLICK, mouseEventMatcher);
    }

    public void registerFirstDoubleClickBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_DOUBLE_CLICK, mouseEventMatcher, action);
    }

    public void registerDoubleClickBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_DOUBLE_CLICK, mouseEventMatcher, action);
    }

    public void unregisterDoubleClickBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_DOUBLE_CLICK, mouseEventMatcher);
    }

    public void registerFirstMouseHoverBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_HOVER, mouseEventMatcher, action);
    }

    public void registerMouseHoverBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_HOVER, mouseEventMatcher, action);
    }

    public void unregisterMouseHoverBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_HOVER, mouseEventMatcher);
    }

    public void registerFirstMouseEnterBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_ENTER, mouseEventMatcher, action);
    }

    public void registerMouseEnterBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_ENTER, mouseEventMatcher, action);
    }

    public void unregisterMouseEnterBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_ENTER, mouseEventMatcher);
    }

    public void registerFirstMouseExitBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(true, MouseEventTypeEnum.MOUSE_EXIT, mouseEventMatcher, action);
    }

    public void registerMouseExitBinding(IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        this.registerMouseBinding(false, MouseEventTypeEnum.MOUSE_EXIT, mouseEventMatcher, action);
    }

    public void unregisterMouseExitBinding(IMouseEventMatcher mouseEventMatcher) {
        this.unregisterMouseBinding(MouseEventTypeEnum.MOUSE_EXIT, mouseEventMatcher);
    }

    private void registerMouseBinding(boolean first, MouseEventTypeEnum mouseEventType, IMouseEventMatcher mouseEventMatcher, IMouseAction action) {
        LinkedList<MouseBinding> mouseEventBindings = this.mouseBindingsMap.get((Object)mouseEventType);
        if (mouseEventBindings == null) {
            mouseEventBindings = new LinkedList();
            this.mouseBindingsMap.put(mouseEventType, mouseEventBindings);
        }
        if (first) {
            mouseEventBindings.addFirst(new MouseBinding(mouseEventMatcher, action));
        } else {
            mouseEventBindings.addLast(new MouseBinding(mouseEventMatcher, action));
        }
    }

    private void unregisterMouseBinding(MouseEventTypeEnum mouseEventType, IMouseEventMatcher mouseEventMatcher) {
        LinkedList<MouseBinding> mouseBindings = this.mouseBindingsMap.get((Object)mouseEventType);
        if (mouseBindings != null) {
            for (MouseBinding mouseBinding : mouseBindings) {
                if (!mouseBinding.getMouseEventMatcher().equals(mouseEventMatcher)) continue;
                mouseBindings.remove(mouseBinding);
                return;
            }
        }
    }

    private static enum MouseEventTypeEnum {
        MOUSE_DOWN,
        MOUSE_MOVE,
        MOUSE_SINGLE_CLICK,
        MOUSE_DOUBLE_CLICK,
        MOUSE_HOVER,
        MOUSE_ENTER,
        MOUSE_EXIT;

    }
}

