/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.resource.IURIReplacementStrategy;

public class MoveFileURIReplacementStrategy
implements IURIReplacementStrategy {
    protected Map<URI, URI> replacementURIMapping;
    protected IPath sourcePath;
    protected IPath targetPath;

    public MoveFileURIReplacementStrategy(Map<URI, URI> replacementURIMapping, IPath sourcePath, IPath targetPath) {
        this.replacementURIMapping = replacementURIMapping;
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
    }

    public MoveFileURIReplacementStrategy(IPath sourcePath, IPath targetPath) {
        this(new HashMap<URI, URI>(), sourcePath, targetPath);
    }

    @Override
    public URI getReplacementCandidate(URI resourceURI) {
        if (this.replacementURIMapping.containsKey(resourceURI)) {
            return this.replacementURIMapping.get(resourceURI);
        }
        URI calculateUri = this.calculateNewUri(resourceURI);
        this.replacementURIMapping.put(resourceURI, calculateUri);
        return calculateUri;
    }

    protected URI calculateNewUri(URI resourceURI) {
        URI choseCorrectPath;
        ModelSet modelSet = new ModelSet();
        URIConverter uriConverter = modelSet.getURIConverter();
        boolean exists = uriConverter.exists(resourceURI, Collections.EMPTY_MAP);
        if (!exists && (choseCorrectPath = this.trySourcePath(this.sourcePath, this.targetPath, resourceURI)) != null) {
            return choseCorrectPath;
        }
        return resourceURI;
    }

    protected URI trySourcePath(IPath sourcePath, IPath targetPath, URI resourceURI) {
        String uriPlatformString = resourceURI.toPlatformString(true);
        if (uriPlatformString != null) {
            Path path = new Path(uriPlatformString);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile((IPath)path);
            if (!file.exists()) {
                URI sourceURI = URI.createPlatformResourceURI((String)(String.valueOf(sourcePath.toString()) + '/'), (boolean)true);
                URI targetURI = URI.createPlatformResourceURI((String)(String.valueOf(targetPath.toString()) + '/'), (boolean)true);
                URI resourceDeresolved = resourceURI.deresolve(targetURI);
                URI resourceResolved = resourceDeresolved.resolve(sourceURI);
                return resourceResolved;
            }
        }
        return null;
    }
}

