/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.internal.ui.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.resource.RenameResourceProcessor;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.ltk.ui.refactoring.resource.RenameResourceWizard;
import org.eclipse.papyrus.infra.onefile.internal.ui.Activator;
import org.eclipse.papyrus.infra.onefile.internal.ui.providers.CopyToClipboardAction;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.part.FileEditorInput;

public class PapyrusModelActionProvider
extends CommonActionProvider {
    private boolean fInViewPart = false;
    private ICommonViewerWorkbenchSite workbenchSite;
    private Action openAction;
    private Action deleteAction;
    private Action copyAction;
    private Action renameAction;
    private Action refreshAction;
    private Action moveAction;

    protected boolean filterAction(IAction action) {
        return super.filterAction(action);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.fInViewPart) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
            actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
            actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        }
        super.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.appendToGroup(menu, (IAction)this.openAction, "group.open");
        this.appendToGroup(menu, (IAction)this.deleteAction, "group.edit");
        this.appendToGroup(menu, (IAction)this.moveAction, "group.edit");
        this.appendToGroup(menu, (IAction)this.copyAction, "group.edit");
        this.appendToGroup(menu, (IAction)this.renameAction, "group.edit");
        this.appendToGroup(menu, (IAction)this.refreshAction, "group.edit");
    }

    private void appendToGroup(IMenuManager menu, IAction action, String id) {
        if (action != null && action.isEnabled()) {
            menu.appendToGroup(id, action);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (this.workbenchSite != null) {
            if (this.workbenchSite.getPart() != null && this.workbenchSite.getPart() instanceof IViewPart) {
                this.fInViewPart = true;
            }
            this.makeActions();
        }
    }

    private void makeActions() {
        IWorkbenchPartSite provider = this.workbenchSite.getSite();
        final ActionHelper helper = new ActionHelper();
        this.openAction = new Action(){

            public void run() {
                if (this.getIFile() != null) {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.openEditor((IEditorInput)new FileEditorInput(this.getIFile()), "org.eclipse.papyrus.infra.core.papyrusEditor", true, 3);
                    }
                    catch (WorkbenchException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }

            public IFile getIFile() {
                return helper.getIFile(PapyrusModelActionProvider.this.getContext());
            }

            public boolean isEnabled() {
                return this.getIFile() != null;
            }

            public String getText() {
                return IDEWorkbenchMessages.OpenFileAction_text;
            }
        };
        this.deleteAction = new DeleteResourceAction((IShellProvider)provider){

            public boolean isEnabled() {
                return this.getSelectedResources() != null && this.getSelectedResources().size() > 0 && OneFileUtils.containsDi(this.getSelectedResources());
            }

            public IStructuredSelection getStructuredSelection() {
                return helper.getStructuredSelection(PapyrusModelActionProvider.this.getContext());
            }

            protected List<IResource> getSelectedResources() {
                return helper.getSelectedResources(PapyrusModelActionProvider.this.getContext());
            }
        };
        this.moveAction = new MoveResourceAction((IShellProvider)provider){

            public IStructuredSelection getStructuredSelection() {
                return helper.getStructuredSelection(PapyrusModelActionProvider.this.getContext());
            }

            protected List<IResource> getSelectedResources() {
                return helper.getSelectedResources(PapyrusModelActionProvider.this.getContext());
            }
        };
        this.copyAction = new CopyToClipboardAction((IShellProvider)provider){

            public IStructuredSelection getStructuredSelection() {
                return helper.getStructuredSelection(PapyrusModelActionProvider.this.getContext());
            }

            protected List<IResource> getSelectedResources() {
                return helper.getSelectedResources(PapyrusModelActionProvider.this.getContext());
            }
        };
        this.renameAction = new OneFileRenameAction(provider);
        this.refreshAction = new RefreshAction((IShellProvider)provider){

            public void run() {
                super.run();
            }
        };
        this.makeAction(this.openAction, "org.eclipse.ui.navigator.Open", "IMG_TOOL_COPY", "IMG_TOOL_COPY_DISABLED");
        this.makeAction(this.deleteAction, "org.eclipse.ui.edit.delete", "IMG_TOOL_DELETE", "IMG_TOOL_DELETE_DISABLED");
        this.makeAction(this.moveAction, ActionFactory.MOVE.getId(), null, null);
        this.makeAction(this.copyAction, "org.eclipse.ui.edit.cut", "IMG_TOOL_CUT", "IMG_TOOL_CUT_DISABLED");
        this.makeAction(this.copyAction, "org.eclipse.ui.edit.copy", "IMG_TOOL_COPY", "IMG_TOOL_COPY_DISABLED");
        this.makeAction(this.refreshAction, ActionFactory.REFRESH.getCommandId(), null, null);
    }

    protected void makeAction(Action action, String id, String imgTool, String imgToolDisabled) {
        if (action != null) {
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            if (id != null) {
                action.setId(id);
                action.setActionDefinitionId(id);
            }
            if (imgTool != null) {
                action.setImageDescriptor(images.getImageDescriptor(imgTool));
            }
            if (imgToolDisabled != null) {
                action.setDisabledImageDescriptor(images.getImageDescriptor(imgToolDisabled));
            }
        }
    }

    public static class ActionHelper {
        public IStructuredSelection getStructuredSelection(ActionContext context) {
            return new StructuredSelection(this.getSelectedResources(context));
        }

        public List getOneSelectedResources(ActionContext context) {
            List<IResource> selectedResources = this.getSelectedResources(context);
            if (selectedResources.size() > 0) {
                Iterator<IResource> i = selectedResources.iterator();
                while (i.hasNext()) {
                    IFile file;
                    IResource o = i.next();
                    if (!(o instanceof IFile) || OneFileUtils.isDi((IResource)(file = (IFile)o))) continue;
                    i.remove();
                }
                return selectedResources;
            }
            return Collections.EMPTY_LIST;
        }

        public IStructuredSelection getOneStructuredSelection(ActionContext context) {
            List selectedResources = this.getOneSelectedResources(context);
            if (selectedResources.size() > 0) {
                return new StructuredSelection(selectedResources);
            }
            return null;
        }

        protected List<IResource> getSelectedResources(ActionContext context) {
            ISelection selec = context.getSelection();
            ArrayList<IResource> resources = new ArrayList<IResource>();
            if (selec instanceof IStructuredSelection) {
                IStructuredSelection struc = (IStructuredSelection)selec;
                for (Object o : struc) {
                    if (!(o instanceof IPapyrusFile)) continue;
                    IPapyrusFile papy = (IPapyrusFile)o;
                    resources.addAll(Arrays.asList(papy.getAssociatedResources()));
                }
            }
            return resources;
        }

        public IFile getIFile(ActionContext context) {
            ISelection selec = context.getSelection();
            if (selec instanceof IStructuredSelection) {
                IStructuredSelection struc = (IStructuredSelection)selec;
                Object firstElement = struc.getFirstElement();
                if (firstElement instanceof IFile) {
                    IFile file = (IFile)firstElement;
                    return file;
                }
                if (firstElement instanceof IPapyrusFile) {
                    return ((IPapyrusFile)firstElement).getMainFile();
                }
            }
            return null;
        }
    }

    public class OneFileRenameAction
    extends RenameResourceAction {
        final ActionHelper helper;
        private IWorkbenchPartSite partSiteProvider;

        public OneFileRenameAction(IWorkbenchPartSite provider) {
            super((IShellProvider)provider);
            this.helper = new ActionHelper();
            this.partSiteProvider = provider;
        }

        private Shell getShell() {
            return this.partSiteProvider.getShell();
        }

        public void run() {
            ISelection selection = this.partSiteProvider.getSelectionProvider().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 1) {
                    return;
                }
                Object selectedElement = structuredSelection.getFirstElement();
                if (selectedElement instanceof IPapyrusFile) {
                    IPapyrusFile modelToRename = (IPapyrusFile)selectedElement;
                    RenamePapyrusModelWizard refactoringWizard = new RenamePapyrusModelWizard(modelToRename);
                    RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)refactoringWizard);
                    try {
                        op.run(this.getShell(), RefactoringUIMessages.RenameResourceHandler_title);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class RenamePapyrusModelWizard
    extends RenameResourceWizard {
        private IPapyrusFile papyrusFile;

        public RenamePapyrusModelWizard(IPapyrusFile papyrusFile) {
            super((IResource)papyrusFile.getMainFile());
            this.papyrusFile = papyrusFile;
        }

        protected void addUserInputPages() {
            RenameResourceProcessor processor = (RenameResourceProcessor)this.getRefactoring().getAdapter(RenameResourceProcessor.class);
            this.addPage((IWizardPage)new RenamePapyrusModelPage(processor));
        }

        private class RenamePapyrusModelPage
        extends UserInputWizardPage {
            private final RenameResourceProcessor fRefactoringProcessor;
            private Text fNameField;

            public RenamePapyrusModelPage(RenameResourceProcessor processor) {
                super("RenamePapyrusModelRefactoringInputPage");
                this.fRefactoringProcessor = processor;
            }

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setLayout((Layout)new GridLayout(2, false));
                composite.setLayoutData((Object)new GridData(4, 4, true, true));
                composite.setFont(parent.getFont());
                Label label = new Label(composite, 0);
                label.setText(RefactoringUIMessages.RenameResourceWizard_name_field_label);
                label.setLayoutData((Object)new GridData());
                this.fNameField = new Text(composite, 2048);
                this.fNameField.setText(RenamePapyrusModelWizard.this.papyrusFile.getMainFile().getFullPath().removeFileExtension().lastSegment());
                this.fNameField.setFont(composite.getFont());
                this.fNameField.setLayoutData((Object)new GridData(4, 1, true, false));
                this.fNameField.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        RenamePapyrusModelPage.this.validatePage();
                    }
                });
                this.fNameField.selectAll();
                this.setPageComplete(false);
                this.setControl((Control)composite);
            }

            public void setVisible(boolean visible) {
                if (visible) {
                    this.fNameField.setFocus();
                }
                super.setVisible(visible);
            }

            protected final void validatePage() {
                String text = String.valueOf(this.fNameField.getText()) + ".di";
                RefactoringStatus status = this.fRefactoringProcessor.validateNewElementName(text);
                this.setPageComplete(status);
            }

            protected boolean performFinish() {
                this.initializeRefactoring();
                this.storeSettings();
                return super.performFinish();
            }

            public IWizardPage getNextPage() {
                this.initializeRefactoring();
                this.storeSettings();
                return super.getNextPage();
            }

            private void storeSettings() {
            }

            private void initializeRefactoring() {
                this.fRefactoringProcessor.setNewResourceName(String.valueOf(this.fNameField.getText()) + ".di");
            }
        }
    }
}

