/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainPreferences;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.ui.architecture.providers.MergedArchitectureItemProvider;

public abstract class MergedArchitectureContextItemProvider
extends MergedArchitectureItemProvider {
    private final StyledString.Style BOLD = StyledString.Style.newBuilder().setFont(URI.createURI((String)"font:////bold")).toStyle();
    private ArchitectureDomainPreferences preferences = new ArchitectureDomainPreferences();

    public MergedArchitectureContextItemProvider(AdapterFactory adapterFactory, MergedArchitectureContext owner) {
        super(adapterFactory, (MergedADElement)owner);
    }

    protected ArchitectureContext getADElement() {
        return (ArchitectureContext)this.getValue();
    }

    protected MergedArchitectureContext getMergedElement() {
        return (MergedArchitectureContext)this.getOwner();
    }

    @Override
    public Object getStyledText(Object object) {
        MergedArchitectureContext context;
        if (object instanceof MergedArchitectureContext && (context = (MergedArchitectureContext)object).getId() != null && context.getId().equals(this.preferences.getDefaultContextId())) {
            return new StyledString(context.getName(), this.BOLD);
        }
        return super.getStyledText(object);
    }

    public Object getParent(Object object) {
        if (object instanceof MergedArchitectureContext) {
            return ((MergedArchitectureContext)object).getDomain();
        }
        return super.getParent(object);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof MergedArchitectureContext) {
            MergedArchitectureContext context = (MergedArchitectureContext)object;
            return !context.getViewpoints().isEmpty();
        }
        return super.hasChildren(object);
    }

    public Collection<?> getChildren(Object object) {
        if (object instanceof MergedArchitectureContext) {
            MergedArchitectureContext context = (MergedArchitectureContext)object;
            ArrayList result = new ArrayList();
            result.addAll(context.getViewpoints());
            return result;
        }
        return super.getChildren(object);
    }

    protected Predicate<IItemPropertyDescriptor> propertyDescriptorFilter(Object object) {
        String dependenciesCategory = this.getString("_UI_DependenciesPropertyCategory");
        return pd -> dependenciesCategory.equals(pd.getCategory(object));
    }
}

