/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.uml.extensionpoints.library.IRegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.library.RegisteredLibrary;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.internal.impl.ModelImpl;
import org.eclipse.uml2.uml.util.UMLUtil;

public class Model
extends ModelImpl {
    protected final String ALF_LIBRARY = "Alf Library";
    protected final String FUML_LIBRARY = "FoundationalModelLibrary";
    protected final String STANDARD_PROFILE = "pathmap://UML_PROFILES/Standard.profile.uml";
    protected ResourceSet modelStorage;
    protected final String ALF_ROOT_PACKAGE = "Alf";

    public Model() {
        this.setName("EmptyModel");
        this.modelStorage = new ResourceSetImpl();
        this.loadLibraries();
        this.importLibraries();
        this.applyStandardProfile();
        this.registerTmpModel();
    }

    private void loadLibraries() {
        for (IRegisteredLibrary library : RegisteredLibrary.getRegisteredLibraries()) {
            if (library.getName() == null) continue;
            if (library.getName().equals("Alf Library")) {
                this.modelStorage.getResource(library.getUri(), true);
                continue;
            }
            if (!library.getName().equals("FoundationalModelLibrary")) continue;
            this.modelStorage.getResource(library.getUri(), true);
        }
    }

    private void importLibraries() {
        Collection matchedElement = UMLUtil.findNamedElements((ResourceSet)this.modelStorage, (String)"Alf");
        if (!matchedElement.isEmpty()) {
            NamedElement element = (NamedElement)matchedElement.toArray()[0];
            ElementImport elementImport = UMLFactory.eINSTANCE.createElementImport();
            elementImport.setImportedElement((PackageableElement)element);
            elementImport.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            elementImport.setAlias("Alf");
            this.getElementImports().add((Object)elementImport);
        }
    }

    private void applyStandardProfile() {
        Resource resource = this.modelStorage.getResource(URI.createURI((String)"pathmap://UML_PROFILES/Standard.profile.uml"), true);
        if (resource.getContents().get(0) instanceof Profile) {
            this.applyProfile((Profile)resource.getContents().get(0));
        }
    }

    private void registerTmpModel() {
        Resource r = this.modelStorage.createResource(URI.createURI((String)"EMPTY_UML_CONTEXT_MODEL.uml"));
        r.getContents().add((Object)this);
        this.modelStorage.getResources().add((Object)r);
    }

    public void clean() {
        for (Resource resource : this.modelStorage.getResources()) {
            resource.unload();
        }
    }
}

