/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.dialogs;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.ui.dialogs.InputDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialogMessage
extends InputDialog {
    private static final String ICON_WARNING = "/icons/warning.gif";
    private Text text;
    private CLabel warningMessageText;
    private String warningMessage;
    private final IInputValidator validator;

    protected InputDialogMessage(Shell parentShell, String dialogTitle, String errorMessage, String initialValue, IInputValidator validator) {
        super(parentShell, dialogTitle, errorMessage, initialValue);
        this.validator = validator;
    }

    protected void okPressed() {
        this.setValue(this.text.getText());
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.text.setFocus();
        if (this.getValue() != null) {
            this.text.setText(this.getValue());
            this.text.selectAll();
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.text = new Text(composite, this.getInputTextStyle());
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputDialogMessage.this.validateInput();
            }
        });
        this.warningMessageText = new CLabel(composite, 72);
        this.warningMessageText.setLayoutData((Object)new GridData(768));
        this.warningMessageText.setBackground(this.warningMessageText.getDisplay().getSystemColor(22));
        this.setWarningMessage(this.warningMessage);
        InputDialogMessage.applyDialogFont((Control)composite);
        return composite;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.text.getText());
        }
        this.setWarningMessage(errorMessage);
    }

    public void setWarningMessage(String errorMessage) {
        this.warningMessage = errorMessage;
        if (this.warningMessageText != null && !this.warningMessageText.isDisposed()) {
            Image errorImage = Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", ICON_WARNING);
            this.warningMessageText.setImage(errorMessage == null ? null : errorImage);
            this.warningMessageText.setText(errorMessage == null ? "" : errorMessage);
            this.warningMessageText.getParent().update();
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

