/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.util.PHPSearchEngine;
import org.eclipse.php.internal.core.util.SyncObject;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.pathmapper.BestMatchPathComparator;
import org.eclipse.php.internal.debug.core.pathmapper.ILocalFileSearchFilter;
import org.eclipse.php.internal.debug.core.pathmapper.LocalFileSearchFilterRegistry;
import org.eclipse.php.internal.debug.core.pathmapper.LocalFileSearchResult;
import org.eclipse.php.internal.debug.core.pathmapper.Messages;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.server.core.manager.ServersManager;

public class LocalFileSearchEngine {
    public static final String DEFAULT_FILE_SEARCH_FILTER = "org.eclipse.php.debug.openLocalFileSearchFilter";
    private PHPFilenameFilter PHP_FILTER = new PHPFilenameFilter();
    private final ILocalFileSearchFilter searchResultsFilter;

    public LocalFileSearchEngine() {
        this.searchResultsFilter = LocalFileSearchFilterRegistry.getFilter(DEFAULT_FILE_SEARCH_FILTER);
    }

    public LocalFileSearchEngine(ILocalFileSearchFilter searchResultsFilter) {
        this.searchResultsFilter = searchResultsFilter;
    }

    public LocalFileSearchResult find(IResource container, final String remoteFilePath, final String serverUniqueId) throws InterruptedException {
        if (container == null || !container.exists() || !container.isAccessible()) {
            return null;
        }
        final PathMapper pathMapper = serverUniqueId != null ? PathMapperRegistry.getByServer(ServersManager.findServer((String)serverUniqueId)) : new PathMapper();
        final VirtualPath abstractPath = new VirtualPath(remoteFilePath);
        final SyncObject searchResult = new SyncObject();
        Job findJob = new Job(Messages.LocalFileSearchEngine_Searching_for_local_file){

            protected IStatus run(IProgressMonitor monitor) {
                boolean foundInWorkspace;
                IProject[] projects;
                LinkedList<PathEntry> results = new LinkedList<PathEntry>();
                IBuildpathEntry[] buildPaths = null;
                LinkedHashSet s = new LinkedHashSet();
                LinkedHashSet<IBuildpathEntry> b = new LinkedHashSet<IBuildpathEntry>();
                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    if (project.isOpen() && project.isAccessible()) {
                        PHPSearchEngine.buildIncludePath((IProject)project, s);
                        IScriptProject scriptProject = DLTKCore.create((IProject)project);
                        if (scriptProject != null && scriptProject.isOpen()) {
                            try {
                                IBuildpathEntry[] rawBuildpath;
                                IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath = scriptProject.getRawBuildpath();
                                int n3 = rawBuildpath.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IBuildpathEntry pathEntry = iBuildpathEntryArray[n4];
                                    b.add(pathEntry);
                                    ++n4;
                                }
                            }
                            catch (ModelException e) {
                                PHPDebugPlugin.log(e);
                            }
                        }
                    }
                    ++n2;
                }
                IncludePath[] includePaths = s.toArray(new IncludePath[s.size()]);
                buildPaths = b.toArray(new IBuildpathEntry[b.size()]);
                try {
                    IPath path = Path.fromOSString((String)remoteFilePath);
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
                    if (file != null && file.exists()) {
                        IncludePath[] e = includePaths;
                        int scriptProject = includePaths.length;
                        int n5 = 0;
                        while (n5 < scriptProject) {
                            IContainer container;
                            IncludePath includePath = e[n5];
                            if (includePath.getEntry() instanceof IContainer && (container = (IContainer)includePath.getEntry()).getFullPath().isPrefixOf(file.getFullPath())) {
                                PathEntry localFile = new PathEntry(file.getFullPath().toString(), PathEntry.Type.WORKSPACE, (Object)file.getParent());
                                pathMapper.addEntry(remoteFilePath, localFile, PathMapper.Mapping.MappingSource.ENVIRONMENT);
                                PathMapperRegistry.storeToPreferences();
                                searchResult.set((Object)new LocalFileSearchResult(localFile));
                                return Status.OK_STATUS;
                            }
                            ++n5;
                        }
                    }
                }
                catch (Exception path) {
                    // empty catch block
                }
                if (buildPaths != null) {
                    IBuildpathEntry[] iBuildpathEntryArray = buildPaths;
                    int n6 = buildPaths.length;
                    int file = 0;
                    while (file < n6) {
                        File entryDir;
                        IBuildpathEntry entry = iBuildpathEntryArray[file];
                        IPath entryPath = EnvironmentPathUtils.getLocalPath((IPath)entry.getPath());
                        if (entry.getEntryKind() == 1) {
                            entryDir = entryPath.toFile();
                            LocalFileSearchEngine.this.find(entryDir, abstractPath, entry, results);
                        } else if (entry.getEntryKind() == 2 || entry.getEntryKind() == 3) {
                            IProject project;
                            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath().lastSegment());
                            if (res instanceof IProject && (project = (IProject)res).isOpen() && project.isAccessible()) {
                                try {
                                    LocalFileSearchEngine.this.find((IResource)project, abstractPath, results);
                                }
                                catch (InterruptedException e) {
                                    PHPDebugPlugin.log(e);
                                }
                            }
                        } else if (entry.getEntryKind() == 4) {
                            if ((entryPath = DLTKCore.getResolvedVariablePath((IPath)entryPath)) != null) {
                                entryDir = entryPath.toFile();
                                LocalFileSearchEngine.this.find(entryDir, abstractPath, entry, results);
                            }
                        } else if (entry.getEntryKind() == 5) {
                            try {
                                if (projects.length != 0) {
                                    IBuildpathEntry[] buildpathEntries;
                                    IProject currentProject = projects[0];
                                    IScriptProject scriptProject = DLTKCore.create((IProject)currentProject);
                                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)scriptProject);
                                    if (container != null && (entryPath = EnvironmentPathUtils.getLocalPath((IPath)(buildpathEntries = container.getBuildpathEntries())[0].getPath())) != null) {
                                        LocalFileSearchEngine.this.find(entryPath.toFile(), abstractPath, entry, results);
                                    }
                                }
                            }
                            catch (ModelException e) {
                                PHPCorePlugin.log((Throwable)e);
                            }
                        }
                        ++file;
                    }
                }
                IncludePath[] includePathArray = includePaths;
                int n7 = includePaths.length;
                int file = 0;
                while (file < n7) {
                    IncludePath includePath = includePathArray[file];
                    if (includePath.getEntry() instanceof IContainer) {
                        try {
                            LocalFileSearchEngine.this.find((IResource)((IContainer)includePath.getEntry()), abstractPath, results);
                        }
                        catch (InterruptedException e) {
                            PHPDebugPlugin.log(e);
                        }
                    }
                    ++file;
                }
                boolean bl = foundInWorkspace = results.size() > 0;
                if (!foundInWorkspace && results.size() == 1 && abstractPath.equals(((PathEntry)results.getFirst()).getAbstractPath())) {
                    searchResult.set((Object)new LocalFileSearchResult(results.getFirst()));
                } else if (results.size() > 0) {
                    Collections.sort(results, new BestMatchPathComparator(abstractPath));
                    LocalFileSearchResult filteredResult = LocalFileSearchEngine.this.filter(results.toArray(new PathEntry[results.size()]), abstractPath, serverUniqueId);
                    if (filteredResult.getPathEntry() != null && filteredResult.getStatus().isOK()) {
                        pathMapper.addEntry(remoteFilePath, filteredResult.getPathEntry(), PathMapper.Mapping.MappingSource.USER);
                        PathMapperRegistry.storeToPreferences();
                    }
                    searchResult.set((Object)filteredResult);
                }
                return Status.OK_STATUS;
            }
        };
        findJob.schedule();
        try {
            findJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (LocalFileSearchResult)searchResult.get();
    }

    private LocalFileSearchResult filter(PathEntry[] entries, VirtualPath remotePath, String serverUniqueId) {
        return this.searchResultsFilter.filter(entries, remotePath, serverUniqueId);
    }

    private void find(final IResource resource, final VirtualPath path, final List<PathEntry> results) throws InterruptedException {
        if (resource == null || !resource.exists() || !resource.isAccessible()) {
            return;
        }
        WorkspaceJob findJob = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (!resource.isAccessible()) {
                            return false;
                        }
                        if (resource instanceof IFile && resource.getName().equals(path.getLastSegment())) {
                            PathEntry pathEntry = new PathEntry(resource.getFullPath().toString(), PathEntry.Type.WORKSPACE, (Object)resource.getParent());
                            results.add(pathEntry);
                        }
                        return true;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        findJob.schedule();
        findJob.join();
    }

    private void find(File file, VirtualPath path, IBuildpathEntry container, List<PathEntry> results) {
        if (!file.isDirectory() && file.getName().equals(path.getLastSegment())) {
            PathEntry.Type type = container.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER;
            PathEntry pathEntry = new PathEntry(file.getAbsolutePath(), type, (Object)container);
            results.add(pathEntry);
            return;
        }
        File[] files = file.listFiles(this.PHP_FILTER);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                this.find(files[i], path, container, results);
                ++i;
            }
        }
    }

    private class PHPFilenameFilter
    implements FileFilter,
    IContentTypeManager.IContentTypeChangeListener {
        private Pattern phpFilePattern;

        public PHPFilenameFilter() {
            this.buildPHPFilePattern();
            Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
        }

        private void buildPHPFilePattern() {
            IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
            String[] phpExtensions = type.getFileSpecs(8);
            StringBuilder buf = new StringBuilder();
            buf.append(".*\\.(");
            int i = 0;
            while (i < phpExtensions.length) {
                if (i > 0) {
                    buf.append("|");
                }
                buf.append(phpExtensions[i]);
                ++i;
            }
            buf.append(')');
            this.phpFilePattern = Pattern.compile(buf.toString(), 2);
        }

        public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
            this.buildPHPFilePattern();
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || this.phpFilePattern.matcher(pathname.getName()).matches();
        }
    }
}

