/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.core.lookup;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.workbench.core.exception.WorkbenchCoreLayerException;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class ViewToolBarLookup {
    private static ViewToolBarLookup instance;

    private ViewToolBarLookup() {
    }

    public static ViewToolBarLookup getInstance() {
        if (instance == null) {
            instance = new ViewToolBarLookup();
        }
        return instance;
    }

    public ToolBar getViewToolBar() {
        ToolBar toolbar = (ToolBar)Display.syncExec((ResultRunnable)new ResultRunnable<ToolBar>(){

            public ToolBar run() {
                ToolBar toolBar = null;
                IWorkbenchPartSite site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                if (!(site instanceof IViewSite)) {
                    throw new WorkbenchCoreLayerException("Active part is not View.");
                }
                IViewSite viewSite = (IViewSite)site;
                IToolBarManager toolBarManager = viewSite.getActionBars().getToolBarManager();
                if (toolBarManager instanceof ToolBarManager) {
                    toolBar = ((ToolBarManager)toolBarManager).getControl();
                }
                return toolBar;
            }
        });
        return toolbar;
    }
}

