/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.rhino.JSTypeExpression;

public final class Typedef {
    private State state;
    private JSTypeExpression typeExpr;
    private JSType type;

    private Typedef(JSTypeExpression typeExpr) {
        Preconditions.checkNotNull((Object)typeExpr);
        this.state = State.NOT_RESOLVED;
        this.type = null;
        this.typeExpr = typeExpr;
    }

    public static Typedef make(JSTypeExpression typeExpr) {
        return new Typedef(typeExpr);
    }

    public boolean isResolved() {
        return this.state == State.RESOLVED;
    }

    public JSType getType() {
        Preconditions.checkState((this.state == State.RESOLVED ? 1 : 0) != 0);
        return this.type;
    }

    public JSTypeExpression getTypeExpr() {
        Preconditions.checkState((this.state != State.RESOLVED ? 1 : 0) != 0);
        if (this.state == State.DURING_RESOLUTION) {
            return null;
        }
        this.state = State.DURING_RESOLUTION;
        return this.typeExpr;
    }

    public JSTypeExpression getTypeExprForErrorReporting() {
        Preconditions.checkState((this.state == State.DURING_RESOLUTION ? 1 : 0) != 0);
        return this.typeExpr;
    }

    void resolveTypedef(JSType t) {
        Preconditions.checkNotNull((Object)t);
        if (this.state == State.RESOLVED) {
            return;
        }
        Preconditions.checkState((this.state == State.DURING_RESOLUTION ? 1 : 0) != 0, (String)"Expected state DURING_RESOLUTION but found %s", (Object[])new Object[]{this.state.toString()});
        this.state = State.RESOLVED;
        this.typeExpr = null;
        this.type = t;
    }

    private static enum State {
        NOT_RESOLVED,
        DURING_RESOLUTION,
        RESOLVED;

    }
}

