/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.ui.texteditor.ITextEditor;

public class CReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IProgressMonitor fProgressMonitor;
    protected boolean fInitialProcessDone;

    public CReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = CUIPlugin.getDefault().getWorkingCopyManager();
    }

    public void setDocument(IDocument document) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void reconcile(IRegion region) {
        this.reconcile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcile(boolean initialReconcile) {
        block59: {
            boolean computeAST = this.fEditor instanceof ICReconcilingListener;
            IASTTranslationUnit ast = null;
            IWorkingCopy workingCopy = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
            if (workingCopy == null) {
                return;
            }
            boolean forced = false;
            try {
                try {
                    IWorkingCopy iWorkingCopy = workingCopy;
                    synchronized (iWorkingCopy) {
                        forced = workingCopy.isConsistent();
                        ast = workingCopy.reconcile(computeAST, true, this.fProgressMonitor);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    if (!computeAST) break block59;
                    IIndex index = null;
                    if (ast != null) {
                        index = ast.getIndex();
                    }
                    try {
                        try {
                            boolean canceled = this.fProgressMonitor.isCanceled();
                            if (ast == null || canceled) {
                                ((ICReconcilingListener)this.fEditor).reconciled(null, forced, this.fProgressMonitor);
                            } else {
                                ((ASTTranslationUnit)ast).beginExclusiveAccess();
                                try {
                                    ((ICReconcilingListener)this.fEditor).reconciled(ast, forced, this.fProgressMonitor);
                                }
                                finally {
                                    ((ASTTranslationUnit)ast).endExclusiveAccess();
                                }
                            }
                            if (canceled) {
                                this.aboutToBeReconciled();
                            }
                        }
                        catch (Exception e) {
                            Status status = new Status(4, "org.eclipse.cdt.ui", 0, "Error in CDT UI during reconcile", (Throwable)e);
                            CUIPlugin.log((IStatus)status);
                            if (index != null) {
                                index.releaseReadLock();
                            }
                        }
                    }
                    finally {
                        if (index != null) {
                            index.releaseReadLock();
                        }
                    }
                }
                catch (CModelException e) {
                    IIndex index;
                    block61: {
                        Status status = new Status(4, "org.eclipse.cdt.ui", 0, "Error in CDT UI during reconcile", (Throwable)e);
                        CUIPlugin.log((IStatus)status);
                        if (!computeAST) break block59;
                        index = null;
                        if (ast == null) break block61;
                        index = ast.getIndex();
                    }
                    try {
                        try {
                            boolean canceled = this.fProgressMonitor.isCanceled();
                            if (ast == null || canceled) {
                                ((ICReconcilingListener)this.fEditor).reconciled(null, forced, this.fProgressMonitor);
                            } else {
                                ((ASTTranslationUnit)ast).beginExclusiveAccess();
                                try {
                                    ((ICReconcilingListener)this.fEditor).reconciled(ast, forced, this.fProgressMonitor);
                                }
                                finally {
                                    ((ASTTranslationUnit)ast).endExclusiveAccess();
                                }
                            }
                            if (canceled) {
                                this.aboutToBeReconciled();
                            }
                        }
                        catch (Exception e2) {
                            Status status = new Status(4, "org.eclipse.cdt.ui", 0, "Error in CDT UI during reconcile", (Throwable)e2);
                            CUIPlugin.log((IStatus)status);
                            if (index != null) {
                                index.releaseReadLock();
                            }
                        }
                    }
                    finally {
                        if (index != null) {
                            index.releaseReadLock();
                        }
                    }
                }
            }
            finally {
                block65: {
                    if (computeAST) {
                        IIndex index = null;
                        if (ast != null) {
                            index = ast.getIndex();
                        }
                        try {
                            try {
                                boolean canceled = this.fProgressMonitor.isCanceled();
                                if (ast == null || canceled) {
                                    ((ICReconcilingListener)this.fEditor).reconciled(null, forced, this.fProgressMonitor);
                                } else {
                                    ((ASTTranslationUnit)ast).beginExclusiveAccess();
                                    try {
                                        ((ICReconcilingListener)this.fEditor).reconciled(ast, forced, this.fProgressMonitor);
                                    }
                                    finally {
                                        ((ASTTranslationUnit)ast).endExclusiveAccess();
                                    }
                                }
                                if (canceled) {
                                    this.aboutToBeReconciled();
                                }
                            }
                            catch (Exception e) {
                                Status status = new Status(4, "org.eclipse.cdt.ui", 0, "Error in CDT UI during reconcile", (Throwable)e);
                                CUIPlugin.log((IStatus)status);
                                if (index != null) {
                                    index.releaseReadLock();
                                }
                                break block65;
                            }
                        }
                        catch (Throwable throwable) {
                            if (index != null) {
                                index.releaseReadLock();
                            }
                            throw throwable;
                        }
                        if (index != null) {
                            index.releaseReadLock();
                        }
                    }
                }
            }
        }
    }

    public void initialReconcile() {
        this.reconcile(true);
        this.fInitialProcessDone = true;
    }

    void aboutToBeReconciled() {
        if (this.fEditor instanceof ICReconcilingListener) {
            ((ICReconcilingListener)this.fEditor).aboutToBeReconciled();
        }
    }
}

