/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.beans.property;

import com.google.common.collect.Multiset;
import javafx.beans.property.ReadOnlyProperty;
import org.eclipse.gef.common.beans.binding.BindingUtils;
import org.eclipse.gef.common.beans.binding.MultisetExpression;
import org.eclipse.gef.common.collections.ObservableMultiset;

public abstract class ReadOnlyMultisetProperty<E>
extends MultisetExpression<E>
implements ReadOnlyProperty<ObservableMultiset<E>> {
    protected void appendValueToString(StringBuilder result) {
        result.append("value: " + this.get());
    }

    public void bindContent(ObservableMultiset<E> target) {
        BindingUtils.bindContent(this, target);
    }

    public void bindContentBidirectional(ObservableMultiset<E> other) {
        BindingUtils.bindContentBidirectional(this, other);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof Multiset)) {
            return false;
        }
        if (this.get() == null) {
            return false;
        }
        return ((ObservableMultiset)this.get()).equals(other);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        String name;
        StringBuilder sb = new StringBuilder(String.valueOf(this.getClass().getSimpleName()) + " [");
        Object bean = this.getBean();
        if (bean != null) {
            sb.append("bean: " + bean + ", ");
        }
        if ((name = this.getName()) != null && !name.equals("")) {
            sb.append("name: " + name + ", ");
        }
        this.appendValueToString(sb);
        sb.append("]");
        return sb.toString();
    }

    public void unbindContent(Object target) {
        try {
            BindingUtils.unbindContent(this, (ObservableMultiset)target);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void unbindContentBidirectional(Object other) {
        try {
            BindingUtils.unbindContentBidirectional(this, (ObservableMultiset)other);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

