/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.collections;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.InvalidationListener;
import org.eclipse.gef.common.collections.MultisetChangeListener;
import org.eclipse.gef.common.collections.ObservableMultiset;

public class MultisetListenerHelper<E> {
    private List<InvalidationListener> invalidationListeners = null;
    private boolean lockInvalidationListeners;
    private boolean lockMultisetChangeListeners;
    private List<MultisetChangeListener<? super E>> multisetChangeListeners = null;
    private ObservableMultiset<E> source;

    public MultisetListenerHelper(ObservableMultiset<E> source) {
        this.source = source;
    }

    public void addListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            this.invalidationListeners = new ArrayList<InvalidationListener>();
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        this.invalidationListeners.add(listener);
    }

    public void addListener(MultisetChangeListener<? super E> listener) {
        if (this.multisetChangeListeners == null) {
            this.multisetChangeListeners = new ArrayList<MultisetChangeListener<? super E>>();
        }
        if (this.lockMultisetChangeListeners) {
            this.multisetChangeListeners = new ArrayList<MultisetChangeListener<MultisetChangeListener<? super E>>>(this.multisetChangeListeners);
        }
        this.multisetChangeListeners.add(listener);
    }

    public void fireValueChangedEvent(MultisetChangeListener.Change<? extends E> change) {
        this.notifyInvalidationListeners();
        if (change != null) {
            this.notifyMultisetChangeListeners(change);
        }
    }

    protected ObservableMultiset<E> getSource() {
        return this.source;
    }

    protected void notifyInvalidationListeners() {
        if (this.invalidationListeners != null) {
            try {
                this.lockInvalidationListeners = true;
                for (InvalidationListener l : this.invalidationListeners) {
                    try {
                        l.invalidated(this.source);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockInvalidationListeners = false;
            }
        }
    }

    protected void notifyMultisetChangeListeners(MultisetChangeListener.Change<? extends E> change) {
        if (this.multisetChangeListeners != null) {
            try {
                this.lockMultisetChangeListeners = true;
                for (MultisetChangeListener<E> multisetChangeListener : this.multisetChangeListeners) {
                    change.reset();
                    try {
                        multisetChangeListener.onChanged(change);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockMultisetChangeListeners = false;
            }
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            return;
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        Iterator<InvalidationListener> iterator = this.invalidationListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.invalidationListeners.isEmpty()) {
            this.invalidationListeners = null;
        }
    }

    public void removeListener(MultisetChangeListener<? super E> listener) {
        if (this.multisetChangeListeners == null) {
            return;
        }
        if (this.lockMultisetChangeListeners) {
            this.multisetChangeListeners = new ArrayList<MultisetChangeListener<MultisetChangeListener<? super E>>>(this.multisetChangeListeners);
        }
        Iterator<MultisetChangeListener<E>> iterator = this.multisetChangeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.multisetChangeListeners.isEmpty()) {
            this.multisetChangeListeners = null;
        }
    }

    public static class AtomicChange<E>
    extends MultisetChangeListener.Change<E> {
        private int cursor = -1;
        private ElementarySubChange<E>[] elementarySubChanges;
        private Multiset<E> previousContents;

        public AtomicChange(ObservableMultiset<E> source, Multiset<E> previousContents, ElementarySubChange<E> elementarySubChange) {
            super(source);
            this.previousContents = previousContents;
            this.elementarySubChanges = new ElementarySubChange[]{elementarySubChange};
        }

        public AtomicChange(ObservableMultiset<E> source, Multiset<E> previousContents, List<ElementarySubChange<E>> elementarySubChanges) {
            super(source);
            this.previousContents = previousContents;
            this.elementarySubChanges = elementarySubChanges.toArray(new ElementarySubChange[0]);
        }

        public AtomicChange(ObservableMultiset<E> source, MultisetChangeListener.Change<? extends E> change) {
            super(source);
            this.previousContents = HashMultiset.create(change.getPreviousContents());
            ArrayList<ElementarySubChange<E>> elementarySubChanges = new ArrayList<ElementarySubChange<E>>();
            while (change.next()) {
                elementarySubChanges.add(new ElementarySubChange<E>(change.getElement(), change.getRemoveCount(), change.getAddCount()));
            }
            change.reset();
            this.elementarySubChanges = elementarySubChanges.toArray(new ElementarySubChange[0]);
        }

        private void checkCursor() {
            String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
            if (this.cursor == -1) {
                throw new IllegalStateException("Need to call next() before " + methodName + "() can be called.");
            }
            if (this.cursor >= this.elementarySubChanges.length) {
                throw new IllegalStateException("May only call " + methodName + "() if next() returned true.");
            }
        }

        @Override
        public int getAddCount() {
            this.checkCursor();
            return this.elementarySubChanges[this.cursor].getAddCount();
        }

        @Override
        public E getElement() {
            this.checkCursor();
            return this.elementarySubChanges[this.cursor].getElement();
        }

        @Override
        public Multiset<E> getPreviousContents() {
            return Multisets.unmodifiableMultiset(this.previousContents);
        }

        @Override
        public int getRemoveCount() {
            this.checkCursor();
            return this.elementarySubChanges[this.cursor].getRemoveCount();
        }

        @Override
        public boolean next() {
            ++this.cursor;
            return this.cursor < this.elementarySubChanges.length;
        }

        @Override
        public void reset() {
            this.cursor = -1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.elementarySubChanges.length) {
                sb.append(this.elementarySubChanges[i].toString());
                if (i < this.elementarySubChanges.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            return sb.toString();
        }
    }

    public static class ElementarySubChange<E> {
        private int addCount;
        private E element;
        private int removeCount;

        public ElementarySubChange(E element, int removeCount, int addCount) {
            this.element = element;
            this.removeCount = removeCount;
            this.addCount = addCount;
        }

        public int getAddCount() {
            return this.addCount;
        }

        public E getElement() {
            return this.element;
        }

        public int getRemoveCount() {
            return this.removeCount;
        }

        public String toString() {
            if (this.addCount > 0) {
                return "Added " + this.addCount + " occurrences of " + this.element + ".";
            }
            return "Removed " + this.removeCount + " occurrences of " + this.element + ".";
        }
    }
}

