/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.mm.algorithms.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.graphiti.mm.algorithms.AlgorithmsPackage;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.RenderingStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.impl.GraphicsAlgorithmContainerImpl;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public abstract class GraphicsAlgorithmImpl
extends GraphicsAlgorithmContainerImpl
implements GraphicsAlgorithm {
    protected Color background;
    protected Color foreground;
    protected static final Integer LINE_WIDTH_EDEFAULT = null;
    protected Integer lineWidth = LINE_WIDTH_EDEFAULT;
    protected static final LineStyle LINE_STYLE_EDEFAULT = LineStyle.SOLID;
    protected LineStyle lineStyle = LINE_STYLE_EDEFAULT;
    protected static final Boolean FILLED_EDEFAULT = Boolean.TRUE;
    protected Boolean filled = FILLED_EDEFAULT;
    protected boolean filledESet;
    protected static final Boolean LINE_VISIBLE_EDEFAULT = Boolean.TRUE;
    protected Boolean lineVisible = LINE_VISIBLE_EDEFAULT;
    protected boolean lineVisibleESet;
    protected RenderingStyle renderingStyle;
    protected static final Double TRANSPARENCY_EDEFAULT = null;
    protected Double transparency = TRANSPARENCY_EDEFAULT;
    protected EList<GraphicsAlgorithm> graphicsAlgorithmChildren;
    protected static final int WIDTH_EDEFAULT = 0;
    protected int width = 0;
    protected static final int HEIGHT_EDEFAULT = 0;
    protected int height = 0;
    protected static final int X_EDEFAULT = 0;
    protected int x = 0;
    protected static final int Y_EDEFAULT = 0;
    protected int y = 0;
    protected Style style;

    protected GraphicsAlgorithmImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return AlgorithmsPackage.Literals.GRAPHICS_ALGORITHM;
    }

    @Override
    public Color getBackground() {
        if (this.background != null && this.background.eIsProxy()) {
            InternalEObject oldBackground = (InternalEObject)this.background;
            this.background = (Color)this.eResolveProxy(oldBackground);
            if (this.background != oldBackground && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 1, (Object)oldBackground, (Object)this.background));
            }
        }
        return this.background;
    }

    public Color basicGetBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color newBackground) {
        Color oldBackground = this.background;
        this.background = newBackground;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldBackground, (Object)this.background));
        }
    }

    @Override
    public Color getForeground() {
        if (this.foreground != null && this.foreground.eIsProxy()) {
            InternalEObject oldForeground = (InternalEObject)this.foreground;
            this.foreground = (Color)this.eResolveProxy(oldForeground);
            if (this.foreground != oldForeground && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldForeground, (Object)this.foreground));
            }
        }
        return this.foreground;
    }

    public Color basicGetForeground() {
        return this.foreground;
    }

    @Override
    public void setForeground(Color newForeground) {
        Color oldForeground = this.foreground;
        this.foreground = newForeground;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldForeground, (Object)this.foreground));
        }
    }

    @Override
    public Integer getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(Integer newLineWidth) {
        Integer oldLineWidth = this.lineWidth;
        this.lineWidth = newLineWidth;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldLineWidth, (Object)this.lineWidth));
        }
    }

    @Override
    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(LineStyle newLineStyle) {
        LineStyle oldLineStyle = this.lineStyle;
        LineStyle lineStyle = this.lineStyle = newLineStyle == null ? LINE_STYLE_EDEFAULT : newLineStyle;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldLineStyle, (Object)this.lineStyle));
        }
    }

    @Override
    public Boolean getFilled() {
        return this.filled;
    }

    @Override
    public void setFilled(Boolean newFilled) {
        Boolean oldFilled = this.filled;
        this.filled = newFilled;
        boolean oldFilledESet = this.filledESet;
        this.filledESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldFilled, (Object)this.filled, !oldFilledESet));
        }
    }

    @Override
    public void unsetFilled() {
        Boolean oldFilled = this.filled;
        boolean oldFilledESet = this.filledESet;
        this.filled = FILLED_EDEFAULT;
        this.filledESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, (Object)oldFilled, (Object)FILLED_EDEFAULT, oldFilledESet));
        }
    }

    @Override
    public boolean isSetFilled() {
        return this.filledESet;
    }

    @Override
    public Boolean getLineVisible() {
        return this.lineVisible;
    }

    @Override
    public void setLineVisible(Boolean newLineVisible) {
        Boolean oldLineVisible = this.lineVisible;
        this.lineVisible = newLineVisible;
        boolean oldLineVisibleESet = this.lineVisibleESet;
        this.lineVisibleESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLineVisible, (Object)this.lineVisible, !oldLineVisibleESet));
        }
    }

    @Override
    public void unsetLineVisible() {
        Boolean oldLineVisible = this.lineVisible;
        boolean oldLineVisibleESet = this.lineVisibleESet;
        this.lineVisible = LINE_VISIBLE_EDEFAULT;
        this.lineVisibleESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 6, (Object)oldLineVisible, (Object)LINE_VISIBLE_EDEFAULT, oldLineVisibleESet));
        }
    }

    @Override
    public boolean isSetLineVisible() {
        return this.lineVisibleESet;
    }

    @Override
    public RenderingStyle getRenderingStyle() {
        if (this.renderingStyle != null && this.renderingStyle.eIsProxy()) {
            InternalEObject oldRenderingStyle = (InternalEObject)this.renderingStyle;
            this.renderingStyle = (RenderingStyle)this.eResolveProxy(oldRenderingStyle);
            if (this.renderingStyle != oldRenderingStyle) {
                InternalEObject newRenderingStyle = (InternalEObject)this.renderingStyle;
                NotificationChain msgs = oldRenderingStyle.eInverseRemove((InternalEObject)this, -8, null, null);
                if (newRenderingStyle.eInternalContainer() == null) {
                    msgs = newRenderingStyle.eInverseAdd((InternalEObject)this, -8, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldRenderingStyle, (Object)this.renderingStyle));
                }
            }
        }
        return this.renderingStyle;
    }

    public RenderingStyle basicGetRenderingStyle() {
        return this.renderingStyle;
    }

    public NotificationChain basicSetRenderingStyle(RenderingStyle newRenderingStyle, NotificationChain msgs) {
        RenderingStyle oldRenderingStyle = this.renderingStyle;
        this.renderingStyle = newRenderingStyle;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldRenderingStyle, (Object)newRenderingStyle);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setRenderingStyle(RenderingStyle newRenderingStyle) {
        if (newRenderingStyle != this.renderingStyle) {
            NotificationChain msgs = null;
            if (this.renderingStyle != null) {
                msgs = ((InternalEObject)this.renderingStyle).eInverseRemove((InternalEObject)this, -8, null, msgs);
            }
            if (newRenderingStyle != null) {
                msgs = ((InternalEObject)newRenderingStyle).eInverseAdd((InternalEObject)this, -8, null, msgs);
            }
            if ((msgs = this.basicSetRenderingStyle(newRenderingStyle, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newRenderingStyle, (Object)newRenderingStyle));
        }
    }

    @Override
    public Double getTransparency() {
        return this.transparency;
    }

    @Override
    public void setTransparency(Double newTransparency) {
        Double oldTransparency = this.transparency;
        this.transparency = newTransparency;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldTransparency, (Object)this.transparency));
        }
    }

    @Override
    public EList<GraphicsAlgorithm> getGraphicsAlgorithmChildren() {
        if (this.graphicsAlgorithmChildren == null) {
            this.graphicsAlgorithmChildren = new EObjectContainmentWithInverseEList.Resolving(GraphicsAlgorithm.class, (InternalEObject)this, 9, 10);
        }
        return this.graphicsAlgorithmChildren;
    }

    @Override
    public GraphicsAlgorithm getParentGraphicsAlgorithm() {
        if (this.eContainerFeatureID() != 10) {
            return null;
        }
        return (GraphicsAlgorithm)this.eContainer();
    }

    public GraphicsAlgorithm basicGetParentGraphicsAlgorithm() {
        if (this.eContainerFeatureID() != 10) {
            return null;
        }
        return (GraphicsAlgorithm)this.eInternalContainer();
    }

    public NotificationChain basicSetParentGraphicsAlgorithm(GraphicsAlgorithm newParentGraphicsAlgorithm, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newParentGraphicsAlgorithm, 10, msgs);
        return msgs;
    }

    @Override
    public void setParentGraphicsAlgorithm(GraphicsAlgorithm newParentGraphicsAlgorithm) {
        if (newParentGraphicsAlgorithm != this.eInternalContainer() || this.eContainerFeatureID() != 10 && newParentGraphicsAlgorithm != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newParentGraphicsAlgorithm)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newParentGraphicsAlgorithm != null) {
                msgs = ((InternalEObject)newParentGraphicsAlgorithm).eInverseAdd((InternalEObject)this, 9, GraphicsAlgorithm.class, msgs);
            }
            if ((msgs = this.basicSetParentGraphicsAlgorithm(newParentGraphicsAlgorithm, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newParentGraphicsAlgorithm, (Object)newParentGraphicsAlgorithm));
        }
    }

    @Override
    public PictogramElement getPictogramElement() {
        if (this.eContainerFeatureID() != 11) {
            return null;
        }
        return (PictogramElement)this.eContainer();
    }

    public PictogramElement basicGetPictogramElement() {
        if (this.eContainerFeatureID() != 11) {
            return null;
        }
        return (PictogramElement)this.eInternalContainer();
    }

    public NotificationChain basicSetPictogramElement(PictogramElement newPictogramElement, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newPictogramElement, 11, msgs);
        return msgs;
    }

    @Override
    public void setPictogramElement(PictogramElement newPictogramElement) {
        if (newPictogramElement != this.eInternalContainer() || this.eContainerFeatureID() != 11 && newPictogramElement != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newPictogramElement)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newPictogramElement != null) {
                msgs = ((InternalEObject)newPictogramElement).eInverseAdd((InternalEObject)this, 2, PictogramElement.class, msgs);
            }
            if ((msgs = this.basicSetPictogramElement(newPictogramElement, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newPictogramElement, (Object)newPictogramElement));
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int newWidth) {
        int oldWidth = this.width;
        this.width = newWidth;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldWidth, this.width));
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int newHeight) {
        int oldHeight = this.height;
        this.height = newHeight;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldHeight, this.height));
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int newX) {
        int oldX = this.x;
        this.x = newX;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldX, this.x));
        }
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int newY) {
        int oldY = this.y;
        this.y = newY;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, oldY, this.y));
        }
    }

    @Override
    public Style getStyle() {
        if (this.style != null && this.style.eIsProxy()) {
            InternalEObject oldStyle = (InternalEObject)this.style;
            this.style = (Style)this.eResolveProxy(oldStyle);
            if (this.style != oldStyle && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 16, (Object)oldStyle, (Object)this.style));
            }
        }
        return this.style;
    }

    public Style basicGetStyle() {
        return this.style;
    }

    @Override
    public void setStyle(Style newStyle) {
        Style oldStyle = this.style;
        this.style = newStyle;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldStyle, (Object)this.style));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getGraphicsAlgorithmChildren()).basicAdd((Object)otherEnd, msgs);
            }
            case 10: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParentGraphicsAlgorithm((GraphicsAlgorithm)otherEnd, msgs);
            }
            case 11: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetPictogramElement((PictogramElement)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return this.basicSetRenderingStyle(null, msgs);
            }
            case 9: {
                return ((InternalEList)this.getGraphicsAlgorithmChildren()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return this.basicSetParentGraphicsAlgorithm(null, msgs);
            }
            case 11: {
                return this.basicSetPictogramElement(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 10: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 9, GraphicsAlgorithm.class, msgs);
            }
            case 11: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 2, PictogramElement.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                if (resolve) {
                    return this.getBackground();
                }
                return this.basicGetBackground();
            }
            case 2: {
                if (resolve) {
                    return this.getForeground();
                }
                return this.basicGetForeground();
            }
            case 3: {
                return this.getLineWidth();
            }
            case 4: {
                return this.getLineStyle();
            }
            case 5: {
                return this.getFilled();
            }
            case 6: {
                return this.getLineVisible();
            }
            case 7: {
                if (resolve) {
                    return this.getRenderingStyle();
                }
                return this.basicGetRenderingStyle();
            }
            case 8: {
                return this.getTransparency();
            }
            case 9: {
                return this.getGraphicsAlgorithmChildren();
            }
            case 10: {
                if (resolve) {
                    return this.getParentGraphicsAlgorithm();
                }
                return this.basicGetParentGraphicsAlgorithm();
            }
            case 11: {
                if (resolve) {
                    return this.getPictogramElement();
                }
                return this.basicGetPictogramElement();
            }
            case 12: {
                return this.getWidth();
            }
            case 13: {
                return this.getHeight();
            }
            case 14: {
                return this.getX();
            }
            case 15: {
                return this.getY();
            }
            case 16: {
                if (resolve) {
                    return this.getStyle();
                }
                return this.basicGetStyle();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setBackground((Color)newValue);
                return;
            }
            case 2: {
                this.setForeground((Color)newValue);
                return;
            }
            case 3: {
                this.setLineWidth((Integer)newValue);
                return;
            }
            case 4: {
                this.setLineStyle((LineStyle)((Object)newValue));
                return;
            }
            case 5: {
                this.setFilled((Boolean)newValue);
                return;
            }
            case 6: {
                this.setLineVisible((Boolean)newValue);
                return;
            }
            case 7: {
                this.setRenderingStyle((RenderingStyle)newValue);
                return;
            }
            case 8: {
                this.setTransparency((Double)newValue);
                return;
            }
            case 9: {
                this.getGraphicsAlgorithmChildren().clear();
                this.getGraphicsAlgorithmChildren().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setParentGraphicsAlgorithm((GraphicsAlgorithm)newValue);
                return;
            }
            case 11: {
                this.setPictogramElement((PictogramElement)newValue);
                return;
            }
            case 12: {
                this.setWidth((Integer)newValue);
                return;
            }
            case 13: {
                this.setHeight((Integer)newValue);
                return;
            }
            case 14: {
                this.setX((Integer)newValue);
                return;
            }
            case 15: {
                this.setY((Integer)newValue);
                return;
            }
            case 16: {
                this.setStyle((Style)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setBackground(null);
                return;
            }
            case 2: {
                this.setForeground(null);
                return;
            }
            case 3: {
                this.setLineWidth(LINE_WIDTH_EDEFAULT);
                return;
            }
            case 4: {
                this.setLineStyle(LINE_STYLE_EDEFAULT);
                return;
            }
            case 5: {
                this.unsetFilled();
                return;
            }
            case 6: {
                this.unsetLineVisible();
                return;
            }
            case 7: {
                this.setRenderingStyle(null);
                return;
            }
            case 8: {
                this.setTransparency(TRANSPARENCY_EDEFAULT);
                return;
            }
            case 9: {
                this.getGraphicsAlgorithmChildren().clear();
                return;
            }
            case 10: {
                this.setParentGraphicsAlgorithm(null);
                return;
            }
            case 11: {
                this.setPictogramElement(null);
                return;
            }
            case 12: {
                this.setWidth(0);
                return;
            }
            case 13: {
                this.setHeight(0);
                return;
            }
            case 14: {
                this.setX(0);
                return;
            }
            case 15: {
                this.setY(0);
                return;
            }
            case 16: {
                this.setStyle(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.background != null;
            }
            case 2: {
                return this.foreground != null;
            }
            case 3: {
                return LINE_WIDTH_EDEFAULT == null ? this.lineWidth != null : !LINE_WIDTH_EDEFAULT.equals(this.lineWidth);
            }
            case 4: {
                return this.lineStyle != LINE_STYLE_EDEFAULT;
            }
            case 5: {
                return this.isSetFilled();
            }
            case 6: {
                return this.isSetLineVisible();
            }
            case 7: {
                return this.renderingStyle != null;
            }
            case 8: {
                return TRANSPARENCY_EDEFAULT == null ? this.transparency != null : !TRANSPARENCY_EDEFAULT.equals(this.transparency);
            }
            case 9: {
                return this.graphicsAlgorithmChildren != null && !this.graphicsAlgorithmChildren.isEmpty();
            }
            case 10: {
                return this.basicGetParentGraphicsAlgorithm() != null;
            }
            case 11: {
                return this.basicGetPictogramElement() != null;
            }
            case 12: {
                return this.width != 0;
            }
            case 13: {
                return this.height != 0;
            }
            case 14: {
                return this.x != 0;
            }
            case 15: {
                return this.y != 0;
            }
            case 16: {
                return this.style != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == AbstractStyle.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 5;
                }
                case 7: {
                    return 6;
                }
                case 8: {
                    return 7;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == AbstractStyle.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (lineWidth: ");
        result.append(this.lineWidth);
        result.append(", lineStyle: ");
        result.append((Object)this.lineStyle);
        result.append(", filled: ");
        if (this.filledESet) {
            result.append(this.filled);
        } else {
            result.append("<unset>");
        }
        result.append(", lineVisible: ");
        if (this.lineVisibleESet) {
            result.append(this.lineVisible);
        } else {
            result.append("<unset>");
        }
        result.append(", transparency: ");
        result.append(this.transparency);
        result.append(", width: ");
        result.append(this.width);
        result.append(", height: ");
        result.append(this.height);
        result.append(", x: ");
        result.append(this.x);
        result.append(", y: ");
        result.append(this.y);
        result.append(')');
        return result.toString();
    }
}

