/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.internal.diffmergetool.DiffTools;
import org.eclipse.jgit.internal.diffmergetool.ExternalDiffTool;
import org.eclipse.jgit.internal.diffmergetool.FileElement;
import org.eclipse.jgit.internal.diffmergetool.PromptContinueHandler;
import org.eclipse.jgit.internal.diffmergetool.ToolException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.lib.internal.BooleanTriState;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.PathTreeFilterHandler;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(name="difftool", common=true, usage="usage_DiffTool")
class DiffTool
extends TextBuiltin {
    private DiffFormatter diffFmt;
    private DiffTools diffTools;
    @Argument(index=0, metaVar="metaVar_treeish")
    private AbstractTreeIterator oldTree;
    @Argument(index=1, metaVar="metaVar_treeish")
    private AbstractTreeIterator newTree;
    private Optional<String> toolName = Optional.empty();
    @Option(name="--cached", aliases={"--staged"}, usage="usage_cached")
    private boolean cached;
    private BooleanTriState prompt = BooleanTriState.UNSET;
    @Option(name="--tool-help", usage="usage_toolHelp")
    private boolean toolHelp;
    private boolean gui = false;
    private BooleanTriState trustExitCode = BooleanTriState.UNSET;
    @Option(name="--", metaVar="metaVar_paths", handler=PathTreeFilterHandler.class)
    private TreeFilter pathFilter = TreeFilter.ALL;
    private BufferedReader inputReader;

    DiffTool() {
    }

    @Option(name="--tool", aliases={"-t"}, metaVar="metaVar_tool", usage="usage_ToolForDiff")
    void setToolName(String name) {
        this.toolName = Optional.of(name);
    }

    @Option(name="--prompt", usage="usage_prompt")
    void setPrompt(boolean on) {
        this.prompt = BooleanTriState.TRUE;
    }

    @Option(name="--no-prompt", aliases={"-y"}, usage="usage_noPrompt")
    void noPrompt(boolean on) {
        this.prompt = BooleanTriState.FALSE;
    }

    @Option(name="--gui", aliases={"-g"}, usage="usage_DiffGuiTool")
    void setGui(boolean on) {
        this.gui = true;
    }

    @Option(name="--no-gui", usage="usage_noGui")
    void noGui(boolean on) {
        this.gui = false;
    }

    @Option(name="--trust-exit-code", usage="usage_trustExitCode")
    void setTrustExitCode(boolean on) {
        this.trustExitCode = BooleanTriState.TRUE;
    }

    @Option(name="--no-trust-exit-code", usage="usage_noTrustExitCode")
    void noTrustExitCode(boolean on) {
        this.trustExitCode = BooleanTriState.FALSE;
    }

    @Override
    protected void init(Repository repository, String gitDir) {
        super.init(repository, gitDir);
        this.diffFmt = new DiffFormatter((OutputStream)new BufferedOutputStream(this.outs));
        this.diffTools = new DiffTools(repository);
        this.inputReader = new BufferedReader(new InputStreamReader(this.ins, StandardCharsets.UTF_8));
    }

    @Override
    protected void run() {
        try {
            try {
                if (this.toolHelp) {
                    this.showToolHelp();
                } else {
                    List<DiffEntry> files = this.getFiles();
                    if (files.size() > 0) {
                        this.compare(files);
                    }
                }
            }
            catch (IOException | RevisionSyntaxException e) {
                throw DiffTool.die(e.getMessage(), e);
            }
        }
        finally {
            this.diffFmt.close();
        }
    }

    private void informUserNoTool(List<String> tools) {
        try {
            StringBuilder toolNames = new StringBuilder();
            for (String name : tools) {
                toolNames.append(String.valueOf(name) + " ");
            }
            this.outw.println(MessageFormat.format(CLIText.get().diffToolPromptToolName, toolNames));
            this.outw.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot output text", e);
        }
    }

    private void compare(List<DiffEntry> files) throws IOException {
        try (ContentSource.Pair sourcePair = new ContentSource.Pair(this.source(this.oldTree), this.source(this.newTree));){
            int fileIndex = 0;
            while (fileIndex < files.size()) {
                DiffEntry ent = files.get(fileIndex);
                String filePath = ent.getNewPath();
                if (filePath.equals("/dev/null")) {
                    filePath = ent.getOldPath();
                }
                try {
                    FileElement local = this.createFileElement(FileElement.Type.LOCAL, sourcePair, DiffEntry.Side.OLD, ent);
                    FileElement remote = this.createFileElement(FileElement.Type.REMOTE, sourcePair, DiffEntry.Side.NEW, ent);
                    CountingPromptContinueHandler promptContinueHandler = new CountingPromptContinueHandler(fileIndex + 1, files.size(), filePath);
                    Optional optionalResult = this.diffTools.compare(local, remote, this.toolName, this.prompt, this.gui, this.trustExitCode, (PromptContinueHandler)promptContinueHandler, this::informUserNoTool);
                    if (optionalResult.isPresent()) {
                        FS.ExecutionResult result = (FS.ExecutionResult)optionalResult.get();
                        this.outw.println(new String(result.getStdout().toByteArray()));
                        this.outw.flush();
                        this.errw.println(new String(result.getStderr().toByteArray()));
                        this.errw.flush();
                    }
                }
                catch (ToolException e) {
                    this.outw.println(e.getResultStdout());
                    this.outw.flush();
                    this.errw.println(e.getMessage());
                    this.errw.flush();
                    throw DiffTool.die(MessageFormat.format(CLIText.get().diffToolDied, new Object[]{filePath, e}), (Throwable)e);
                }
                ++fileIndex;
            }
        }
    }

    private void showToolHelp() throws IOException {
        Map predefTools = this.diffTools.getPredefinedTools(true);
        StringBuilder availableToolNames = new StringBuilder();
        StringBuilder notAvailableToolNames = new StringBuilder();
        for (String name : predefTools.keySet()) {
            if (((ExternalDiffTool)predefTools.get(name)).isAvailable()) {
                availableToolNames.append(MessageFormat.format("\t\t{0}\n", name));
                continue;
            }
            notAvailableToolNames.append(MessageFormat.format("\t\t{0}\n", name));
        }
        StringBuilder userToolNames = new StringBuilder();
        Map userTools = this.diffTools.getUserDefinedTools();
        for (String name : userTools.keySet()) {
            userToolNames.append(MessageFormat.format("\t\t{0}.cmd {1}\n", name, ((ExternalDiffTool)userTools.get(name)).getCommand()));
        }
        this.outw.println(MessageFormat.format(CLIText.get().diffToolHelpSetToFollowing, availableToolNames, userToolNames, notAvailableToolNames));
    }

    private List<DiffEntry> getFiles() throws RevisionSyntaxException, AmbiguousObjectException, IncorrectObjectTypeException, IOException {
        this.diffFmt.setRepository(this.db);
        if (this.cached) {
            if (this.oldTree == null) {
                ObjectId head = this.db.resolve("HEAD^{tree}");
                if (head == null) {
                    DiffTool.die(MessageFormat.format(CLIText.get().notATree, "HEAD"));
                }
                CanonicalTreeParser p = new CanonicalTreeParser();
                Throwable throwable = null;
                Object var4_5 = null;
                try (ObjectReader reader = this.db.newObjectReader();){
                    p.reset(reader, (AnyObjectId)head);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.oldTree = p;
            }
            this.newTree = new DirCacheIterator(this.db.readDirCache());
        } else if (this.oldTree == null) {
            this.oldTree = new DirCacheIterator(this.db.readDirCache());
            this.newTree = new FileTreeIterator(this.db);
        } else if (this.newTree == null) {
            this.newTree = new FileTreeIterator(this.db);
        }
        TextProgressMonitor pm = new TextProgressMonitor((Writer)this.errw);
        pm.setDelayStart(2L, TimeUnit.SECONDS);
        this.diffFmt.setProgressMonitor((ProgressMonitor)pm);
        this.diffFmt.setPathFilter(this.pathFilter);
        List files = this.diffFmt.scan(this.oldTree, this.newTree);
        return files;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FileElement createFileElement(FileElement.Type elementType, ContentSource.Pair pair, DiffEntry.Side side, DiffEntry entry) throws NoWorkTreeException, CorruptObjectException, IOException, ToolException {
        String entryPath = side == DiffEntry.Side.NEW ? entry.getNewPath() : entry.getOldPath();
        FileElement fileElement = new FileElement(entryPath, elementType, this.db.getWorkTree());
        if (pair.isWorkingTreeSource(side) || fileElement.isNullPath()) return fileElement;
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            RevWalk revWalk = new RevWalk(this.db);
            try {
                try (TreeWalk treeWalk = new TreeWalk(this.db, revWalk.getObjectReader());){
                    treeWalk.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{entryPath}));
                    if (side == DiffEntry.Side.NEW) {
                        this.newTree.reset();
                        treeWalk.addTree(this.newTree);
                    } else {
                        this.oldTree.reset();
                        treeWalk.addTree(this.oldTree);
                    }
                    if (!treeWalk.next()) throw new ToolException("Cannot find path '" + entryPath + "' in staging area!", null);
                    CoreConfig.EolStreamType eolStreamType = treeWalk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                    String filterCommand = treeWalk.getFilterCommand("smudge");
                    WorkingTreeOptions opt = (WorkingTreeOptions)this.db.getConfig().get(WorkingTreeOptions.KEY);
                    DirCacheCheckout.CheckoutMetadata checkoutMetadata = new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand);
                    DirCacheCheckout.getContent((Repository)this.db, (String)entryPath, (DirCacheCheckout.CheckoutMetadata)checkoutMetadata, (ObjectLoader)pair.open(side, entry), (WorkingTreeOptions)opt, (OutputStream)new FileOutputStream(fileElement.createTempFile(null)));
                }
                if (revWalk == null) return fileElement;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (revWalk == null) throw throwable;
                revWalk.close();
                throw throwable;
            }
            revWalk.close();
            return fileElement;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private ContentSource source(AbstractTreeIterator iterator) {
        if (iterator instanceof WorkingTreeIterator) {
            return ContentSource.create((WorkingTreeIterator)((WorkingTreeIterator)iterator));
        }
        return ContentSource.create((ObjectReader)this.db.newObjectReader());
    }

    private class CountingPromptContinueHandler
    implements PromptContinueHandler {
        private final int fileIndex;
        private final int fileCount;
        private final String fileName;

        public CountingPromptContinueHandler(int fileIndex, int fileCount, String fileName) {
            this.fileIndex = fileIndex;
            this.fileCount = fileCount;
            this.fileName = fileName;
        }

        public boolean prompt(String toolToLaunchName) {
            try {
                boolean launchCompare = true;
                DiffTool.this.outw.println(String.valueOf(MessageFormat.format(CLIText.get().diffToolLaunch, this.fileIndex, this.fileCount, this.fileName, toolToLaunchName)) + " ");
                DiffTool.this.outw.flush();
                BufferedReader br = DiffTool.this.inputReader;
                String line = null;
                line = br.readLine();
                if (line != null && !line.equalsIgnoreCase("Y")) {
                    launchCompare = false;
                }
                return launchCompare;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot output text", e);
            }
        }
    }
}

