/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby.parser;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;

public class PythonEggParser {
    private Map<String, String> variables;
    private Map<String, String> setupOptions = new HashMap<String, String>();
    private IFile file;

    public PythonEggParser(IFile file) throws IOException, CoreException {
        this.variables = new HashMap<String, String>();
        if (file.getContents().available() <= 0) {
            return;
        }
        this.file = file;
        this.parse();
    }

    public void parse() {
        String line = "";
        String setupLine = "";
        ArrayList<String> vars = new ArrayList<String>();
        int offset = 0;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (RandomAccessFile raf = new RandomAccessFile(this.file.getRawLocation().makeAbsolute().toFile(), "r");){
                long bytesToSkip = PythonEggParser.findStartSetup(raf);
                if (bytesToSkip == -1L) {
                    return;
                }
                long stop = PythonEggParser.findEndSetup(raf, bytesToSkip);
                if (stop == -1L) {
                    return;
                }
                raf.seek(0L);
                while ((line = raf.readLine()) != null) {
                    if (line.trim().startsWith("#")) continue;
                    if (PythonEggParser.isLineSimpleDefinition(line)) {
                        vars.add(line);
                        continue;
                    }
                    if (vars.isEmpty() || !((String)vars.get(vars.size() - 1)).trim().endsWith("\\") || !PythonEggParser.isLineContinuation(line)) continue;
                    offset = ((String)vars.get(vars.size() - 1)).lastIndexOf(92);
                    vars.set(vars.size() - 1, ((String)vars.get(vars.size() - 1)).substring(0, offset));
                    vars.set(vars.size() - 1, ((String)vars.get(vars.size() - 1)).concat(line.trim()));
                }
                raf.seek(bytesToSkip);
                while ((line = raf.readLine()) != null && raf.getFilePointer() <= stop) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    setupLine = setupLine.equals("") ? line.trim() : setupLine.concat(line.trim());
                }
                List<String> list = PythonEggParser.prepareSetupOptions(setupLine);
                for (String str : vars) {
                    this.variables.putAll(PythonEggParser.parseLine(str));
                }
                for (String str : list) {
                    this.setupOptions.putAll(PythonEggParser.parseLine(str));
                }
                PythonEggParser.resolveVariables(this.variables, this.setupOptions);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
    }

    public boolean checkFunction(String str) {
        boolean rc = false;
        Pattern pattern = Pattern.compile("\\s*\\w*\\s*?\\(.*\\)\\s*");
        Matcher variableMatcher = pattern.matcher(str);
        if (variableMatcher.matches()) {
            rc = true;
        }
        return rc;
    }

    public String getValue(String key) {
        String rc = "";
        Pattern pattern = Pattern.compile("\\s*\\((.+)\\)\\s*");
        Matcher variableMatcher = null;
        if (this.setupOptions.containsKey(key) && (variableMatcher = pattern.matcher(rc = this.setupOptions.get(key).replaceAll("('|\")", "").trim())).matches()) {
            rc = variableMatcher.group(1);
        }
        return rc;
    }

    public List<String> getValueList(String key) {
        Matcher variableMatcher;
        ArrayList<String> rc = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^\\[(.*)\\]");
        if (this.setupOptions.containsKey(key) && (variableMatcher = pattern.matcher(this.setupOptions.get(key).trim())).find()) {
            String[] temp;
            String[] stringArray = temp = variableMatcher.group(1).replaceAll("('|\")", "").split(",");
            int n = temp.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (!str.isEmpty() && !str.trim().startsWith("#")) {
                    rc.add(str.trim());
                }
                ++n2;
            }
        }
        return rc;
    }

    private static List<String> prepareSetupOptions(String setupLine) {
        String[] tempList;
        ArrayList<String> rc = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\bsetup\\b(\\s+)?\\((.*)\\)");
        Matcher variableMatcher = pattern.matcher(setupLine);
        if (variableMatcher.find()) {
            setupLine = variableMatcher.group(2);
        }
        String[] stringArray = tempList = setupLine.split("(?=,)");
        int n = tempList.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (PythonEggParser.isOptionLineKeyValuePair(str) && !str.trim().startsWith("#")) {
                if (str.startsWith(",")) {
                    str = str.substring(1).trim();
                }
                rc.add(str);
            } else if (!str.trim().startsWith("#") && !rc.isEmpty()) {
                rc.set(rc.size() - 1, ((String)rc.get(rc.size() - 1)).concat(str.trim()));
            }
            ++n2;
        }
        return rc;
    }

    private static void resolveVariables(Map<String, String> variables, Map<String, String> options) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            if (!variables.containsKey(entry.getValue())) continue;
            options.put(entry.getKey(), variables.get(entry.getValue()));
        }
    }

    private static boolean isOptionLineKeyValuePair(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile("(\\w+)(\\s+)?=[^=].*");
        Matcher variableMatcher = pattern.matcher(line.toLowerCase());
        if (variableMatcher.find()) {
            rc = true;
        }
        return rc;
    }

    private static boolean isLineSimpleDefinition(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile("^(\\w+)(\\s+)?=(\\s+)?");
        Matcher variableMatcher = pattern.matcher(line.toLowerCase());
        if (variableMatcher.find()) {
            rc = true;
        }
        return rc;
    }

    private static boolean isLineContinuation(String line) {
        boolean rc = false;
        Pattern pattern = Pattern.compile(".*['\"](/s+)?$");
        Matcher variableMatcher = pattern.matcher(line.toLowerCase());
        if (variableMatcher.find()) {
            rc = true;
        }
        return rc;
    }

    private static Map<String, String> parseLine(String line) {
        HashMap<String, String> rc = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("(\\s+)?(\\w+)(\\s+)?=(\\s+)?(.*)");
        Matcher variableMatcher = pattern.matcher(line);
        if (variableMatcher.find()) {
            String value = variableMatcher.group(5);
            if (value.charAt(value.length() - 1) == ',') {
                value = value.substring(0, value.length() - 1);
            }
            rc.put(variableMatcher.group(2), value);
        }
        return rc;
    }

    private static long findStartSetup(RandomAccessFile reader) throws IOException {
        long rc = -1L;
        long previous = 0L;
        Pattern pattern = Pattern.compile("^\\bsetup\\b(\\s+)?(\\()?");
        Matcher variableMatcher = null;
        String line = "";
        reader.seek(0L);
        while ((line = reader.readLine()) != null && rc == -1L) {
            variableMatcher = pattern.matcher(line.toLowerCase());
            if (variableMatcher.find()) {
                rc = previous;
            }
            previous = reader.getFilePointer();
        }
        return rc;
    }

    private static long findEndSetup(RandomAccessFile reader, long startPosition) throws IOException {
        int bracketCounter = 0;
        boolean flag = false;
        boolean stop = false;
        String line = "";
        reader.seek(startPosition);
        while ((line = reader.readLine()) != null && !stop) {
            char[] cArray = line.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char x = cArray[n2];
                if (x == '(') {
                    ++bracketCounter;
                } else if (x == ')') {
                    --bracketCounter;
                }
                if (flag && bracketCounter == 0) {
                    stop = true;
                }
                if (bracketCounter != 0) {
                    flag = true;
                }
                ++n2;
            }
        }
        return reader.getFilePointer();
    }
}

