/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.Messages;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.internal.discovery.operation.MavenDiscoveryInstallOperation;
import org.eclipse.m2e.internal.discovery.operation.RestartInstallOperation;
import org.eclipse.m2e.internal.discovery.wizards.MavenDiscoveryInstallWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class MavenDiscoveryUi {
    private MavenDiscoveryUi() {
    }

    public static boolean install(List<CatalogItem> descriptors, IRunnableWithProgress postInstallHook, IRunnableContext context) throws CoreException {
        try {
            MavenDiscoveryInstallOperation runner = new MavenDiscoveryInstallOperation(descriptors, postInstallHook, true);
            context.run(true, true, (IRunnableWithProgress)runner);
            MavenDiscoveryUi.openInstallWizard(runner.getOperation(), true, context);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            Status status = new Status(4, "org.eclipse.m2e.discovery", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static int openInstallWizard(RestartInstallOperation operation, boolean blockOnOpen, IRunnableContext context) {
        OpenInstallWizardRunner runner = new OpenInstallWizardRunner(operation, blockOnOpen);
        try {
            context.run(false, false, (IRunnableWithProgress)runner);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.m2e.discovery", NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return 1;
        }
        catch (InterruptedException ex) {
            return 1;
        }
        return runner.getStatus();
    }

    private static class OpenInstallWizardRunner
    implements IRunnableWithProgress {
        private int status;
        private final RestartInstallOperation operation;
        private final boolean blockOnOpen;

        public OpenInstallWizardRunner(RestartInstallOperation operation, boolean blockOnOpen) {
            this.operation = operation;
            this.blockOnOpen = blockOnOpen;
        }

        public void run(IProgressMonitor arg0) {
            MavenDiscoveryInstallWizard wizard = new MavenDiscoveryInstallWizard(ProvisioningUI.getDefaultUI(), this.operation, this.operation.getIUs(), null);
            ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
            dialog.setBlockOnOpen(this.blockOnOpen);
            this.status = dialog.open();
        }

        public int getStatus() {
            return this.status;
        }
    }
}

