/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.pde.BNDInstructions;
import org.eclipse.m2e.pde.MavenTargetBundle;
import org.eclipse.m2e.pde.MissingMetadataMode;
import org.eclipse.pde.core.target.ITargetHandle;

public class CacheManager {
    private static final String LASTACCESS_MARKER = ".lastaccess";
    private static File baseDir;
    private static final Map<String, CacheManager> MANAGERS;
    private volatile boolean invalidated;
    private final File folder;

    static {
        MANAGERS = new HashMap<String, CacheManager>();
    }

    private CacheManager(File folder) {
        this.folder = folder;
        try {
            FileUtils.touch((File)new File(folder, LASTACCESS_MARKER));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized <R> R accessArtifactFile(Artifact artifact, CacheConsumer<R> consumer) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MavenTargetBundle getTargetBundle(Artifact artifact, BNDInstructions bndInstructions, MissingMetadataMode metadataMode) {
        if (this.invalidated) {
            throw new IllegalStateException("invalidated location");
        }
        Properties prop = bndInstructions == null ? BNDInstructions.getDefaultInstructions().asProperties() : bndInstructions.asProperties();
        return new MavenTargetBundle(artifact, prop, this, metadataMode);
    }

    public static synchronized CacheManager forTargetHandle(ITargetHandle handle) throws CoreException {
        if (baseDir == null) {
            throw new IllegalStateException("bundle not active");
        }
        String targetId = DigestUtils.sha1Hex((String)handle.getMemento());
        return MANAGERS.computeIfAbsent(targetId, key -> {
            File folder = new File(baseDir, (String)key);
            return new CacheManager(folder);
        });
    }

    public static synchronized void clearFilesOlderThan(long amount, TimeUnit unit) {
        if (baseDir == null) {
            throw new IllegalStateException("bundle not active");
        }
        File[] listFiles = baseDir.listFiles();
        long deleteStamp = System.currentTimeMillis() - unit.toMillis(amount);
        if (listFiles != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File marker;
                File folder = fileArray[n2];
                if (folder.isDirectory() && !MANAGERS.containsKey(folder.getName()) && (marker = new File(folder, LASTACCESS_MARKER)).isFile() && FileUtils.isFileOlder((File)marker, (long)deleteStamp)) {
                    try {
                        FileUtils.deleteDirectory((File)folder);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
    }

    static synchronized void setBasedir(File baseDir) {
        CacheManager.baseDir = baseDir;
        for (CacheManager m : MANAGERS.values()) {
            m.invalidated = true;
        }
        MANAGERS.clear();
    }

    public static boolean isOutdated(File cacheFile, File sourceFile) {
        if (cacheFile.exists()) {
            long cacheTimeStamp;
            long sourceTimeStamp = sourceFile.lastModified();
            return sourceTimeStamp > (cacheTimeStamp = cacheFile.lastModified());
        }
        return true;
    }

    public static interface CacheConsumer<T> {
        public T consume(File var1) throws Exception;
    }
}

