/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.exported.util.widget.command;

import java.util.Map;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialog;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.dialog.SynchronizedAbstractDialog;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.widget.command.AbstractCommandWidget;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.widget.command.IGetOrCreateFilteredElementCommmandWidget;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.widget.component.CreateElementWidget;
import org.eclipse.modisco.facet.util.ui.internal.widget.metaclass.FilteredElementSelectionWidget;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractGetOrCreateFilteredElementCommandWidget<T, W>
extends AbstractCommandWidget
implements IGetOrCreateFilteredElementCommmandWidget<T, W> {
    private static final int COLUMNS_NUMBER = 2;
    private FilteredElementSelectionWidget elementSelection;
    private CreateElementWidget<W> createElementW;

    protected AbstractGetOrCreateFilteredElementCommandWidget(Composite parent) {
        super(parent);
        this.setLayout((Layout)new GridLayout(2, false));
    }

    @Override
    protected void addSubWidgets() {
        Object[] array = this.getElements().keySet().toArray();
        this.elementSelection = new FilteredElementSelectionWidget(this, array);
        this.addSubWidget(this.elementSelection);
        IDialog<W> dialog = this.createDialog();
        if (dialog != null) {
            this.createElementW = new CreateElementWidget<W>(this, dialog);
            this.addSubWidget(this.createElementW);
        }
    }

    protected abstract Map<String, T> getElements();

    protected abstract IDialog<W> createDialog();

    public void updateFilteredList() {
        this.elementSelection.setElements(this.getElements().keySet().toArray());
    }

    @Override
    public T getElementSelected() {
        T result = null;
        Object selectedElement = this.elementSelection.getFirstSelectedElement();
        if (selectedElement != null) {
            String elementName = selectedElement.toString();
            result = this.getElements().get(elementName);
        }
        return result;
    }

    @Override
    public void selectElement(T element) {
        Object[] selectionsParam = new Object[1];
        for (String key : this.getElements().keySet()) {
            if (this.getElements().get(key) != element) continue;
            selectionsParam[0] = key;
            this.elementSelection.getFilteredList().setSelection(selectionsParam);
            break;
        }
    }

    @Override
    public void selectElementByName(String name) {
        T element = this.getElements().get(name);
        this.selectElement(element);
    }

    @Override
    public IDialog<W> pressNewButton() {
        return new SynchronizedAbstractDialog<W>(this.createElementW.pressNewButton(), this.getDisplay());
    }
}

