/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.editor.editors;

import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.modisco.infra.browser.custom.CustomView;
import org.eclipse.modisco.infra.browser.custom.CustomViewFeature;
import org.eclipse.modisco.infra.browser.custom.CustomizableFeatures;
import org.eclipse.modisco.infra.browser.custom.DerivedFeatureValue;
import org.eclipse.modisco.infra.browser.custom.FeatureValue;
import org.eclipse.modisco.infra.browser.custom.FeatureValueCase;
import org.eclipse.modisco.infra.browser.custom.StaticFeatureValue;
import org.eclipse.modisco.infra.browser.custom.editor.Activator;
import org.eclipse.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.modisco.infra.browser.custom.util.UicustomUtil;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ColorProvider;
import org.eclipse.modisco.infra.browser.uicore.internal.util.EMFUtil;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.modisco.infra.common.core.internal.utils.PathUtils;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.query.ModelQuery;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class CustomizationViewer {
    private static final int VALUE_COLUMN_WIDTH = 400;
    private static final int FEATURE_COLUMN_WIDTH = 200;
    private final TreeViewer treeViewer;

    public CustomizationViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 68356);
        this.treeViewer.getTree().setHeaderVisible(true);
        TreeViewerColumn featureColumn = new TreeViewerColumn(this.treeViewer, 16384);
        featureColumn.getColumn().setText(Messages.CustomizationViewer_feature);
        featureColumn.getColumn().setWidth(200);
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.treeViewer, 16384);
        valueColumn.getColumn().setText(Messages.CustomizationViewer_value);
        valueColumn.getColumn().setWidth(400);
        this.treeViewer.setContentProvider((IContentProvider)new CustomizationViewerContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new FeatureLabelProvider());
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof FeatureValueCase) {
                    return 0;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        featureColumn.setLabelProvider((CellLabelProvider)new FeatureLabelProvider());
        valueColumn.setLabelProvider((CellLabelProvider)new ValueLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizationViewer.this.treeViewer.refresh();
            }
        });
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    private boolean isSelected(ViewerCell cell) {
        TreeItem treeItem = (TreeItem)cell.getItem();
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        return selection.toList().contains(treeItem.getData());
    }

    public void refresh() {
        if (!this.treeViewer.getTree().isDisposed()) {
            try {
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getTree().setRedraw(true);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener selectionChangedListener) {
        this.treeViewer.addSelectionChangedListener(selectionChangedListener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    protected static class CustomizationViewerContentProvider
    implements ITreeContentProvider {
        protected CustomizationViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CustomView) {
                CustomView customView = (CustomView)inputElement;
                EList customizedFeatures = customView.getCustomizedFeatures();
                return customizedFeatures.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CustomViewFeature) {
                CustomViewFeature customViewFeature = (CustomViewFeature)parentElement;
                EList valueCases = customViewFeature.getValueCases();
                return valueCases.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof FeatureValueCase) {
                FeatureValueCase featureValueCase = (FeatureValueCase)element;
                return featureValueCase.getFeature();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof CustomViewFeature) {
                CustomViewFeature customViewFeature = (CustomViewFeature)element;
                return !customViewFeature.getValueCases().isEmpty();
            }
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class FeatureLabelProvider
    extends ColumnLabelProvider {
        protected FeatureLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof CustomViewFeature) {
                CustomViewFeature customViewFeature = (CustomViewFeature)element;
                return this.getDisplayName(customViewFeature.getCustomizedFeature());
            }
            if (element instanceof FeatureValueCase) {
                FeatureValueCase featureValueCase = (FeatureValueCase)element;
                ModelQuery condition = featureValueCase.getCondition();
                if (EMFUtil.tryResolve((EObject)condition)) {
                    return condition.getName();
                }
                String text = EMFUtil.proxyURI((EObject)condition);
                return text;
            }
            return element.toString();
        }

        private String getDisplayName(CustomizableFeatures customizedFeature) {
            switch (customizedFeature) {
                case VISIBLE: {
                    return Messages.CustomizationViewer_isVisible;
                }
                case METACLASS_VISIBLE: {
                    return Messages.CustomizationViewer_metaclassVisible;
                }
                case COLOR: {
                    return Messages.CustomizationViewer_textColor;
                }
                case BACKGROUND_COLOR: {
                    return Messages.CustomizationViewer_backgroundColor;
                }
                case FONT_NAME: {
                    return Messages.CustomizationViewer_textFontName;
                }
                case ICON: {
                    return Messages.CustomizationViewer_typeIcon;
                }
                case FACET_MAIN_ICON: {
                    return Messages.CustomizationViewer_instanceIcon;
                }
                case FACET_OVERLAY_ICON: {
                    return Messages.CustomizationViewer_overlayIcon;
                }
                case INSTANCE_ICON: {
                    return Messages.CustomizationViewer_instanceIcon;
                }
                case METACLASS_ICON: {
                    return Messages.CustomizationViewer_metaclassIcon;
                }
                case STICKER_ICON: {
                    return Messages.CustomizationViewer_stickerIcon;
                }
                case LABEL: {
                    return Messages.CustomizationViewer_label;
                }
                case ITALIC: {
                    return Messages.CustomizationViewer_isItalic;
                }
                case BOLD: {
                    return Messages.CustomizationViewer_isBold;
                }
                case UNDERLINED: {
                    return Messages.CustomizationViewer_isUnderlined;
                }
                case STRUCKTHROUGH: {
                    return Messages.CustomizationViewer_isStruckthrough;
                }
                case HIDE_METACLASS_NAME: {
                    return Messages.CustomizationViewer_hideMetaclassName;
                }
                case COLLAPSE_LINK: {
                    return Messages.CustomizationViewer_collapseLink;
                }
            }
            MoDiscoLogger.logWarning((String)"Missing friendly feature name", (Plugin)Activator.getDefault());
            return customizedFeature.getName();
        }

        public Image getImage(Object element) {
            if (element instanceof FeatureValueCase) {
                FeatureValueCase featureValueCase = (FeatureValueCase)element;
                ModelQuery condition = featureValueCase.getCondition();
                if (EMFUtil.tryResolve((EObject)condition)) {
                    return ImageProvider.getInstance().getPredicateIcon();
                }
                return ImageProvider.getInstance().getErrorIcon();
            }
            return ImageProvider.getInstance().getFeatureIcon();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            CustomizableFeatures customizedFeature;
            CustomViewFeature customViewFeature;
            FeatureValueCase featureValueCase;
            ModelQuery condition;
            if (element instanceof FeatureValueCase && !EMFUtil.tryResolve((EObject)(condition = (featureValueCase = (FeatureValueCase)element).getCondition()))) {
                return ColorProvider.getInstance().getUnresolvedProxyColor();
            }
            if (element instanceof CustomViewFeature && (customViewFeature = (CustomViewFeature)element).getDefaultValue() == null && customViewFeature.getValueCases().size() == 0) {
                return ColorProvider.getInstance().getGray();
            }
            if (element instanceof CustomViewFeature && (customizedFeature = (customViewFeature = (CustomViewFeature)element).getCustomizedFeature()) == CustomizableFeatures.ICON) {
                return Display.getDefault().getSystemColor(4);
            }
            return null;
        }

        public Font getFont(Object element) {
            return null;
        }
    }

    protected class ValueLabelProvider
    extends StyledCellLabelProvider {
        private final HashMap<Integer, Color> colors;
        private final HashMap<String, Image> images;

        public ValueLabelProvider() {
            super(1);
            this.colors = new HashMap();
            this.images = new HashMap();
        }

        public String getText(Object element) {
            FeatureValue featureValue = UicustomUtil.getFeatureValue((Object)element);
            if (featureValue instanceof StaticFeatureValue) {
                StaticFeatureValue staticFeatureValue = (StaticFeatureValue)featureValue;
                return staticFeatureValue.getValue().toString();
            }
            if (featureValue instanceof DerivedFeatureValue) {
                DerivedFeatureValue derivedFeatureValue = (DerivedFeatureValue)featureValue;
                ModelQuery valueCalculator = derivedFeatureValue.getValueCalculator();
                if (EMFUtil.tryResolve((EObject)valueCalculator)) {
                    return valueCalculator.getName();
                }
                String text = EMFUtil.proxyURI((EObject)valueCalculator);
                return text;
            }
            return Messages.CustomizationViewer_defaultValue;
        }

        public Image getImage(Object element) {
            FeatureValue featureValue = UicustomUtil.getFeatureValue((Object)element);
            if (featureValue instanceof DerivedFeatureValue) {
                return ImageProvider.getInstance().getOperationIcon();
            }
            if (featureValue instanceof StaticFeatureValue) {
                StaticFeatureValue staticFeatureValue = (StaticFeatureValue)featureValue;
                CustomizableFeatures customizedFeature = UicustomUtil.getCustomizedFeature((FeatureValue)featureValue);
                if (customizedFeature == CustomizableFeatures.ICON || customizedFeature == CustomizableFeatures.FACET_MAIN_ICON || customizedFeature == CustomizableFeatures.FACET_OVERLAY_ICON || customizedFeature == CustomizableFeatures.INSTANCE_ICON || customizedFeature == CustomizableFeatures.METACLASS_ICON || customizedFeature == CustomizableFeatures.STICKER_ICON) {
                    String value = staticFeatureValue.getValue();
                    int colonPos = value.indexOf(58);
                    if (colonPos != -1) {
                        value = value.substring(0, colonPos);
                    }
                    return this.getImage(value);
                }
            }
            return null;
        }

        private Image getImage(String strValue) {
            Image icon = this.images.get(strValue);
            if (icon == null) {
                InputStream inputStream;
                block4: {
                    try {
                        inputStream = PathUtils.getResourceStream((IPath)new Path(strValue));
                        if (inputStream != null) break block4;
                        return null;
                    }
                    catch (Exception e) {
                        return ImageDescriptor.getMissingImageDescriptor().createImage();
                    }
                }
                icon = new Image((Device)Display.getCurrent(), inputStream);
                inputStream.close();
                this.images.put(strValue, icon);
            }
            return icon;
        }

        public void dispose() {
            for (Color color : this.colors.values()) {
                color.dispose();
            }
            for (Image image : this.images.values()) {
                image.dispose();
            }
            super.dispose();
        }

        private Color getColor(RGB rgb) {
            int key = rgb.hashCode();
            Color color = this.colors.get(key);
            if (color == null) {
                color = new Color((Device)Display.getCurrent(), rgb);
                this.colors.put(key, color);
            }
            return color;
        }

        public void update(ViewerCell cell) {
            DerivedFeatureValue derivedFeatureValue;
            ModelQuery valueCalculator;
            CustomViewFeature customViewFeature;
            Object element = cell.getElement();
            boolean gray = false;
            if (element instanceof CustomViewFeature && (customViewFeature = (CustomViewFeature)element).getDefaultValue() == null) {
                gray = true;
            }
            boolean unresolved = false;
            FeatureValue featureValue = UicustomUtil.getFeatureValue((Object)element);
            if (featureValue instanceof DerivedFeatureValue && !EMFUtil.tryResolve((EObject)(valueCalculator = (derivedFeatureValue = (DerivedFeatureValue)featureValue).getValueCalculator()))) {
                unresolved = true;
            }
            if (unresolved) {
                String text = this.getText(element);
                cell.setText(text);
                cell.setStyleRanges(new StyleRange[]{new StyleRange(0, text.length(), ColorProvider.getInstance().getUnresolvedProxyColor(), null)});
                cell.setImage(ImageProvider.getInstance().getErrorIcon());
                super.update(cell);
            } else {
                RGB color = this.getStaticFeatureValueColor(element);
                if (color != null) {
                    String colorBlob = "      ";
                    String text = "       " + this.getText(element);
                    cell.setText(text);
                    StyleRange colorStyleRange = new StyleRange(0, "      ".length(), null, this.getColor(color));
                    Color textColor = CustomizationViewer.this.isSelected(cell) ? this.getSelectedTextColor() : Display.getDefault().getSystemColor(24);
                    cell.setStyleRanges(new StyleRange[]{colorStyleRange, new StyleRange("      ".length(), text.length() - "      ".length(), textColor, null)});
                } else {
                    String text = this.getText(element);
                    cell.setText(text);
                    if (gray) {
                        cell.setStyleRanges(new StyleRange[]{new StyleRange(0, text.length(), ColorProvider.getInstance().getGray(), null)});
                    } else if (CustomizationViewer.this.isSelected(cell)) {
                        cell.setStyleRanges(new StyleRange[]{new StyleRange(0, text.length(), this.getSelectedTextColor(), null)});
                    } else {
                        cell.setStyleRanges(new StyleRange[0]);
                    }
                }
                cell.setImage(this.getImage(element));
                super.update(cell);
            }
        }

        private Color getSelectedTextColor() {
            double threshold = 0.4;
            double brightness = this.getBrightness(Display.getDefault().getSystemColor(26).getRGB());
            if (brightness > 0.4) {
                return Display.getDefault().getSystemColor(2);
            }
            return Display.getDefault().getSystemColor(1);
        }

        private double getBrightness(RGB rgb) {
            double maxIntensity = 255.0;
            double redWeight = 0.241;
            double greenWeight = 0.691;
            double blueWeight = 0.068;
            return Math.sqrt((double)(rgb.red * rgb.red) * 0.241 + (double)(rgb.green * rgb.green) * 0.691 + (double)(rgb.blue * rgb.blue) * 0.068) / 255.0;
        }

        private RGB getStaticFeatureValueColor(Object element) {
            String value;
            RGB color;
            StaticFeatureValue staticFeatureValue;
            CustomizableFeatures customizedFeature;
            FeatureValue featureValue = UicustomUtil.getFeatureValue((Object)element);
            if (featureValue instanceof StaticFeatureValue && ((customizedFeature = UicustomUtil.getCustomizedFeature((FeatureValue)(staticFeatureValue = (StaticFeatureValue)featureValue))) == CustomizableFeatures.COLOR || customizedFeature == CustomizableFeatures.BACKGROUND_COLOR) && (color = UicustomUtil.decodeColor((String)(value = staticFeatureValue.getValue()))) != null) {
                return color;
            }
            return null;
        }
    }
}

