/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.omg.kdm.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StorableKind implements Enumerator
{
    GLOBAL(0, "global", "global"),
    LOCAL(1, "local", "local"),
    STATIC(2, "static", "static"),
    EXTERNAL(3, "external", "external"),
    REGISTER(4, "register", "register"),
    UNKNOWN(5, "unknown", "unknown");

    public static final int GLOBAL_VALUE = 0;
    public static final int LOCAL_VALUE = 1;
    public static final int STATIC_VALUE = 2;
    public static final int EXTERNAL_VALUE = 3;
    public static final int REGISTER_VALUE = 4;
    public static final int UNKNOWN_VALUE = 5;
    private static final StorableKind[] VALUES_ARRAY;
    public static final List<StorableKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StorableKind[]{GLOBAL, LOCAL, STATIC, EXTERNAL, REGISTER, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StorableKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StorableKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StorableKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StorableKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StorableKind get(int value) {
        switch (value) {
            case 0: {
                return GLOBAL;
            }
            case 1: {
                return LOCAL;
            }
            case 2: {
                return STATIC;
            }
            case 3: {
                return EXTERNAL;
            }
            case 4: {
                return REGISTER;
            }
            case 5: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private StorableKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

