/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.ui.nature;

import java.util.HashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ocl.pivot.ui.builder.OCLBuilder;

public class OCLNature
implements IProjectNature {
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.ocl.pivot.ui.oclbuilder")) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 1, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.ocl.pivot.ui.oclbuilder");
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("disabledExtensions", "*,essentialocl");
        args.put("enabledExtensions", "ecore,ocl,oclinecore,oclstdlib,uml");
        args.put("disabledPaths", "bin/**,target/**");
        args.put("enabledPaths", "**");
        command.setArguments(args);
        newCommands[0] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
    }

    public void deconfigure() throws CoreException {
        IProject project2 = this.getProject();
        IProjectDescription description = project2.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            ICommand oldCommands = commands[i];
            if (oldCommands.getBuilderName().equals("org.eclipse.ocl.pivot.ui.oclbuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                OCLBuilder.deleteMarkers(project2, oldCommands.getArguments());
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

