/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.as2cs;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.xtext.base.as2cs.BaseLocationInFileProvider;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.essentialocl.attributes.NavigationUtil;
import org.eclipse.ocl.xtext.essentialoclcs.ExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.InfixExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NameExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.OperatorExpCS;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

public class EssentialOCLLocationInFileProvider
extends BaseLocationInFileProvider {
    private static final @NonNull ITextRegion EMPTY_REGION = ITextRegion.EMPTY_REGION;

    protected @NonNull ITextRegion getTextRegion(EObject obj, boolean isSignificant) {
        ModelElementCS csModelElement = null;
        if (obj instanceof Element) {
            csModelElement = ElementUtil.getCsElement((Element)((Element)obj));
        } else if (obj instanceof ElementCS) {
            csModelElement = (ElementCS)obj;
        }
        ITextRegion textRegion = csModelElement instanceof ExpCS ? this.getTextRegionCS((ExpCS)csModelElement, isSignificant) : (csModelElement == null ? this.getTextRegionNoCS(obj, isSignificant) : super.getTextRegion(obj, isSignificant));
        return textRegion;
    }

    public @NonNull ITextRegion getTextRegionCS(@NonNull ExpCS csExp, boolean isSignificant) {
        if (!isSignificant) {
            ExpCS csLeft;
            ExpCS csLeftmost = csExp;
            ExpCS csRightmost = csExp;
            if (csLeftmost instanceof NameExpCS && NavigationUtil.isNavigationInfixExp((EObject)(csLeft = ((NameExpCS)csLeftmost).getLocalLeft()))) {
                assert (csLeft != null);
                csLeftmost = (InfixExpCS)csLeft;
            }
            while (csLeftmost instanceof OperatorExpCS) {
                ExpCS csSource = ((OperatorExpCS)csLeftmost).getSource();
                if (csSource == null) break;
                csLeftmost = csSource;
            }
            while (csRightmost instanceof InfixExpCS) {
                ExpCS csArgument = ((InfixExpCS)csRightmost).getArgument();
                if (csArgument == null) break;
                csRightmost = csArgument;
            }
            ITextRegion leftRegion = super.getTextRegion((EObject)csLeftmost, isSignificant);
            ITextRegion rightRegion = super.getTextRegion((EObject)csRightmost, isSignificant);
            return (ITextRegion)ClassUtil.nonNullState((Object)leftRegion.merge(rightRegion));
        }
        return super.getTextRegion((EObject)csExp, isSignificant);
    }

    protected @NonNull ITextRegion getTextRegionNoCS(EObject obj, boolean isSignificant) {
        int significantEnd;
        int significantStart;
        Element asParentElement = null;
        EObject eObject = obj;
        while (eObject != null) {
            ModelElementCS csModelElement;
            if (eObject instanceof Element && (csModelElement = ElementUtil.getCsElement((Element)((Element)eObject))) != null) {
                asParentElement = (Element)eObject;
                break;
            }
            eObject = eObject.eContainer();
        }
        if (asParentElement == null) {
            return EMPTY_REGION;
        }
        ITextRegion parentSignificantTextRegion = this.getTextRegion((EObject)asParentElement, true);
        ITextRegion childrenFullTextRegion = null;
        for (EObject eChild : obj.eContents()) {
            ModelElementCS csModelElement;
            if (!(eChild instanceof Element) || (csModelElement = ElementUtil.getCsElement((Element)((Element)eChild))) == null) continue;
            ITextRegion childFullTextRegion = this.getTextRegion((EObject)csModelElement, false);
            ITextRegion iTextRegion = childrenFullTextRegion = childrenFullTextRegion != null ? childrenFullTextRegion.merge(childFullTextRegion) : childFullTextRegion;
        }
        if (childrenFullTextRegion == null) {
            return new TextRegionWithLineInformation(parentSignificantTextRegion.getOffset(), 0, 0, 0);
        }
        int parentStart = parentSignificantTextRegion.getOffset();
        int parentEnd = parentStart + parentSignificantTextRegion.getLength();
        int childStart = childrenFullTextRegion.getOffset();
        int childEnd = childStart + childrenFullTextRegion.getLength();
        int fullStart = childStart;
        int fullEnd = childEnd;
        if (parentEnd < fullStart) {
            significantStart = parentEnd;
            significantEnd = fullStart;
            fullStart = parentEnd;
        } else if (fullEnd < parentStart) {
            significantStart = fullEnd;
            significantEnd = parentStart;
            fullEnd = parentStart;
        } else {
            significantStart = childEnd;
            significantEnd = childEnd;
        }
        if (isSignificant) {
            return new TextRegionWithLineInformation(significantStart, significantEnd - significantStart, 0, 0);
        }
        return new TextRegionWithLineInformation(fullStart, fullEnd - fullStart, 0, 0);
    }
}

