/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StyledElement;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;

public class SetWrapTextHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain = this.getTableEditingDomain();
        Table table = this.getTable();
        if (editingDomain != null && table != null) {
            BooleanValueStyle wrapTextValue = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "wrapText");
            if (wrapTextValue != null) {
                if (wrapTextValue.isBooleanValue()) {
                    NatEventData natEventData;
                    BooleanValueStyle autoResizeValue = (BooleanValueStyle)table.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "autoResizeCellHeight");
                    if (autoResizeValue != null && autoResizeValue.isBooleanValue() && (natEventData = this.getNatEventData()) != null && natEventData.getNatTable() != null) {
                        NatTable natTable = natEventData.getNatTable();
                        natTable.getConfigRegistry().registerConfigAttribute(NattableConfigAttributes.REINITIALISE_ROW_HEIGHT, (Object)true);
                    }
                    StyleUtils.deleteBooleanNamedStyle(editingDomain, (StyledElement)table, "wrapText");
                } else {
                    StyleUtils.setBooleanNamedStyle(editingDomain, (StyledElement)table, "wrapText", true);
                }
            } else {
                StyleUtils.initBooleanNamedStyle(editingDomain, (StyledElement)table, "wrapText", true);
            }
        }
        return null;
    }
}

