/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.language;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.core.language.ILanguageModelProvider;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.language.DefaultLanguageModelProvider;
import org.eclipse.php.internal.core.language.LanguageModelContainer;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.project.PHPVersionChangedHandler;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;

public class LanguageModelInitializer
extends BuildpathContainerInitializer {
    public static final String PHP_LANGUAGE_LIBRARY = "PHP Language Library";
    public static final String CONTAINER_PATH = "org.eclipse.php.core.LANGUAGE";
    public static final Path LANGUAGE_CONTAINER_PATH = new Path("org.eclipse.php.core.LANGUAGE");
    private static final String LANGUAGE_PREFIX = "__language__";
    private Map<IProject, IPreferencesPropagatorListener> project2PhpVerListener = new HashMap<IProject, IPreferencesPropagatorListener>();
    private static ILanguageModelProvider[] providers;
    private static Map<IPath, String> pathToName;

    static {
        pathToName = Collections.synchronizedMap(new HashMap());
    }

    static void addPathName(IPath path, String name) {
        pathToName.put(path, name);
    }

    public static String getPathName(IPath path) {
        return pathToName.get(path);
    }

    private void initializeListener(final IPath containerPath, final IScriptProject scriptProject) {
        final IProject project = scriptProject.getProject();
        if (this.project2PhpVerListener.containsKey(project)) {
            return;
        }
        IPreferencesPropagatorListener versionChangeListener = new IPreferencesPropagatorListener(){

            @Override
            public void preferencesEventOccured(PreferencesPropagatorEvent event) {
                try {
                    LanguageModelInitializer.this.initialize(containerPath, scriptProject);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }

            @Override
            public IProject getProject() {
                return project;
            }
        };
        this.project2PhpVerListener.put(project, versionChangeListener);
        PHPVersionChangedHandler.getInstance().addPHPVersionChangedListener(versionChangeListener);
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(project, new IProjectClosedObserver(){

            @Override
            public void closed() {
                PHPVersionChangedHandler.getInstance().removePHPVersionChangedListener(LanguageModelInitializer.this.project2PhpVerListener.get(project));
                TaskPatternsProvider.unregisterProject(project);
                LanguageModelInitializer.this.project2PhpVerListener.remove(project);
            }
        });
    }

    public void initialize(IPath containerPath, IScriptProject scriptProject) throws CoreException {
        if (containerPath.segmentCount() > 0 && containerPath.segment(0).equals(CONTAINER_PATH)) {
            try {
                if (LanguageModelInitializer.isPHPProject(scriptProject)) {
                    DLTKCore.setBuildpathContainer((IPath)containerPath, (IScriptProject[])new IScriptProject[]{scriptProject}, (IBuildpathContainer[])new IBuildpathContainer[]{new LanguageModelContainer(containerPath, scriptProject)}, null);
                    this.initializeListener(containerPath, scriptProject);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    private static boolean isPHPProject(IScriptProject project) {
        String nature = LanguageModelInitializer.getNatureFromProject(project);
        return "org.eclipse.php.core.PHPNature".equals(nature);
    }

    private static String getNatureFromProject(IScriptProject project) {
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)project);
        if (languageToolkit != null) {
            return languageToolkit.getNatureId();
        }
        return null;
    }

    public static boolean isLanguageModelElement(IModelElement element) {
        IPath path;
        IProjectFragment fragment;
        if (element != null && (fragment = (IProjectFragment)element.getAncestor(3)) != null && fragment.isExternal() && (path = fragment.getPath()).segmentCount() > 2) {
            return LANGUAGE_PREFIX.equals(path.segment(path.segmentCount() - 2));
        }
        return false;
    }

    public static void enableLanguageModelFor(IScriptProject project) throws ModelException {
        IBuildpathEntry[] rawBuildpath;
        if (!LanguageModelInitializer.isPHPProject(project)) {
            return;
        }
        boolean found = false;
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath = project.getRawBuildpath();
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)LANGUAGE_CONTAINER_PATH)) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            IBuildpathEntry containerEntry = DLTKCore.newContainerEntry((IPath)LANGUAGE_CONTAINER_PATH);
            int newSize = rawBuildpath.length + 1;
            ArrayList<IBuildpathEntry> newRawBuildpath = new ArrayList<IBuildpathEntry>(newSize);
            newRawBuildpath.addAll(Arrays.asList(rawBuildpath));
            newRawBuildpath.add(containerEntry);
            project.setRawBuildpath(newRawBuildpath.toArray(new IBuildpathEntry[newSize]), null);
        }
    }

    static ILanguageModelProvider[] getContributedProviders() {
        if (providers == null) {
            IConfigurationElement[] elements;
            LinkedList<ILanguageModelProvider> providers = new LinkedList<ILanguageModelProvider>();
            providers.add(new DefaultLanguageModelProvider());
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core.languageModelProviders");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("provider")) {
                    try {
                        providers.add((ILanguageModelProvider)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPCorePlugin.log(e);
                    }
                }
                ++n2;
            }
            LanguageModelInitializer.providers = providers.toArray(new ILanguageModelProvider[providers.size()]);
        }
        return providers;
    }

    static IPath getTargetLocation(ILanguageModelProvider provider, IPath sourcePath, IScriptProject project) {
        return provider.getPlugin().getStateLocation().append(LANGUAGE_PREFIX).append(Integer.toHexString(sourcePath.toOSString().hashCode()));
    }

    public static void cleanup(IProgressMonitor monitor) throws CoreException {
        int n;
        int n2;
        Object[] objectArray;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IPath> inUse = new HashSet<IPath>();
        HashSet<IPath> toDrop = new HashSet<IPath>();
        Object[] objectArray2 = projects;
        int n3 = projects.length;
        int n4 = 0;
        while (n4 < n3) {
            IBuildpathContainer container;
            IProject project = objectArray2[n4];
            if (PHPToolkitUtil.isPHPProject(project) && (container = DLTKCore.getBuildpathContainer((IPath)Path.fromPortableString((String)CONTAINER_PATH), (IScriptProject)DLTKCore.create((IProject)project))) != null) {
                objectArray = container.getBuildpathEntries();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    IBuildpathEntry entry = objectArray[n];
                    inUse.add(entry.getPath());
                    ++n;
                }
            }
            ++n4;
        }
        objectArray2 = LanguageModelInitializer.getContributedProviders();
        n3 = objectArray2.length;
        n4 = 0;
        while (n4 < n3) {
            IProject provider = objectArray2[n4];
            File dir = provider.getPlugin().getStateLocation().append(LANGUAGE_PREFIX).toFile();
            if (dir.exists() && dir.isDirectory()) {
                objectArray = dir.listFiles();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    IBuildpathEntry lib = objectArray[n];
                    IPath compare = EnvironmentPathUtils.getFullPath((String)"org.eclipse.dltk.core.environment.localEnvironment", (IPath)Path.fromOSString((String)lib.getPath()));
                    if (!inUse.contains(compare)) {
                        toDrop.add(compare);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        IFileSystem efs = EFS.getLocalFileSystem();
        for (IPath path : toDrop) {
            ProjectIndexerManager.removeProject((IPath)path);
            efs.getStore(EnvironmentPathUtils.getLocalPath((IPath)path)).delete(0, monitor);
        }
    }
}

