/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.wizard;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.PackageContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.scout.sdk.s2e.util.ApiHelper;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public abstract class AbstractCompilationUnitNewWizardPage
extends AbstractWizardPage {
    private static final Pattern WELL_FORMED_JAVA_FIELD = Pattern.compile("\\b[A-Z]\\w{0,200}\\b");
    private static final Pattern JAVA_FIELD = Pattern.compile("\\b[A-Za-z_]\\w{0,200}\\b");
    public static final String PROP_SOURCE_FOLDER = "sourceFolder";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_JAVA_PROJECT = "javaProject";
    public static final String PROP_ICU_NAME = "icuName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_SUPER_TYPE_BASE = "superTypeBase";
    public static final String PREF_SUPER_TYPE = "superType";
    private final ScoutTier m_sourceFolderTier;
    private IScoutApi m_scoutApi;
    private String m_superTypeDefaultBase;
    private String m_superTypeDefault;
    private String m_readOnlySuffix;
    private String m_icuGroupName;
    private ProposalTextField m_sourceFolderField;
    private ProposalTextField m_packageField;
    private StyledTextField m_nameField;
    private ProposalTextField m_superTypeField;
    private Group m_icuGroupField;

    protected AbstractCompilationUnitNewWizardPage(String pageName, PackageContainer packageContainer, String readOnlySuffix, ScoutTier sourceFolderTier) {
        super((String)Ensure.notNull((Object)pageName));
        this.m_readOnlySuffix = (String)Ensure.notNull((Object)readOnlySuffix);
        this.m_sourceFolderTier = (ScoutTier)Ensure.notNull((Object)sourceFolderTier);
        if (packageContainer.getPackage() != null) {
            this.setTargetPackageInternal(packageContainer.getPackage().getElementName());
        }
        this.setSourceFolderInternal(packageContainer.getSrcFolder());
    }

    @Override
    protected void createContent(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        this.createIcuGroup(parent);
    }

    protected int getLabelWidth() {
        return 100;
    }

    protected void createIcuGroup(Composite p) {
        String groupName = this.getIcuGroupName();
        if (Strings.isBlank((CharSequence)groupName)) {
            groupName = "New Class Details";
        }
        this.m_icuGroupField = FieldToolkit.createGroupBox(p, groupName);
        int labelWidth = this.getLabelWidth();
        boolean enabled = JdtUtils.exists((IJavaElement)this.getSourceFolder());
        this.m_sourceFolderField = FieldToolkit.createSourceFolderField((Composite)this.m_icuGroupField, "Source Folder", this.m_sourceFolderTier, labelWidth);
        this.m_sourceFolderField.acceptProposal(this.getSourceFolder());
        this.m_sourceFolderField.addProposalListener(proposal -> {
            this.setSourceFolderInternal((IPackageFragmentRoot)proposal);
            this.pingStateChanging();
        });
        this.m_packageField = FieldToolkit.createPackageField((Composite)this.m_icuGroupField, "Package", this.getJavaProject(), labelWidth);
        this.m_packageField.setText(this.getTargetPackage());
        this.m_packageField.addModifyListener(e -> {
            this.setTargetPackageInternal(this.m_packageField.getText());
            this.pingStateChanging();
        });
        this.m_packageField.setEnabled(enabled);
        this.m_nameField = FieldToolkit.createStyledTextField((Composite)this.m_icuGroupField, "Name", 1, labelWidth);
        this.m_nameField.setText(this.getIcuName());
        this.m_nameField.setReadOnlySuffix(this.getReadOnlySuffix());
        this.m_nameField.addModifyListener(e -> {
            this.setIcuNameInternal(this.m_nameField.getText());
            this.pingStateChanging();
        });
        IType superType = this.calcSuperTypeDefault();
        if (JdtUtils.exists((IJavaElement)superType)) {
            this.setSuperTypeInternal(superType);
        }
        this.m_superTypeField = FieldToolkit.createAbstractTypeProposalField((Composite)this.m_icuGroupField, "Super Class", this.getJavaProject(), this.getSuperTypeBaseClass(), labelWidth);
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalListener(proposal -> {
            this.setSuperTypeInternal((IType)proposal);
            this.pingStateChanging();
        });
        this.m_superTypeField.setEnabled(enabled);
        GridLayoutFactory.swtDefaults().applyTo((Composite)this.m_icuGroupField);
        AbstractCompilationUnitNewWizardPage.applyFieldLayoutData((Control)this.m_icuGroupField);
        AbstractCompilationUnitNewWizardPage.applyFieldLayoutData((Control)this.m_sourceFolderField);
        AbstractCompilationUnitNewWizardPage.applyFieldLayoutData((Control)this.m_packageField);
        AbstractCompilationUnitNewWizardPage.applyFieldLayoutData((Control)this.m_nameField);
        AbstractCompilationUnitNewWizardPage.applyFieldLayoutData((Control)this.m_superTypeField);
    }

    protected static void applyFieldLayoutData(Control c) {
        GridDataFactory.defaultsFor((Control)c).align(4, 0x1000000).grab(true, false).applyTo(c);
    }

    protected void handleSuperTypeChanged() {
    }

    protected void handleSourceFolderChanged() {
    }

    protected void handleTargetPackageChanged() {
    }

    protected void handleIcuNameChanged() {
    }

    protected IType calcSuperTypeDefault() {
        IType defaultSuperType = null;
        String prefSuperTypeFqn = this.getDialogSettings().get("superType");
        if (Strings.hasText((CharSequence)prefSuperTypeFqn)) {
            defaultSuperType = this.resolveType(prefSuperTypeFqn);
        }
        if (!JdtUtils.exists(defaultSuperType)) {
            defaultSuperType = this.resolveType(this.getSuperTypeDefault());
        }
        return defaultSuperType;
    }

    protected IType resolveType(String fqn) {
        return AbstractCompilationUnitNewWizardPage.resolveType(this.getJavaProject(), fqn);
    }

    protected static IType resolveType(IJavaProject javaProject, String fqn) {
        if (!JdtUtils.exists((IJavaElement)javaProject)) {
            return null;
        }
        try {
            return javaProject.findType(fqn);
        }
        catch (JavaModelException e) {
            SdkLog.info((CharSequence)"Could not find default super type {} in project {}.", (Object[])new Object[]{fqn, javaProject.getElementName(), e});
            return null;
        }
    }

    @Override
    public boolean performFinish() {
        this.getDialogSettings().put("superType", this.getSuperType().getFullyQualifiedName());
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        if (this.m_sourceFolderField.getSelectedProposal() == null) {
            this.m_sourceFolderField.setFocus();
        } else if (Strings.isBlank((CharSequence)this.m_packageField.getText())) {
            this.m_packageField.setFocus();
        } else {
            this.m_nameField.setFocus();
        }
    }

    protected void handleJavaProjectChanged() {
        IJavaProject javaProject = this.getJavaProject();
        this.m_scoutApi = javaProject == null ? null : ApiHelper.requireScoutApiFor((IJavaElement)javaProject, null);
        this.m_superTypeDefault = this.calcSuperTypeDefaultFqn().map(ITypeNameSupplier::fqn).orElse(null);
        String newSuperTypeDefaultBase = this.calcSuperTypeDefaultBaseFqn().map(ITypeNameSupplier::fqn).orElse(null);
        if (!Objects.equals(this.m_superTypeDefaultBase, newSuperTypeDefaultBase)) {
            this.m_superTypeDefaultBase = newSuperTypeDefaultBase;
            this.setSuperTypeBaseClass(newSuperTypeDefaultBase);
        }
        if (!this.isControlCreated()) {
            return;
        }
        boolean isEnabled = JdtUtils.exists((IJavaElement)javaProject);
        this.m_packageField.setEnabled(isEnabled);
        PackageContentProvider packageContentProvider = (PackageContentProvider)this.m_packageField.getContentProvider();
        packageContentProvider.setJavaProject(javaProject);
        this.m_packageField.setText(null);
        this.m_superTypeField.setEnabled(isEnabled);
        StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.m_superTypeField.getContentProvider();
        superTypeContentProvider.setJavaProject(javaProject);
        this.m_superTypeField.acceptProposal(this.getSuperType(), true, true);
        if (this.m_superTypeField.getSelectedProposal() == null) {
            this.m_superTypeField.acceptProposal(this.calcSuperTypeDefault());
        }
    }

    protected abstract Optional<ITypeNameSupplier> calcSuperTypeDefaultFqn();

    protected abstract Optional<ITypeNameSupplier> calcSuperTypeDefaultBaseFqn();

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusSourceFolder());
        multiStatus.add(this.getStatusPackage());
        multiStatus.add(this.getStatusName());
        multiStatus.add(this.getStatusSuperType());
    }

    protected IStatus getStatusSourceFolder() {
        if (!JdtUtils.exists((IJavaElement)this.getSourceFolder())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a source folder.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusPackage() {
        return AbstractCompilationUnitNewWizardPage.validatePackageName(this.getTargetPackage());
    }

    protected IStatus getStatusName() {
        IStatus javaFieldNameStatus = AbstractCompilationUnitNewWizardPage.validateJavaName(this.getIcuName(), this.getReadOnlySuffix());
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = AbstractCompilationUnitNewWizardPage.validateTypeNotExisting(this.getSourceFolder(), this.getTargetPackage(), this.getIcuName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() {
        if (!JdtUtils.exists((IJavaElement)this.getSuperType())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a super class.");
        }
        return Status.OK_STATUS;
    }

    protected ProposalTextField getSourceFolderField() {
        return this.m_sourceFolderField;
    }

    protected ProposalTextField getPackageField() {
        return this.m_packageField;
    }

    protected StyledTextField getNameField() {
        return this.m_nameField;
    }

    protected ProposalTextField getSuperTypeField() {
        return this.m_superTypeField;
    }

    public static IStatus validateJavaName(CharSequence name, String suffix) {
        if (Strings.isBlank((CharSequence)name) || name.equals(suffix)) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please specify a class name.");
        }
        if (WELL_FORMED_JAVA_FIELD.matcher(name).matches()) {
            return Status.OK_STATUS;
        }
        if (JAVA_FIELD.matcher(name).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.s2e", "Name should start with upper case.");
        }
        return new Status(4, "org.eclipse.scout.sdk.s2e", "Name not valid.");
    }

    private static String getContainingJavaKeyWord(String s) {
        return JavaTypes.getJavaKeyWords().stream().filter(keyWord -> s.startsWith(keyWord + ".") || s.endsWith("." + keyWord) || s.contains("." + keyWord + ".")).findFirst().orElse(null);
    }

    public static IStatus validateTypeNotExisting(IPackageFragmentRoot srcFolder, String pck, String typeName) {
        IPackageFragment packageFragment;
        if (Strings.isBlank((CharSequence)typeName)) {
            return Status.OK_STATUS;
        }
        if (!JdtUtils.exists((IJavaElement)srcFolder)) {
            return Status.OK_STATUS;
        }
        if (pck == null) {
            pck = "";
        }
        if (!JdtUtils.exists((IJavaElement)(packageFragment = srcFolder.getPackageFragment(pck)))) {
            return Status.OK_STATUS;
        }
        IResource folder = packageFragment.getResource();
        if (folder == null || !folder.exists()) {
            return Status.OK_STATUS;
        }
        final boolean[] elementFound = new boolean[1];
        if (folder.exists()) {
            final String typeNameComplete = typeName + ".java";
            try {
                folder.accept(new IResourceProxyVisitor(){
                    boolean m_selfVisited;

                    public boolean visit(IResourceProxy proxy) {
                        if (proxy.getType() == 2) {
                            if (!this.m_selfVisited) {
                                this.m_selfVisited = true;
                                return true;
                            }
                            return false;
                        }
                        if (proxy.getType() == 1 && typeNameComplete.equalsIgnoreCase(proxy.getName())) {
                            elementFound[0] = true;
                        }
                        return false;
                    }
                }, 1, 0);
            }
            catch (CoreException e) {
                SdkLog.warning((CharSequence)"Unable to check if the type '{}' already exists.", (Object[])new Object[]{typeName, e});
            }
        }
        if (elementFound[0]) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Name '" + typeName + "' is already used. Choose another name.");
        }
        return Status.OK_STATUS;
    }

    public static IStatus validatePackageName(String pckName) {
        if (Strings.isBlank((CharSequence)pckName)) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The default package is not allowed.");
        }
        String invalidPackageName = "The package name is not valid.";
        if (pckName.contains("..")) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", invalidPackageName);
        }
        Pattern regexPackageName = Pattern.compile("^[\\da-zA-Z._]*$");
        if (!regexPackageName.matcher(pckName).matches()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", invalidPackageName);
        }
        Pattern regexPackageNameStart = Pattern.compile("[a-zA-Z].*$");
        Pattern regexPackageNameEnd = Pattern.compile("^.*[a-zA-Z]$");
        if (!regexPackageNameStart.matcher(pckName).matches() || !regexPackageNameEnd.matcher(pckName).matches()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", invalidPackageName);
        }
        String jkw = AbstractCompilationUnitNewWizardPage.getContainingJavaKeyWord(pckName);
        if (jkw != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The package may not contain a reserved Java keyword: '" + jkw + "'");
        }
        Pattern regexContainsUpperCase = Pattern.compile(".*[A-Z].*");
        if (regexContainsUpperCase.matcher(pckName).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.s2e", "The package should contain only lower case characters.");
        }
        return Status.OK_STATUS;
    }

    public IJavaProject getJavaProject() {
        return this.getProperty(PROP_JAVA_PROJECT, IJavaProject.class);
    }

    protected void setJavaProjectInternal(IJavaProject javaProject) {
        if (this.setProperty(PROP_JAVA_PROJECT, javaProject)) {
            this.handleJavaProjectChanged();
        }
    }

    public IPackageFragmentRoot getSourceFolder() {
        return this.getProperty(PROP_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setSourceFolder(IPackageFragmentRoot sourceFolder) {
        this.setPropertyWithChangingControl(this.m_sourceFolderField, () -> this.setSourceFolderInternal(sourceFolder), field -> field.acceptProposal(sourceFolder));
    }

    protected boolean setSourceFolderInternal(IPackageFragmentRoot sourceFolder) {
        if (this.setProperty(PROP_SOURCE_FOLDER, sourceFolder)) {
            this.handleSourceFolderChanged();
            if (sourceFolder != null) {
                this.setJavaProjectInternal(sourceFolder.getJavaProject());
            } else {
                this.setJavaProjectInternal(null);
            }
            return true;
        }
        return false;
    }

    public String getTargetPackage() {
        return this.getProperty(PROP_TARGET_PACKAGE, String.class);
    }

    public void setTargetPackage(String targetPackage) {
        this.setPropertyWithChangingControl(this.m_packageField, () -> this.setTargetPackageInternal(targetPackage), field -> field.setText(targetPackage));
    }

    protected boolean setTargetPackageInternal(String targetPackage) {
        if (this.setProperty(PROP_TARGET_PACKAGE, targetPackage)) {
            this.handleTargetPackageChanged();
            return true;
        }
        return false;
    }

    public String getIcuName() {
        return this.getProperty(PROP_ICU_NAME, String.class);
    }

    public void setIcuName(String name) {
        this.setPropertyWithChangingControl(this.m_nameField, () -> this.setIcuNameInternal(name), field -> field.setText(name));
    }

    protected boolean setIcuNameInternal(String name) {
        if (this.setProperty(PROP_ICU_NAME, name)) {
            this.handleIcuNameChanged();
            return true;
        }
        return false;
    }

    public IType getSuperType() {
        return this.getProperty("superType", IType.class);
    }

    public void setSuperType(IType superType) {
        this.setPropertyWithChangingControl(this.m_superTypeField, () -> this.setSuperTypeInternal(superType), field -> field.acceptProposal(superType));
    }

    protected boolean setSuperTypeInternal(IType superType) {
        if (this.setProperty("superType", superType)) {
            this.handleSuperTypeChanged();
            return true;
        }
        return false;
    }

    public String getSuperTypeBaseClass() {
        return this.getProperty(PROP_SUPER_TYPE_BASE, String.class);
    }

    public void setSuperTypeBaseClass(String className) {
        this.setPropertyWithChangingControl(this.m_superTypeField, () -> this.setSuperTypeBaseClassInternal(className), field -> {
            StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.m_superTypeField.getContentProvider();
            superTypeContentProvider.setBaseClassFqn(className);
            this.m_superTypeField.acceptProposal(this.calcSuperTypeDefault());
        });
    }

    protected boolean setSuperTypeBaseClassInternal(String className) {
        return this.setProperty(PROP_SUPER_TYPE_BASE, className);
    }

    public Optional<IScoutApi> scoutApi() {
        return Optional.ofNullable(this.m_scoutApi);
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }

    public void setReadOnlySuffix(String newSuffix) {
        this.m_readOnlySuffix = newSuffix;
        if (this.m_nameField != null) {
            this.m_nameField.setReadOnlySuffix(newSuffix);
        }
    }

    public String getIcuGroupName() {
        return this.m_icuGroupName;
    }

    public void setIcuGroupName(String icuGroupName) {
        this.m_icuGroupName = icuGroupName;
    }

    public String getSuperTypeDefault() {
        return this.m_superTypeDefault;
    }

    public String getSuperTypeDefaultBase() {
        return this.m_superTypeDefaultBase;
    }

    protected Group getIcuGroupComposite() {
        return this.m_icuGroupField;
    }
}

