/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.store.fs.FileBase;

class FileNio
extends FileBase {
    private final String name;
    private final FileChannel channel;

    FileNio(String string, String string2) throws IOException {
        this.name = string;
        this.channel = new RandomAccessFile(string, string2).getChannel();
    }

    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    public long position() throws IOException {
        return this.channel.position();
    }

    public long size() throws IOException {
        return this.channel.size();
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    public FileChannel position(long l) throws IOException {
        this.channel.position(l);
        return this;
    }

    public FileChannel truncate(long l) throws IOException {
        try {
            this.channel.truncate(l);
            if (this.channel.position() > l) {
                this.channel.position(l);
            }
            return this;
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            throw new IOException("read only");
        }
    }

    public void force(boolean bl) throws IOException {
        this.channel.force(bl);
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.channel.write(byteBuffer);
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            throw new IOException("read only");
        }
    }

    public synchronized FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return this.channel.tryLock();
    }

    public String toString() {
        return "nio:" + this.name;
    }
}

