/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.deltaddl;

import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.PrivilegeDeltaDdlGenProvider;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ASEPrivilegeDeltaDdlGenProvider
extends PrivilegeDeltaDdlGenProvider
implements ISybaseASEDdlConstants {
    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        super.getModificationResult(e, feature, oldValue, newValue, quoteIdentifiers, qualifyNames, fullSyntax, script);
        Privilege p = (Privilege)e;
        if (feature.getFeatureID() == 15) {
            Assert.isTrue((boolean)(oldValue instanceof Boolean));
            Assert.isTrue((boolean)(newValue instanceof Boolean));
            if (((Boolean)oldValue).booleanValue() && !p.isGrantable()) {
                SybaseASEDdlBuilder builder = (SybaseASEDdlBuilder)SybaseASEDdlBuilder.getInstance();
                String[] statement = builder.grantPrivilege(p, quoteIdentifiers, qualifyNames, fullSyntax);
                int i = 0;
                while (i < statement.length) {
                    script.addGrantPrivilegeStatement(statement[i]);
                    ++i;
                }
            }
        }
    }

    protected String[] generateGrantGOStatement(Privilege p, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseDdlBuilder ddlBuilder = SybaseASEDdlBuilder.getInstance();
        return ddlBuilder.grantPrivilege(p, quoteIdentifiers, qualifyNames, fullSyntax);
    }

    protected String generateRevokeGOStatement(Privilege p, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer("");
        sb.append("REVOKE").append(" ").append("GRANT OPTION FOR");
        SybaseDdlBuilder ddlBuilder = SybaseASEDdlBuilder.getInstance();
        String revokeStat = ddlBuilder.revokePrivilege(p, quoteIdentifiers, qualifyNames);
        revokeStat = revokeStat.substring("REVOKE".length());
        sb.append(revokeStat);
        return sb.toString();
    }
}

