/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.datatypes.ApproximateNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.ArrayDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.BooleanDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataLinkDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.ElementType;
import org.eclipse.datatools.modelbase.sql.datatypes.FixedPrecisionDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntegerDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalQualifierType;
import org.eclipse.datatools.modelbase.sql.datatypes.MultisetDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.query.CallStatement;
import org.eclipse.datatools.modelbase.sql.query.ColumnName;
import org.eclipse.datatools.modelbase.sql.query.Grouping;
import org.eclipse.datatools.modelbase.sql.query.GroupingExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSets;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElement;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementSublist;
import org.eclipse.datatools.modelbase.sql.query.GroupingSpecification;
import org.eclipse.datatools.modelbase.sql.query.MergeInsertSpecification;
import org.eclipse.datatools.modelbase.sql.query.MergeOnCondition;
import org.eclipse.datatools.modelbase.sql.query.MergeOperationSpecification;
import org.eclipse.datatools.modelbase.sql.query.MergeSourceTable;
import org.eclipse.datatools.modelbase.sql.query.MergeTargetTable;
import org.eclipse.datatools.modelbase.sql.query.MergeUpdateSpecification;
import org.eclipse.datatools.modelbase.sql.query.NullOrderingType;
import org.eclipse.datatools.modelbase.sql.query.OrderByOrdinal;
import org.eclipse.datatools.modelbase.sql.query.OrderBySpecification;
import org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression;
import org.eclipse.datatools.modelbase.sql.query.OrderingSpecType;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateBetween;
import org.eclipse.datatools.modelbase.sql.query.PredicateComparisonOperator;
import org.eclipse.datatools.modelbase.sql.query.PredicateExists;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueList;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateInValueSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateIsNull;
import org.eclipse.datatools.modelbase.sql.query.PredicateLike;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedRowSelect;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedType;
import org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedValueSelect;
import org.eclipse.datatools.modelbase.sql.query.ProcedureReference;
import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryMergeStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryNested;
import org.eclipse.datatools.modelbase.sql.query.QueryResultSpecification;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.ResultColumn;
import org.eclipse.datatools.modelbase.sql.query.ResultTableAllColumns;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.SuperGroup;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElement;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElementExpression;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElementSublist;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupType;
import org.eclipse.datatools.modelbase.sql.query.TableCorrelation;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableFunction;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.TableJoinedOperator;
import org.eclipse.datatools.modelbase.sql.query.TableNested;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.UpdatabilityExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdatabilityType;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateOfColumn;
import org.eclipse.datatools.modelbase.sql.query.UpdateSource;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList;
import org.eclipse.datatools.modelbase.sql.query.UpdateSourceQuery;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseElse;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDuration;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDurationType;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionRow;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionUnaryOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.DataTypeHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.impl.SQLQueryModelPackageImpl;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQueryArrayDataTypeImpl;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQueryMultisetDataTypeImpl;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaFactory;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLSchemaPackageImpl;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesFactory;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.TemporaryTable;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserFactory;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserLogger;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserFactoryDataTypes;
import org.eclipse.emf.common.util.EList;

public class SQLQueryParserFactory
implements SQLParserFactory,
SQLQueryParserFactoryDataTypes {
    static final char DEFAULT_DELIMITED_IDENTIFIER_QUOTE = '\"';
    protected static SQLSchemaFactory rdbFactory = null;
    protected static SQLQueryModelFactory sqlQueryModelFactory = null;
    protected static SQLTablesFactory tableFactory = null;
    protected SQLQuerySourceFormat sourceFormat = null;
    public static final int COMPARISON_OPERATOR_EQ = 0;
    public static final int COMPARISON_OPERATOR_NE = 1;
    public static final int COMPARISON_OPERATOR_LT = 2;
    public static final int COMPARISON_OPERATOR_GT = 3;
    public static final int COMPARISON_OPERATOR_LE = 4;
    public static final int COMPARISON_OPERATOR_GE = 5;
    public static final int COMBINED_OPERATOR_AND = 0;
    public static final int COMBINED_OPERATOR_OR = 1;
    public static final int UNARY_OPERATOR_PLUS = 1;
    public static final int UNARY_OPERATOR_MINUS = 2;
    public static final int COMBINED_OPERATOR_ADD = 0;
    public static final int COMBINED_OPERATOR_SUBTRACT = 1;
    public static final int COMBINED_OPERATOR_MULTIPLY = 2;
    public static final int COMBINED_OPERATOR_DIVIDE = 3;
    public static final int COMBINED_OPERATOR_CONCATENATE = 4;
    public static final int DURATION_TYPE_DAYS = 2;
    public static final int DURATION_TYPE_HOURS = 3;
    public static final int DURATION_TYPE_MICROSECONDS = 6;
    public static final int DURATION_TYPE_MINUTES = 4;
    public static final int DURATION_TYPE_MONTHS = 1;
    public static final int DURATION_TYPE_SECONDS = 5;
    public static final int DURATION_TYPE_YEARS = 0;
    public static final int NULL_ORDERING_TYPE_NONE = 0;
    public static final int NULL_ORDERING_TYPE_NULLS_FIRST = 1;
    public static final int NULL_ORDERING_TYPE_NULLS_LAST = 2;
    public static final int ORDERING_SPEC_TYPE_NONE = 0;
    public static final int ORDERING_SPEC_TYPE_ASC = 1;
    public static final int ORDERING_SPEC_TYPE_DESC = 2;
    public static final int SUPERGROUP_TYPE_CUBE = 0;
    public static final int SUPERGROUP_TYPE_ROLLUP = 2;
    public static final int SUPERGROUP_TYPE_GRANDTOTAL = 1;
    public static final int QUANTIFIER_ALL = 2;
    public static final int QUANTIFIER_ANY = 1;
    public static final int QUANTIFIER_SOME = 0;
    public static final int JOIN_DEFAULT_INNER = 0;
    public static final int JOIN_EXPLICIT_INNER = 1;
    public static final int JOIN_LEFT_OUTER = 2;
    public static final int JOIN_RIGHT_OUTER = 3;
    public static final int JOIN_FULL_OUTER = 4;
    public static final int QUERY_COMBINED_UNION = 0;
    public static final int QUERY_COMBINED_UNION_ALL = 1;
    public static final int QUERY_COMBINED_INTERSECT = 2;
    public static final int QUERY_COMBINED_INTERSECT_ALL = 3;
    public static final int QUERY_COMBINED_EXCEPT = 4;
    public static final int QUERY_COMBINED_EXCEPT_ALL = 5;
    public static final int UPDATABILITY_TYPE_FOR_READ_ONLY = 0;
    public static final int UPDATABILITY_TYPE_FOR_UPDATE = 1;
    public static final String SPECIAL_REGISTER_CURRENT_DATE = "CURRENT_DATE";
    public static final String SPECIAL_REGISTER_CURRENT_TIME = "CURRENT_TIME";
    public static final String SPECIAL_REGISTER_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    public static final String SPECIAL_REGISTER_LOCALTIME = "LOCALTIME";
    public static final String SPECIAL_REGISTER_LOCALTIMESTAMP = "LOCALTIMESTAMP";
    public static final String SPECIAL_REGISTER_CURRENT_DEFAULT_TRANSFORM_GROUP = "CURRENT_DEFAULT_TRANSFORM_GROUP";
    public static final String SPECIAL_REGISTER_CURRENT_TRANSFORM_GROUP_FOR_TYPE = "CURRENT_TRANSFORM_GROUP_FOR_TYPE";
    public static final String SPECIAL_REGISTER_CURRENT_PATH = "CURRENT_PATH";
    public static final String SPECIAL_REGISTER_CURRENT_ROLE = "CURRENT_ROLE";
    public static final String SPECIAL_REGISTER_CURRENT_USER = "CURRENT_USER";
    public static final String SPECIAL_REGISTER_SESSION_USER = "SESSION_USER";
    public static final String SPECIAL_REGISTER_SYSTEM_USER = "SYSTEM_USER";
    public static final String SPECIAL_REGISTER_USER = "USER";
    public static final String SPECIAL_REGISTER_VALUE = "VALUE";
    public static final String ORDER_ASC = "ASC";
    public static final String ORDER_DESC = "DESC";
    public static final String ALL = "ALL";
    public static final String DISTINCT = "DISTINCT";

    protected char getDelimitedIdentifierQuote() {
        if (this.sourceFormat != null) {
            return this.sourceFormat.getDelimitedIdentifierQuote();
        }
        return '\"';
    }

    protected void logWarning(String message) {
        SQLParserLogger.getLogger().writeInfo("WARNING: " + this.getClass() + "#" + message);
    }

    public SQLQueryParserFactory() {
        if (SQLSchemaFactory.eINSTANCE == null) {
            SQLSchemaPackageImpl.init();
        }
        rdbFactory = SQLSchemaFactory.eINSTANCE;
        if (SQLQueryModelFactory.eINSTANCE == null) {
            SQLQueryModelPackageImpl.init();
        }
        sqlQueryModelFactory = SQLQueryModelFactory.eINSTANCE;
        tableFactory = SQLTablesFactory.eINSTANCE;
    }

    public SQLQueryParserFactory(SQLQuerySourceFormat aSourceFormat) {
        this();
        this.sourceFormat = aSourceFormat;
    }

    public SQLQuerySourceFormat getSQLSourceFormat() {
        if (this.sourceFormat == SQLQuerySourceFormat.SQL_SOURCE_FORMAT_DEFAULT || this.sourceFormat == null) {
            this.sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        }
        return this.sourceFormat;
    }

    public void setSQLSourceFormat(SQLQuerySourceFormat sourceFormat) {
        if (sourceFormat == SQLQuerySourceFormat.SQL_SOURCE_FORMAT_DEFAULT || sourceFormat == null) {
            sourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
        }
        this.sourceFormat = sourceFormat;
    }

    public List listConcat(List p_list, Object p_rhs) {
        List list;
        List list2 = list = p_list != null ? p_list : new Vector();
        if (p_rhs == null) {
            throw new IllegalStateException("RHS is null elist=" + p_list);
        }
        list.add(p_rhs);
        return list;
    }

    public List listConcat(Object p_lhs, List p_list) {
        List list;
        List list2 = list = p_list != null ? p_list : new Vector();
        if (p_lhs == null) {
            throw new IllegalStateException("LHS is null elist=" + p_list);
        }
        list.add(0, p_lhs);
        return list;
    }

    public TableExpression addTableCorrelationToTableExpression(TableExpression tableExpr, TableCorrelation tableCorrelation) {
        tableExpr.setTableCorrelation(tableCorrelation);
        return tableExpr;
    }

    protected int convertIntoBytesFromBytesInUnit(int bytesInUnit, String unit, int primitiveType) {
        int kilo = 1024;
        int mega = 0x100000;
        int giga = 0x40000000;
        int maxInt = Integer.MAX_VALUE;
        int maxKilo = 0x200000;
        int maxMega = 2048;
        int maxGiga = 2;
        int sizeInByte = bytesInUnit;
        boolean sizeExceeds_MAX_INT = false;
        if ("K".equalsIgnoreCase(unit)) {
            if (bytesInUnit == maxKilo) {
                sizeInByte = maxInt;
            } else if (bytesInUnit < maxKilo) {
                sizeInByte *= kilo;
            } else {
                sizeExceeds_MAX_INT = true;
            }
        } else if ("M".equalsIgnoreCase(unit)) {
            if (bytesInUnit == maxMega) {
                sizeInByte = maxInt;
            } else if (bytesInUnit < maxMega) {
                sizeInByte *= mega;
            } else {
                sizeExceeds_MAX_INT = true;
            }
        } else if ("G".equalsIgnoreCase(unit)) {
            if (bytesInUnit == maxGiga) {
                sizeInByte = maxInt;
            } else if (bytesInUnit < maxGiga) {
                sizeInByte *= giga;
            } else {
                sizeExceeds_MAX_INT = true;
            }
        }
        if (sizeExceeds_MAX_INT) {
            throw new NumberFormatException("Size " + bytesInUnit + " in " + unit + "byte for " + PrimitiveType.get((int)primitiveType) + " exceeds " + Integer.MAX_VALUE + " byte.");
        }
        return sizeInByte;
    }

    public ValueExpressionCaseElse createCaseElse(QueryValueExpression expr) {
        ValueExpressionCaseElse caseElse = sqlQueryModelFactory.createValueExpressionCaseElse();
        caseElse.setValueExpr(expr);
        return caseElse;
    }

    public ValueExpressionCaseSearchContent createCaseSearchContent(QuerySearchCondition aWhenCond, QueryValueExpression aExpr) {
        ValueExpressionCaseSearchContent caseSearchContent = sqlQueryModelFactory.createValueExpressionCaseSearchContent();
        caseSearchContent.setSearchCondition(aWhenCond);
        caseSearchContent.setValueExpr(aExpr);
        return caseSearchContent;
    }

    public ValueExpressionCaseSearch createCaseSearchExpression(List aCaseSearchWhenList, ValueExpressionCaseElse aCaseElse) {
        ValueExpressionCaseSearch caseSearch = sqlQueryModelFactory.createValueExpressionCaseSearch();
        EList caseSearchWhenList = caseSearch.getSearchContentList();
        caseSearchWhenList.addAll((Collection)aCaseSearchWhenList);
        if (aCaseElse != null) {
            caseSearch.setCaseElse(aCaseElse);
        }
        return caseSearch;
    }

    public List createCaseSearchList(List aCaseSearchList, ValueExpressionCaseSearchContent aCaseSearchContent) {
        if (aCaseSearchList == null) {
            aCaseSearchList = new Vector<ValueExpressionCaseSearchContent>();
        }
        aCaseSearchList.add(aCaseSearchContent);
        return aCaseSearchList;
    }

    public ValueExpressionCaseSimpleContent createCaseSimpleContent(QueryValueExpression aWhenExpr, QueryValueExpression aResultExpr) {
        ValueExpressionCaseSimpleContent caseSimpleContent = sqlQueryModelFactory.createValueExpressionCaseSimpleContent();
        caseSimpleContent.setWhenValueExpr(aWhenExpr);
        caseSimpleContent.setResultValueExpr(aResultExpr);
        return caseSimpleContent;
    }

    public ValueExpressionCaseSimple createCaseSimpleExpression(QueryValueExpression aCaseValue, List aCaseSimpleWhenList, ValueExpressionCaseElse aCaseElse) {
        ValueExpressionCaseSimple caseSimple = sqlQueryModelFactory.createValueExpressionCaseSimple();
        caseSimple.setValueExpr(aCaseValue);
        EList caseSimpleWhenList = caseSimple.getContentList();
        caseSimpleWhenList.addAll((Collection)aCaseSimpleWhenList);
        if (aCaseElse != null) {
            caseSimple.setCaseElse(aCaseElse);
        }
        return caseSimple;
    }

    public List createCaseSimpleList(List aCaseSimpleList, ValueExpressionCaseSimpleContent aCaseSimpleContent) {
        if (aCaseSimpleList == null) {
            aCaseSimpleList = new Vector<ValueExpressionCaseSimpleContent>();
        }
        aCaseSimpleList.add(aCaseSimpleContent);
        return aCaseSimpleList;
    }

    public ValueExpressionCast createCastExpression(QueryValueExpression aExpr, String aCastType) {
        ValueExpressionCast castExpr = sqlQueryModelFactory.createValueExpressionCast();
        castExpr.setValueExpr(aExpr);
        PredefinedDataType dataType = this.createPredefinedDataType(aCastType);
        if (dataType == null) {
            dataType = this.createDataType(aCastType);
        }
        castExpr.setDataType((DataType)dataType);
        return castExpr;
    }

    public ValueExpressionCast createCastExpression(QueryValueExpression aExpr, DataType aCastType) {
        ValueExpressionCast castExpr = sqlQueryModelFactory.createValueExpressionCast();
        castExpr.setValueExpr(aExpr);
        castExpr.setDataType(aCastType);
        return castExpr;
    }

    public ValueExpressionColumn createColumnExpression(String aColumnName, String aTableName, String aSchemaName) {
        if (aSchemaName == null) {
            return this.createColumnExpression(aColumnName, aTableName);
        }
        ValueExpressionColumn colExpr = sqlQueryModelFactory.createValueExpressionColumn();
        colExpr.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aColumnName, (char)this.getDelimitedIdentifierQuote()));
        if (aTableName != null) {
            TableInDatabase tableExpr = this.createSimpleTable(aSchemaName, aTableName);
            colExpr.setTableExpr((TableExpression)tableExpr);
        }
        return colExpr;
    }

    public ValueExpressionColumn createColumnExpression(String aColumnName, String aQualifier) {
        ValueExpressionColumn colExpr = this.createColumnExpression(aColumnName);
        if (aQualifier != null) {
            TableInDatabase tableRef = sqlQueryModelFactory.createTableInDatabase();
            tableRef.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aQualifier, (char)this.getDelimitedIdentifierQuote()));
            colExpr.setTableExpr((TableExpression)tableRef);
        }
        return colExpr;
    }

    public ValueExpressionColumn createColumnExpression(String aColumnName) {
        ValueExpressionColumn colExpr = sqlQueryModelFactory.createValueExpressionColumn();
        colExpr.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aColumnName, (char)this.getDelimitedIdentifierQuote()));
        return colExpr;
    }

    public List createColumnList(List aColumnNameList, ValueExpressionColumn aColumnExpr) {
        if (aColumnNameList == null) {
            aColumnNameList = new Vector<ValueExpressionColumn>();
        }
        aColumnNameList.add(aColumnExpr);
        return aColumnNameList;
    }

    public List createColumnNameList(List aColumnNameList, ColumnName aColumnName) {
        if (aColumnName != null) {
            if (aColumnNameList == null) {
                aColumnNameList = new Vector<ColumnName>();
            }
            aColumnNameList.add(aColumnName);
        } else {
            this.logWarning("#createColumnNameList: expected ColumnName to be not null.");
        }
        return aColumnNameList;
    }

    public ColumnName createColumnName(String aColumnName) {
        ColumnName colName = sqlQueryModelFactory.createColumnName();
        colName.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aColumnName, (char)this.getDelimitedIdentifierQuote()));
        return colName;
    }

    public SearchConditionCombined createCombinedCondition(QuerySearchCondition aLeftCond, QuerySearchCondition aRightCond, int aCondOper) {
        SearchConditionCombined condCombined = sqlQueryModelFactory.createSearchConditionCombined();
        condCombined.setLeftCondition(aLeftCond);
        if (aRightCond != null) {
            condCombined.setRightCondition(aRightCond);
        }
        condCombined.setCombinedOperator(SearchConditionCombinedOperator.get((int)aCondOper));
        return condCombined;
    }

    public ValueExpressionCombined createCombinedExpression(QueryValueExpression aLeftExpr, int aExprOper, QueryValueExpression aRightExpr) {
        ValueExpressionCombined exprCombined = sqlQueryModelFactory.createValueExpressionCombined();
        exprCombined.setLeftValueExpr(aLeftExpr);
        exprCombined.setCombinedOperator(ValueExpressionCombinedOperator.get((int)aExprOper));
        exprCombined.setRightValueExpr(aRightExpr);
        return exprCombined;
    }

    public DataType createDataType(String aTypeName) {
        PredefinedDataType dataType = this.createPredefinedDataType(aTypeName);
        if (dataType == null) {
            dataType = this.createDataTypeDistinctUserDefinedType(aTypeName);
        }
        return dataType;
    }

    @Override
    public ArrayDataType createDataTypeArray(DataType dataType) {
        return this.createDataTypeArray(dataType, 0, null);
    }

    @Override
    public ArrayDataType createDataTypeArray(DataType dataType, int maxCardinality) {
        return this.createDataTypeArray(dataType, maxCardinality, null);
    }

    public ArrayDataType createDataTypeArray(DataType dataType, int maxCardinality, String typeName) {
        SQLQueryArrayDataTypeImpl arrayDataType = new SQLQueryArrayDataTypeImpl();
        ElementType elementType = SQLDataTypesFactory.eINSTANCE.createElementType();
        elementType.setDataType(dataType);
        arrayDataType.setElementType(elementType);
        if (maxCardinality != 0) {
            arrayDataType.setMaxCardinality(maxCardinality);
        }
        arrayDataType.setName("ARRAY");
        return arrayDataType;
    }

    @Override
    public BinaryStringDataType createDataTypeBinaryString(int primitiveType, int length, String optionalUnitsIndicator) {
        return this.createDataTypeBinaryString(primitiveType, length, optionalUnitsIndicator, null);
    }

    public BinaryStringDataType createDataTypeBinaryString(int primitiveType, int length, String optionalUnitsIndicator, String typeName) {
        BinaryStringDataType dataType = SQLDataTypesFactory.eINSTANCE.createBinaryStringDataType();
        dataType.setPrimitiveType(PrimitiveType.get((int)primitiveType));
        dataType.setName(typeName);
        dataType.setLength(this.convertIntoBytesFromBytesInUnit(length, optionalUnitsIndicator, primitiveType));
        return dataType;
    }

    @Override
    public BooleanDataType createDataTypeBoolean() {
        return this.createDataTypeBoolean(null);
    }

    public BooleanDataType createDataTypeBoolean(String typeName) {
        BooleanDataType dataType = SQLDataTypesFactory.eINSTANCE.createBooleanDataType();
        dataType.setPrimitiveType(PrimitiveType.BOOLEAN_LITERAL);
        dataType.setName(typeName);
        return dataType;
    }

    @Override
    public CharacterStringDataType createDataTypeCharacterString(int primitiveType, int length, String optionalUnitsIndicator) {
        return this.createDataTypeCharacterString(primitiveType, length, optionalUnitsIndicator, null);
    }

    public CharacterStringDataType createDataTypeCharacterString(int primitiveType, int length, String optionalUnitsIndicator, String typeName) {
        CharacterStringDataType dataType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
        dataType.setPrimitiveType(PrimitiveType.get((int)primitiveType));
        dataType.setName(typeName);
        int convertedLength = this.convertIntoBytesFromBytesInUnit(length, optionalUnitsIndicator, primitiveType);
        dataType.setLength(convertedLength);
        return dataType;
    }

    @Override
    public DataLinkDataType createDataTypeDataLink(int length) {
        return this.createDataTypeDataLink(length, null);
    }

    public DataLinkDataType createDataTypeDataLink(int length, String typeName) {
        DataLinkDataType dataType = SQLDataTypesFactory.eINSTANCE.createDataLinkDataType();
        dataType.setLength(length);
        dataType.setPrimitiveType(PrimitiveType.DATALINK_LITERAL);
        dataType.setName(typeName);
        return dataType;
    }

    @Override
    public DateDataType createDataTypeDate() {
        return this.createDataTypeDate(null);
    }

    public DateDataType createDataTypeDate(String typeName) {
        DateDataType dataType = SQLDataTypesFactory.eINSTANCE.createDateDataType();
        dataType.setPrimitiveType(PrimitiveType.DATE_LITERAL);
        dataType.setName(typeName);
        return dataType;
    }

    public DistinctUserDefinedType createDataTypeDistinctUserDefinedType(String aTypeName) {
        DistinctUserDefinedType dataType = SQLDataTypesFactory.eINSTANCE.createDistinctUserDefinedType();
        dataType.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aTypeName, (char)this.getDelimitedIdentifierQuote()));
        return dataType;
    }

    @Override
    public IntervalDataType createDataTypeInterval(IntervalQualifierType leadingQualifier, IntervalQualifierType trailingQualifier, int leadingFieldPrecision, int trailingFieldPrecision, int fractionalSecondsPrecision) {
        return this.createDataTypeInterval(leadingQualifier, trailingQualifier, leadingFieldPrecision, trailingFieldPrecision, fractionalSecondsPrecision, null);
    }

    public IntervalDataType createDataTypeInterval(IntervalQualifierType leadingQualifier, IntervalQualifierType trailingQualifier, int leadingFieldPrecision, int trailingFieldPrecision, int fractionalSecondsPrecision, String typeName) {
        IntervalDataType dataType = SQLDataTypesFactory.eINSTANCE.createIntervalDataType();
        dataType.setPrimitiveType(PrimitiveType.INTERVAL_LITERAL);
        dataType.setLeadingQualifier(leadingQualifier);
        dataType.setTrailingQualifier(trailingQualifier);
        dataType.setLeadingFieldPrecision(leadingFieldPrecision);
        dataType.setTrailingFieldPrecision(trailingFieldPrecision);
        dataType.setFractionalSecondsPrecision(fractionalSecondsPrecision);
        dataType.setName(typeName);
        return dataType;
    }

    @Override
    public MultisetDataType createDataTypeMultiset(DataType dataType) {
        return this.createDataTypeMultiset(dataType, "MULTISET");
    }

    public MultisetDataType createDataTypeMultiset(DataType dataType, String typeName) {
        SQLQueryMultisetDataTypeImpl multisetDataType = new SQLQueryMultisetDataTypeImpl();
        ElementType elementType = SQLDataTypesFactory.eINSTANCE.createElementType();
        elementType.setDataType(dataType);
        multisetDataType.setElementType(elementType);
        multisetDataType.setName(typeName);
        return multisetDataType;
    }

    @Override
    public ApproximateNumericDataType createDataTypeNumericApproximate(int primitiveType, int precision) {
        return this.createDataTypeNumericApproximate(primitiveType, precision, null);
    }

    public ApproximateNumericDataType createDataTypeNumericApproximate(int primitiveType, int precision, String typeName) {
        ApproximateNumericDataType dataType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
        dataType.setPrecision(precision);
        dataType.setPrimitiveType(PrimitiveType.get((int)primitiveType));
        dataType.setName(typeName);
        return dataType;
    }

    @Override
    public FixedPrecisionDataType createDataTypeNumericFixedPrecision(int primitiveType, int precision, int scale) {
        return this.createDataTypeNumericFixedPrecision(primitiveType, precision, scale, null);
    }

    public FixedPrecisionDataType createDataTypeNumericFixedPrecision(int primitiveType, int precision, int scale, String typeName) {
        FixedPrecisionDataType dataType = SQLDataTypesFactory.eINSTANCE.createFixedPrecisionDataType();
        dataType.setPrecision(precision);
        dataType.setScale(scale);
        dataType.setPrimitiveType(PrimitiveType.get((int)primitiveType));
        dataType.setName(typeName);
        return dataType;
    }

    @Override
    public IntegerDataType createDataTypeNumericInteger(int primitiveType, int precision) {
        return this.createDataTypeNumericInteger(primitiveType, precision, null);
    }

    public IntegerDataType createDataTypeNumericInteger(int primitiveType, int precision, String typeName) {
        IntegerDataType dataType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
        if (precision == 0) {
            if (primitiveType == 11) {
                precision = 5;
            } else if (primitiveType == 12) {
                precision = 10;
            } else if (primitiveType == 13) {
                precision = 19;
            }
        }
        dataType.setPrecision(precision);
        dataType.setScale(0);
        dataType.setPrimitiveType(PrimitiveType.get((int)primitiveType));
        dataType.setName(typeName);
        return dataType;
    }

    public PredefinedDataType createDataTypePredefinedDataType(String typeName) {
        return DataTypeHelper.getPredefinedDataTypeForNamedType((String)typeName);
    }

    @Override
    public TimeDataType createDataTypeTime(int primitiveType, int precision) {
        return this.createDataTypeTime(primitiveType, precision, null);
    }

    public TimeDataType createDataTypeTime(int primitiveType, int precision, String typeName) {
        TimeDataType dataType = SQLDataTypesFactory.eINSTANCE.createTimeDataType();
        dataType.setPrimitiveType(PrimitiveType.get((int)primitiveType));
        dataType.setFractionalSecondsPrecision(precision);
        dataType.setName(typeName);
        return dataType;
    }

    public UserDefinedType createDataTypeUserDefinedType(String aSchemaName, String aTypeName) {
        DistinctUserDefinedType dataType = SQLDataTypesFactory.eINSTANCE.createDistinctUserDefinedType();
        String catalogTypeName = StatementHelper.convertSQLIdentifierToCatalogFormat((String)aTypeName, (char)this.getDelimitedIdentifierQuote());
        dataType.setName(catalogTypeName);
        if (aSchemaName != null) {
            Schema rdbSchema = rdbFactory.createSchema();
            String catalogSchemaName = StatementHelper.convertSQLIdentifierToCatalogFormat((String)aSchemaName, (char)this.getDelimitedIdentifierQuote());
            rdbSchema.setName(catalogSchemaName);
            dataType.setSchema(rdbSchema);
        }
        return dataType;
    }

    public ValueExpressionDefaultValue createDefaultExpression() {
        ValueExpressionDefaultValue defaultExpr = sqlQueryModelFactory.createValueExpressionDefaultValue();
        return defaultExpr;
    }

    public QueryDeleteStatement createDeleteStatement_deprecated(TableInDatabase aTargetTable, String aAsTable, QuerySearchCondition aWhereClause) {
        return this.createDeleteStatement(aTargetTable, this.createTableCorrelation(aAsTable), aWhereClause);
    }

    public QueryDeleteStatement createDeleteStatement(TableInDatabase aTargetTable, TableCorrelation aAsTable, QuerySearchCondition aWhereClause) {
        QueryDeleteStatement sqlDelete = sqlQueryModelFactory.createQueryDeleteStatement();
        if (aAsTable != null) {
            aTargetTable.setTableCorrelation(aAsTable);
        }
        sqlDelete.setTargetTable(aTargetTable);
        if (aWhereClause != null) {
            sqlDelete.setWhereClause(aWhereClause);
        }
        return sqlDelete;
    }

    public DistinctUserDefinedType createDistinctUserDefinedType(String aTypeName) {
        return this.createDataTypeDistinctUserDefinedType(aTypeName);
    }

    public List createExpressionList(List aExprList, QueryValueExpression aValExpr) {
        if (aExprList == null) {
            aExprList = new Vector<QueryValueExpression>();
        }
        aExprList.add(aValExpr);
        return aExprList;
    }

    public List createFromClause(List aTableRefList, TableReference aTableRef) {
        if (aTableRefList == null) {
            aTableRefList = new Vector<TableReference>();
        }
        aTableRefList.add(aTableRef);
        return aTableRefList;
    }

    public ValueExpressionFunction createFunctionExpression(String aFuncName, String distinct, List aFuncParmList, String aSchemaName) {
        ValueExpressionFunction func = sqlQueryModelFactory.createValueExpressionFunction();
        Function function = SQLRoutinesFactory.eINSTANCE.createFunction();
        func.setFunction(function);
        func.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aFuncName, (char)this.getDelimitedIdentifierQuote()));
        if (aSchemaName != null) {
            Schema schema = this.createSchema(aSchemaName);
            function.setSchema(schema);
        }
        if (aFuncParmList != null) {
            EList funcParmList = func.getParameterList();
            funcParmList.addAll((Collection)aFuncParmList);
        }
        func.setSpecialRegister(false);
        if (DISTINCT.equals(distinct)) {
            func.setDistinct(true);
        }
        func.setColumnFunction(SQLQueryParserFactory.isColumnFunction(aFuncName));
        return func;
    }

    public GroupingExpression createGroupingExpression(QueryValueExpression aExpr) {
        GroupingExpression groupingExpr = sqlQueryModelFactory.createGroupingExpression();
        groupingExpr.setValueExpr(aExpr);
        return groupingExpr;
    }

    public GroupingSets createGroupingSets(List aGroupingSetsElementList) {
        GroupingSets superGroup = sqlQueryModelFactory.createGroupingSets();
        if (aGroupingSetsElementList != null) {
            superGroup.getGroupingSetsElementList().addAll((Collection)aGroupingSetsElementList);
        }
        return superGroup;
    }

    public List createGroupingSetsElementList(List aGroupingSetsElementList, GroupingSetsElement aGroupingSetsElement) {
        if (aGroupingSetsElementList == null) {
            aGroupingSetsElementList = new Vector<GroupingSetsElement>();
        }
        aGroupingSetsElementList.add(aGroupingSetsElement);
        return aGroupingSetsElementList;
    }

    public GroupingSetsElementExpression createGroupingSetsElementExpression(Grouping aGrouping) {
        GroupingSetsElementExpression superGroupsElementExpr = sqlQueryModelFactory.createGroupingSetsElementExpression();
        superGroupsElementExpr.setGrouping(aGrouping);
        return superGroupsElementExpr;
    }

    public List createGroupingSetsElementExprList(List aGroupingSetsElementExprList, GroupingSetsElementExpression aGroupingSetsElementExpr) {
        if (aGroupingSetsElementExprList == null) {
            aGroupingSetsElementExprList = new Vector<GroupingSetsElementExpression>();
        }
        aGroupingSetsElementExprList.add(aGroupingSetsElementExpr);
        return aGroupingSetsElementExprList;
    }

    public GroupingSetsElementSublist createGroupingSetsElementSublist(List aGroupingSetsElementExprList) {
        GroupingSetsElementSublist superGroupSublist = sqlQueryModelFactory.createGroupingSetsElementSublist();
        if (aGroupingSetsElementExprList != null) {
            superGroupSublist.getGroupingSetsElementExprList().addAll((Collection)aGroupingSetsElementExprList);
        }
        return superGroupSublist;
    }

    public List createGroupingSpecificationList(List aGroupingSpecList, GroupingSpecification aGroupingSpec) {
        if (aGroupingSpecList == null) {
            aGroupingSpecList = new Vector<GroupingSpecification>();
        }
        aGroupingSpecList.add(aGroupingSpec);
        return aGroupingSpecList;
    }

    public List createInsertRow(List aInsertExprList, ValuesRow aInsertExpr) {
        if (aInsertExprList == null) {
            aInsertExprList = new Vector<ValuesRow>();
        }
        aInsertExprList.add(aInsertExpr);
        return aInsertExprList;
    }

    public QueryInsertStatement createInsertStatement(TableInDatabase aTargetTable, List aTargetColumnList, List aSrcValuesRowList) {
        QueryInsertStatement sqlInsert = sqlQueryModelFactory.createQueryInsertStatement();
        sqlInsert.setTargetTable(aTargetTable);
        if (aTargetColumnList != null) {
            EList colList = sqlInsert.getTargetColumnList();
            colList.addAll((Collection)aTargetColumnList);
            aTargetTable.getValueExprColumns().addAll((Collection)aTargetColumnList);
        }
        if (aSrcValuesRowList != null) {
            EList valuesList = sqlInsert.getSourceValuesRowList();
            valuesList.addAll((Collection)aSrcValuesRowList);
        }
        return sqlInsert;
    }

    public QueryInsertStatement createInsertStatement(TableInDatabase aTargetTable, List aColumnList, QueryExpressionRoot aSrcQuery) {
        if (aSrcQuery != null && aSrcQuery.getQuery() != null && aSrcQuery.getQuery() instanceof QueryValues) {
            QueryValues queryValues = (QueryValues)aSrcQuery.getQuery();
            EList valuesRowList = queryValues.getValuesRowList();
            return this.createInsertStatement(aTargetTable, aColumnList, (List)valuesRowList);
        }
        QueryInsertStatement sqlInsert = sqlQueryModelFactory.createQueryInsertStatement();
        sqlInsert.setTargetTable(aTargetTable);
        if (aColumnList != null) {
            EList colList = sqlInsert.getTargetColumnList();
            colList.addAll((Collection)aColumnList);
        }
        sqlInsert.setSourceQuery(aSrcQuery);
        return sqlInsert;
    }

    public ValuesRow createInsertValuesRow(List aExprList) {
        ValuesRow valuesRow = sqlQueryModelFactory.createValuesRow();
        EList exprList = valuesRow.getExprList();
        if (aExprList != null) {
            exprList.addAll((Collection)aExprList);
        }
        return valuesRow;
    }

    public ValuesRow createInsertValuesRow(QueryValueExpression aValueExpr) {
        ValuesRow valuesRow = sqlQueryModelFactory.createValuesRow();
        EList exprList = valuesRow.getExprList();
        if (aValueExpr != null) {
            exprList.add((Object)aValueExpr);
        }
        return valuesRow;
    }

    public TableJoined createJoinedTable(TableReference aLeftTable, int aJoinType, TableReference aRightTable, QuerySearchCondition aJoinCond) {
        TableJoined joinedTable = sqlQueryModelFactory.createTableJoined();
        joinedTable.setTableRefLeft(aLeftTable);
        joinedTable.setTableRefRight(aRightTable);
        joinedTable.setJoinOperator(TableJoinedOperator.get((int)aJoinType));
        if (aJoinCond != null) {
            joinedTable.setJoinCondition(aJoinCond);
        }
        return joinedTable;
    }

    public ValueExpressionLabeledDuration createLabeledDurationExpression(QueryValueExpression aExpr, int aDurationType) {
        ValueExpressionLabeledDuration labeledDur = sqlQueryModelFactory.createValueExpressionLabeledDuration();
        labeledDur.setValueExpr(aExpr);
        labeledDur.setLabeledDurationType(ValueExpressionLabeledDurationType.get((int)aDurationType));
        return labeledDur;
    }

    public QueryMergeStatement createMergeStatement(MergeTargetTable aTargetTable, MergeSourceTable aSourceTable, MergeOnCondition aOnCondition, List aOperSpecList) {
        QueryMergeStatement mergeStmt = sqlQueryModelFactory.createQueryMergeStatement();
        mergeStmt.setTargetTable(aTargetTable);
        mergeStmt.setSourceTable(aSourceTable);
        mergeStmt.setOnCondition(aOnCondition);
        EList operSpecList = mergeStmt.getOperationSpecList();
        boolean addedUpdateSpec = false;
        boolean addedInsertSpec = false;
        for (MergeOperationSpecification aOperSpec : aOperSpecList) {
            if (aOperSpec instanceof MergeUpdateSpecification && !addedUpdateSpec) {
                operSpecList.add(aOperSpec);
                addedUpdateSpec = true;
            }
            if (!(aOperSpec instanceof MergeInsertSpecification) || addedInsertSpec) continue;
            operSpecList.add(aOperSpec);
            addedInsertSpec = true;
        }
        return mergeStmt;
    }

    public MergeTargetTable createMergeTargetTable(TableExpression aTableExpr, String aTableAliasName) {
        MergeTargetTable targetTable = sqlQueryModelFactory.createMergeTargetTable();
        if (aTableAliasName != null) {
            TableCorrelation tableCorr = sqlQueryModelFactory.createTableCorrelation();
            String convertedName = StatementHelper.convertSQLIdentifierToCatalogFormat((String)aTableAliasName, (char)this.getDelimitedIdentifierQuote());
            tableCorr.setName(convertedName);
            aTableExpr.setTableCorrelation(tableCorr);
        }
        targetTable.setTableExpr(aTableExpr);
        return targetTable;
    }

    public MergeSourceTable createMergeSourceTable(TableReference aTableRef) {
        MergeSourceTable sourceTable = sqlQueryModelFactory.createMergeSourceTable();
        sourceTable.setTableRef(aTableRef);
        return sourceTable;
    }

    public MergeOnCondition createMergeOnCondition(QuerySearchCondition aSearchCond) {
        MergeOnCondition onCondition = sqlQueryModelFactory.createMergeOnCondition();
        onCondition.setSearchCondition(aSearchCond);
        return onCondition;
    }

    public MergeInsertSpecification createMergeInsertSpecification(List aTargetColList, ValuesRow aValuesRow) {
        MergeInsertSpecification mergeInsertSpec = sqlQueryModelFactory.createMergeInsertSpecification();
        mergeInsertSpec.getTargetColumnList().addAll((Collection)aTargetColList);
        mergeInsertSpec.setSourceValuesRow(aValuesRow);
        return mergeInsertSpec;
    }

    public MergeUpdateSpecification createMergeUpdateSpecification(List aAssignmentExprList) {
        MergeUpdateSpecification mergeUpdateSpec = sqlQueryModelFactory.createMergeUpdateSpecification();
        mergeUpdateSpec.getAssignementExprList().addAll((Collection)aAssignmentExprList);
        return mergeUpdateSpec;
    }

    public List createMergeOperatationSpecificationList(List aMergeSpecList, MergeOperationSpecification aMergeSpec) {
        if (aMergeSpecList == null) {
            aMergeSpecList = new ArrayList<MergeOperationSpecification>();
        }
        aMergeSpecList.add(aMergeSpec);
        return aMergeSpecList;
    }

    public ValueExpressionNullValue createNullExpression() {
        ValueExpressionNullValue nullExpr = sqlQueryModelFactory.createValueExpressionNullValue();
        return nullExpr;
    }

    public SearchConditionNested createNestedCondition(QuerySearchCondition aCondition) {
        SearchConditionNested nest = sqlQueryModelFactory.createSearchConditionNested();
        if (aCondition != null) {
            nest.setNestedCondition(aCondition);
        }
        return nest;
    }

    public SearchConditionNested createNestedConditionNegated(QuerySearchCondition aCondition) {
        SearchConditionNested nest = this.createNestedCondition(aCondition);
        if (nest != null) {
            nest.setNegatedCondition(true);
        }
        return nest;
    }

    public ValueExpressionNested createNestedExpression(QueryValueExpression aNestedExpr) {
        ValueExpressionNested nest = sqlQueryModelFactory.createValueExpressionNested();
        nest.setNestedValueExpr(aNestedExpr);
        return nest;
    }

    public TableNested createNestedTable(TableReference aNestedTable) {
        TableNested nest = sqlQueryModelFactory.createTableNested();
        aNestedTable.setNest(nest);
        return nest;
    }

    public List createOrderByClause(List aOrderByList, OrderBySpecification aOrderByExpr) {
        if (aOrderByList == null) {
            aOrderByList = new Vector<OrderBySpecification>();
        }
        aOrderByList.add(aOrderByExpr);
        return aOrderByList;
    }

    public OrderBySpecification createOrderByExpression(QueryValueExpression aOrderByExpr, int orderingSpec, int nullOrdering) {
        OrderByValueExpression orderBy = null;
        if (aOrderByExpr != null && aOrderByExpr instanceof ValueExpressionSimple) {
            try {
                String value = ((ValueExpressionSimple)aOrderByExpr).getValue();
                int ordinal = Integer.parseInt(value);
                OrderByOrdinal orderByOrdinal = sqlQueryModelFactory.createOrderByOrdinal();
                orderByOrdinal.setOrdinalValue(ordinal);
                orderBy = orderByOrdinal;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (orderBy == null) {
            OrderByValueExpression orderByExpr = sqlQueryModelFactory.createOrderByValueExpression();
            orderByExpr.setValueExpr(aOrderByExpr);
            orderBy = orderByExpr;
        }
        orderBy.setOrderingSpecOption(OrderingSpecType.get((int)orderingSpec));
        orderBy.setNullOrderingOption(NullOrderingType.get((int)nullOrdering));
        orderBy.setDescending(orderingSpec == 2);
        return orderBy;
    }

    public OrderBySpecification createOrderByExpression(QueryValueExpression aOrderByExpr, String optAscDesc) {
        OrderByValueExpression orderBy = null;
        if (aOrderByExpr != null && aOrderByExpr instanceof ValueExpressionSimple) {
            try {
                String value = ((ValueExpressionSimple)aOrderByExpr).getValue();
                int ordinal = Integer.parseInt(value);
                OrderByOrdinal orderByOrdinal = sqlQueryModelFactory.createOrderByOrdinal();
                orderByOrdinal.setOrdinalValue(ordinal);
                orderBy = orderByOrdinal;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (orderBy == null) {
            OrderByValueExpression orderByExpr = sqlQueryModelFactory.createOrderByValueExpression();
            orderByExpr.setValueExpr(aOrderByExpr);
            orderBy = orderByExpr;
        }
        orderBy.setDescending(ORDER_DESC.equals(optAscDesc));
        return orderBy;
    }

    public PredefinedDataType createPredefinedDataType(String aTypeName) {
        return this.createDataTypePredefinedDataType(aTypeName);
    }

    public PredicateBasic createPredicateBasic(QueryValueExpression aLeftExpr, int aRelOper, QueryValueExpression aRightExpr) {
        PredicateBasic predBasic = sqlQueryModelFactory.createPredicateBasic();
        predBasic.setLeftValueExpr(aLeftExpr);
        predBasic.setComparisonOperator(PredicateComparisonOperator.get((int)aRelOper));
        predBasic.setRightValueExpr(aRightExpr);
        return predBasic;
    }

    public PredicateBetween createPredicateBetween(QueryValueExpression aLeftExpr, boolean isNotBetween, QueryValueExpression aRightExpr1, QueryValueExpression aRightExpr2) {
        PredicateBetween predBetween = sqlQueryModelFactory.createPredicateBetween();
        predBetween.setLeftValueExpr(aLeftExpr);
        predBetween.setNotBetween(isNotBetween);
        predBetween.setRightValueExpr1(aRightExpr1);
        predBetween.setRightValueExpr2(aRightExpr2);
        return predBetween;
    }

    public PredicateExists createPredicateExists(QueryExpressionBody aQueryExpr) {
        PredicateExists exists = sqlQueryModelFactory.createPredicateExists();
        exists.setQueryExpr(aQueryExpr);
        return exists;
    }

    public PredicateInValueList createPredicateInValueList(QueryValueExpression aLeftExpr, boolean isNotIn, List aValuesList) {
        PredicateInValueList predIn = sqlQueryModelFactory.createPredicateInValueList();
        predIn.setValueExpr(aLeftExpr);
        predIn.setNotIn(isNotIn);
        EList rightExprList = predIn.getValueExprList();
        rightExprList.addAll((Collection)aValuesList);
        return predIn;
    }

    public PredicateInValueRowSelect createPredicateInValueRowSelect(List aValuesList, boolean isNotIn, QueryExpressionRoot aQueryExpr) {
        PredicateInValueRowSelect predIn = sqlQueryModelFactory.createPredicateInValueRowSelect();
        predIn.getValueExprList().addAll((Collection)aValuesList);
        predIn.setNotIn(isNotIn);
        predIn.setQueryExpr(aQueryExpr);
        return predIn;
    }

    public PredicateInValueSelect createPredicateInValueSelect(QueryValueExpression aLeftExpr, boolean isNotIn, QueryExpressionRoot aQueryExpr) {
        PredicateInValueSelect predIn = sqlQueryModelFactory.createPredicateInValueSelect();
        predIn.setValueExpr(aLeftExpr);
        predIn.setNotIn(isNotIn);
        predIn.setQueryExpr(aQueryExpr);
        return predIn;
    }

    public PredicateLike createPredicateLike(QueryValueExpression aMatchingExpr, boolean isNotLike, QueryValueExpression aPatternExpr, QueryValueExpression aEscapeExpr) {
        PredicateLike predLike = sqlQueryModelFactory.createPredicateLike();
        predLike.setMatchingValueExpr(aMatchingExpr);
        predLike.setNotLike(isNotLike);
        predLike.setPatternValueExpr(aPatternExpr);
        if (aEscapeExpr != null) {
            predLike.setEscapeValueExpr(aEscapeExpr);
        }
        return predLike;
    }

    public PredicateIsNull createPredicateNull(QueryValueExpression aValueExpr, boolean isNotNull) {
        PredicateIsNull predNull = sqlQueryModelFactory.createPredicateIsNull();
        if (aValueExpr != null) {
            predNull.setValueExpr(aValueExpr);
        }
        predNull.setNotNull(isNotNull);
        return predNull;
    }

    public PredicateQuantifiedValueSelect createPredicateQuantifiedValueSelect(QueryValueExpression aValueExpr, int aRelOper, int aQuantType, QueryExpressionRoot aQueryExpr) {
        PredicateQuantifiedValueSelect predQuant = sqlQueryModelFactory.createPredicateQuantifiedValueSelect();
        predQuant.setValueExpr(aValueExpr);
        predQuant.setComparisonOperator(PredicateComparisonOperator.get((int)aRelOper));
        predQuant.setQuantifiedType(PredicateQuantifiedType.get((int)aQuantType));
        predQuant.setQueryExpr(aQueryExpr);
        return predQuant;
    }

    public PredicateQuantifiedRowSelect createPredicateQuantifiedRowSelect(List aValueExprList, int aQuantType, QueryExpressionRoot aQueryExpr) {
        PredicateQuantifiedRowSelect predQuant = sqlQueryModelFactory.createPredicateQuantifiedRowSelect();
        if (aValueExprList != null) {
            predQuant.getValueExprList().addAll((Collection)aValueExprList);
        }
        predQuant.setQuantifiedType(PredicateQuantifiedType.get((int)aQuantType));
        predQuant.setQueryExpr(aQueryExpr);
        return predQuant;
    }

    public ProcedureReference createProcedureReference(String aSchemaName, String aProcName) {
        ProcedureReference procRef = sqlQueryModelFactory.createProcedureReference();
        Procedure proc = SQLRoutinesFactory.eINSTANCE.createProcedure();
        Schema rdbSchema = rdbFactory.createSchema();
        char quoteChar = this.getDelimitedIdentifierQuote();
        if (aSchemaName != null) {
            String convertedSchemaName = StatementHelper.convertSQLIdentifierToCatalogFormat((String)aSchemaName, (char)quoteChar);
            rdbSchema.setName(convertedSchemaName);
        } else if (this.sourceFormat != null) {
            String omitSchemaName = this.sourceFormat.getOmitSchema();
            rdbSchema.setName(omitSchemaName);
        }
        proc.setSchema(rdbSchema);
        String convertedProcName = StatementHelper.convertSQLIdentifierToCatalogFormat((String)aProcName, (char)quoteChar);
        proc.setName(convertedProcName);
        procRef.setProcedure(proc);
        return procRef;
    }

    public QueryCombined createQueryCombined(QueryExpressionBody aLeftQuery, int combinedOperator, QueryExpressionBody aRightQuery) {
        return this.createQueryCombined(aLeftQuery, combinedOperator, aRightQuery, null, 0);
    }

    public QueryCombined createQueryCombined(QueryExpressionBody aLeftQuery, int combinedOperator, QueryExpressionBody aRightQuery, List aSortSpecList, int aRowFetchLimit) {
        QueryCombined queryCombined = sqlQueryModelFactory.createQueryCombined();
        queryCombined.setName(QueryCombinedOperator.get((int)combinedOperator).toString());
        queryCombined.setLeftQuery(aLeftQuery);
        queryCombined.setCombinedOperator(QueryCombinedOperator.get((int)combinedOperator));
        queryCombined.setRightQuery(aRightQuery);
        if (aSortSpecList != null) {
            EList sortSpecList = queryCombined.getSortSpecList();
            sortSpecList.addAll(aSortSpecList);
        }
        queryCombined.setRowFetchLimit(aRowFetchLimit);
        return queryCombined;
    }

    public QueryNested createQueryNested(QueryExpressionBody queryExprBody) {
        return this.createQueryNested(queryExprBody, null, 0);
    }

    public QueryNested createQueryNested(QueryExpressionBody queryExprBody, List aSortSpecList, int aRowFetchLimit) {
        QueryNested queryNested = sqlQueryModelFactory.createQueryNested();
        queryNested.setNestedQuery(queryExprBody);
        queryExprBody.setQueryNest(queryNested);
        if (aSortSpecList != null) {
            EList sortSpecList = queryNested.getSortSpecList();
            sortSpecList.addAll(aSortSpecList);
        }
        queryNested.setRowFetchLimit(aRowFetchLimit);
        return queryNested;
    }

    public QuerySelect createQuerySelect(String optAllOrDistinct, List aResultColList, List aTableRefList, QuerySearchCondition aWhereClause, List aGroupByList, QuerySearchCondition aHavingClause) {
        return this.createQuerySelect(optAllOrDistinct, aResultColList, aTableRefList, aWhereClause, aGroupByList, aHavingClause, null, 0);
    }

    public QuerySelect createQuerySelect(String optAllOrDistinct, List aResultColList, List aTableRefList, QuerySearchCondition aWhereClaus, List aGroupByList, QuerySearchCondition aHavingClaus, List aSortSpecList, int aRowFetchLimit) {
        QuerySelect qrySel = sqlQueryModelFactory.createQuerySelect();
        qrySel.setDistinct(DISTINCT.equals(optAllOrDistinct));
        if (aResultColList != null) {
            qrySel.getSelectClause().addAll((Collection)aResultColList);
        }
        if (aTableRefList != null) {
            qrySel.getFromClause().addAll((Collection)aTableRefList);
        }
        qrySel.setWhereClause(aWhereClaus);
        if (aGroupByList != null) {
            qrySel.getGroupByClause().addAll((Collection)aGroupByList);
        }
        qrySel.setHavingClause(aHavingClaus);
        if (aSortSpecList != null) {
            EList sortSpecList = qrySel.getSortSpecList();
            sortSpecList.addAll(aSortSpecList);
        }
        qrySel.setRowFetchLimit(aRowFetchLimit);
        return qrySel;
    }

    public QueryValues createQueryValues(List aValuesRowList) {
        return this.createQueryValues(aValuesRowList, null, 0);
    }

    public QueryValues createQueryValues(List aValuesRowList, List aSortSpecList, int aRowFetchLimit) {
        QueryValues queryValues = sqlQueryModelFactory.createQueryValues();
        if (aValuesRowList != null) {
            queryValues.getValuesRowList().addAll((Collection)aValuesRowList);
        }
        if (aSortSpecList != null) {
            EList sortSpecList = queryValues.getSortSpecList();
            sortSpecList.addAll(aSortSpecList);
        }
        queryValues.setRowFetchLimit(aRowFetchLimit);
        return queryValues;
    }

    public QueryExpressionRoot createQueryExpressionRoot(QueryExpressionBody aQuery, List aWithTableSpecList) {
        QueryExpressionRoot queryExpr = sqlQueryModelFactory.createQueryExpressionRoot();
        queryExpr.setQuery(aQuery);
        if (aWithTableSpecList != null) {
            queryExpr.getWithClause().addAll((Collection)aWithTableSpecList);
        }
        return queryExpr;
    }

    public TableExpression createReferenceTable(String aSchemaName, String aTableName, String aCorrName) {
        return this.createReferenceTable(aSchemaName, aTableName, this.createTableCorrelation(aCorrName));
    }

    public TableExpression createReferenceTable(String aSchemaName, String aTableName, TableCorrelation aTableCorr) {
        TableInDatabase table = this.createSimpleTable(aSchemaName, aTableName);
        table.setTableCorrelation(aTableCorr);
        return table;
    }

    public ResultColumn createResultColumn(QueryValueExpression aResultColExpr, String aAsName) {
        ResultColumn resultCol = sqlQueryModelFactory.createResultColumn();
        resultCol.setValueExpr(aResultColExpr);
        if (aAsName != null) {
            resultCol.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aAsName, (char)this.getDelimitedIdentifierQuote()));
        }
        return resultCol;
    }

    public ResultTableAllColumns createResultTableAllColumns(String aTableName) {
        return this.createResultTableAllColumns(aTableName, null);
    }

    public ResultTableAllColumns createResultTableAllColumns(String aTableName, String aSchemaName) {
        ResultTableAllColumns resultTableAll = sqlQueryModelFactory.createResultTableAllColumns();
        TableInDatabase tableInDB = this.createSimpleTable(aSchemaName, aTableName);
        resultTableAll.setTableExpr((TableExpression)tableInDB);
        String identDelimQt = String.valueOf(this.getDelimitedIdentifierQuote());
        if (aSchemaName != null && !aSchemaName.startsWith(identDelimQt) && !aSchemaName.endsWith(identDelimQt)) {
            aSchemaName = aSchemaName.toUpperCase();
        }
        if (!aTableName.startsWith(identDelimQt) && !aTableName.endsWith(identDelimQt)) {
            aTableName = aTableName.toUpperCase();
        }
        if (aSchemaName != null) {
            resultTableAll.setName(String.valueOf(aSchemaName) + "." + aTableName);
        } else {
            resultTableAll.setName(aTableName);
        }
        return resultTableAll;
    }

    public ValueExpressionScalarSelect createScalarSelectExpression(QueryExpressionRoot aQueryExpr) {
        ValueExpressionScalarSelect scalarSelect = sqlQueryModelFactory.createValueExpressionScalarSelect();
        scalarSelect.setQueryExpr(aQueryExpr);
        return scalarSelect;
    }

    public Schema createSchema(String aSchemaName) {
        Schema schema = rdbFactory.createSchema();
        schema.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aSchemaName, (char)this.getDelimitedIdentifierQuote()));
        return schema;
    }

    public List createSelectClause(List aResultSpecList, QueryResultSpecification aResultCol) {
        if (aResultSpecList == null) {
            aResultSpecList = new Vector<QueryResultSpecification>();
        }
        if (aResultCol != null) {
            aResultSpecList.add(aResultCol);
        }
        return aResultSpecList;
    }

    public QuerySelectStatement createSelectStatement(QuerySelect aQrySel, List aOrderByList) {
        QueryExpressionRoot qryExpr = sqlQueryModelFactory.createQueryExpressionRoot();
        qryExpr.setQuery((QueryExpressionBody)aQrySel);
        return this.createSelectStatement(qryExpr, aOrderByList);
    }

    public QuerySelectStatement createSelectStatement(QueryExpressionRoot aQryExpr, List aOrderByList) {
        return this.createSelectStatement(aQryExpr, aOrderByList, null);
    }

    public QuerySelectStatement createSelectStatement(QueryExpressionRoot aQryExpr, List aOrderByList, UpdatabilityExpression aUpdatabilityExpr) {
        QuerySelectStatement qryStatement = sqlQueryModelFactory.createQuerySelectStatement();
        qryStatement.setQueryExpr(aQryExpr);
        EList orderByList = qryStatement.getOrderByClause();
        if (aOrderByList != null) {
            orderByList.addAll((Collection)aOrderByList);
        }
        if (aUpdatabilityExpr != null) {
            qryStatement.setUpdatabilityExpr(aUpdatabilityExpr);
        }
        return qryStatement;
    }

    public ValueExpressionSimple createSimpleExpression(String aExpr) {
        ValueExpressionSimple exprSimple = sqlQueryModelFactory.createValueExpressionSimple();
        exprSimple.setValue(aExpr);
        return exprSimple;
    }

    public TableInDatabase createSimpleTable(String aSchemaName, String aTableName) {
        TableInDatabase table = sqlQueryModelFactory.createTableInDatabase();
        TemporaryTable rdbTable = tableFactory.createTemporaryTable();
        Schema rdbSchema = rdbFactory.createSchema();
        table.setDatabaseTable((Table)rdbTable);
        rdbTable.setSchema(rdbSchema);
        if (aSchemaName != null) {
            rdbSchema.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aSchemaName, (char)this.getDelimitedIdentifierQuote()));
        } else if (this.sourceFormat != null) {
            aSchemaName = this.sourceFormat.getOmitSchema();
            rdbSchema.setName(aSchemaName);
        }
        table.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aTableName, (char)this.getDelimitedIdentifierQuote()));
        rdbTable.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aTableName, (char)this.getDelimitedIdentifierQuote()));
        return table;
    }

    public ValueExpressionFunction createSpecialRegisterExpression(String aSpecialReg) {
        ValueExpressionFunction func = sqlQueryModelFactory.createValueExpressionFunction();
        func.setName(aSpecialReg);
        func.setSpecialRegister(true);
        return func;
    }

    public ValueExpressionFunction createSpecialRegisterExpression(String aRegName, UserDefinedType aDataType) {
        ValueExpressionFunction func = sqlQueryModelFactory.createValueExpressionFunction();
        func.setName(aRegName);
        func.setSpecialRegister(true);
        if (aDataType != null) {
            func.setDataType((DataType)aDataType);
        }
        return func;
    }

    public ValueExpressionFunction createSpecialRegisterExpression(String aSpecialReg, String value) {
        ValueExpressionFunction func = sqlQueryModelFactory.createValueExpressionFunction();
        func.setName(aSpecialReg);
        func.setSpecialRegister(true);
        if (value != null) {
            ValueExpressionSimple valueExprSimple = sqlQueryModelFactory.createValueExpressionSimple();
            valueExprSimple.setValue(value);
            func.getParameterList().add((Object)valueExprSimple);
        }
        return func;
    }

    public SuperGroup createSuperGroups(List aSuperGroupsElementList, int aSuperGroupType) {
        SuperGroup superGroup = sqlQueryModelFactory.createSuperGroup();
        if (aSuperGroupsElementList != null) {
            superGroup.getSuperGroupElementList().addAll((Collection)aSuperGroupsElementList);
        }
        superGroup.setSuperGroupType(SuperGroupType.get((int)aSuperGroupType));
        return superGroup;
    }

    public List createSuperGroupsElementList(List aSuperGroupsElementList, SuperGroupElement aSuperGroupsElement) {
        if (aSuperGroupsElementList == null) {
            aSuperGroupsElementList = new Vector<SuperGroupElement>();
        }
        aSuperGroupsElementList.add(aSuperGroupsElement);
        return aSuperGroupsElementList;
    }

    public SuperGroupElementExpression createSuperGroupsElementExpression(GroupingExpression aGroupingExpr) {
        SuperGroupElementExpression superGroupsElementExpr = sqlQueryModelFactory.createSuperGroupElementExpression();
        superGroupsElementExpr.setGroupingExpr(aGroupingExpr);
        return superGroupsElementExpr;
    }

    public List createSuperGroupsElementExprList(List aSuperGroupsElementExprList, SuperGroupElementExpression aSuperGroupsElementExpr) {
        if (aSuperGroupsElementExprList == null) {
            aSuperGroupsElementExprList = new Vector<SuperGroupElementExpression>();
        }
        aSuperGroupsElementExprList.add(aSuperGroupsElementExpr);
        return aSuperGroupsElementExprList;
    }

    public SuperGroupElementSublist createSuperGroupsElementSublist(List aSuperGroupsElementExprList) {
        SuperGroupElementSublist superGroupSublist = sqlQueryModelFactory.createSuperGroupElementSublist();
        if (aSuperGroupsElementExprList != null) {
            superGroupSublist.getSuperGroupElementExprList().addAll((Collection)aSuperGroupsElementExprList);
        }
        return superGroupSublist;
    }

    public TableCorrelation createTableCorrelation(String aCorrName) {
        return this.createTableCorrelation(aCorrName, null);
    }

    public TableCorrelation createTableCorrelation(String aCorrName, List aColNameList) {
        TableCorrelation corr = null;
        if (aCorrName != null) {
            corr = sqlQueryModelFactory.createTableCorrelation();
            corr.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aCorrName, (char)this.getDelimitedIdentifierQuote()));
            if (aColNameList != null && aColNameList.size() > 0) {
                corr.getColumnNameList().addAll((Collection)aColNameList);
            }
        }
        return corr;
    }

    public TableExpression createTableExpressionQuery(QueryExpressionBody aSubquery, String aCorrName) {
        return this.createTableExpressionQuery(aSubquery, this.createTableCorrelation(aCorrName));
    }

    public TableExpression createTableExpressionQuery(QueryExpressionBody aSubquery, TableCorrelation aTableCorr) {
        QueryExpressionBody nestedQueryTableExpr = aSubquery;
        nestedQueryTableExpr.setTableCorrelation(aTableCorr);
        return nestedQueryTableExpr;
    }

    public TableFunction createTableFunction(String aFuncName, List aFuncParmList, String aSchemaName, TableCorrelation aTableCorr) {
        Schema schema;
        TableFunction func = sqlQueryModelFactory.createTableFunction();
        Function function = SQLRoutinesFactory.eINSTANCE.createFunction();
        func.setFunction(function);
        func.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aFuncName, (char)this.getDelimitedIdentifierQuote()));
        if (aSchemaName != null) {
            schema = this.createSchema(aSchemaName);
            function.setSchema(schema);
        }
        if (aSchemaName != null) {
            schema = this.createSchema(aSchemaName);
            function.setSchema(schema);
        }
        if (aFuncParmList != null) {
            EList funcParmList = func.getParameterList();
            funcParmList.addAll((Collection)aFuncParmList);
        }
        func.setTableCorrelation(aTableCorr);
        return func;
    }

    public UpdatabilityExpression createUpdatabilityExpression(int aUpdatabilityType, List aUpdateOfColList) {
        UpdatabilityExpression updatabilityExpr = sqlQueryModelFactory.createUpdatabilityExpression();
        updatabilityExpr.setUpdatabilityType(UpdatabilityType.get((int)aUpdatabilityType));
        if (aUpdateOfColList != null) {
            EList updateOfColList = updatabilityExpr.getUpdateOfColumnList();
            for (Object listObj : aUpdateOfColList) {
                if (!(listObj instanceof ColumnName)) continue;
                ColumnName colNameObj = (ColumnName)listObj;
                String colName = colNameObj.getName();
                UpdateOfColumn updateOfCol = sqlQueryModelFactory.createUpdateOfColumn();
                updateOfCol.setName(colName);
                updateOfColList.add(updateOfCol);
            }
        }
        return updatabilityExpr;
    }

    public List createUpdateAssignmentClause(List aExprList, UpdateAssignmentExpression aExpr) {
        if (aExprList == null) {
            aExprList = new Vector<UpdateAssignmentExpression>();
        }
        aExprList.add(aExpr);
        return aExprList;
    }

    public UpdateAssignmentExpression createUpdateAssignmentExpression(ValueExpressionColumn aTargetCol, QueryValueExpression aExpr) {
        Vector<ValueExpressionColumn> targetColList = new Vector<ValueExpressionColumn>(1);
        Vector<QueryValueExpression> exprList = new Vector<QueryValueExpression>(1);
        targetColList.add(aTargetCol);
        exprList.add(aExpr);
        return this.createUpdateAssignmentExpression(targetColList, exprList);
    }

    public UpdateAssignmentExpression createUpdateAssignmentExpression(List aTargetColList, List aExprList) {
        if (aExprList != null && aExprList.size() == 1 && aExprList.get(0) != null && aExprList.get(0) instanceof ValueExpressionScalarSelect) {
            ValueExpressionScalarSelect scalarSelect = (ValueExpressionScalarSelect)aExprList.get(0);
            QueryExpressionRoot queryExpr = scalarSelect.getQueryExpr();
            QueryExpressionBody query = queryExpr.getQuery();
            queryExpr.setQuery(null);
            return this.createUpdateAssignmentExpression(aTargetColList, query);
        }
        UpdateAssignmentExpression assign = sqlQueryModelFactory.createUpdateAssignmentExpression();
        EList targetColList = assign.getTargetColumnList();
        targetColList.addAll((Collection)aTargetColList);
        UpdateSourceExprList exprList = sqlQueryModelFactory.createUpdateSourceExprList();
        EList valueExprList = exprList.getValueExprList();
        valueExprList.addAll((Collection)aExprList);
        assign.setUpdateSource((UpdateSource)exprList);
        return assign;
    }

    public UpdateAssignmentExpression createUpdateAssignmentExpression(List aTargetColList, QueryExpressionBody aUpdateQuery) {
        UpdateAssignmentExpression assign = sqlQueryModelFactory.createUpdateAssignmentExpression();
        EList targetColList = assign.getTargetColumnList();
        targetColList.addAll((Collection)aTargetColList);
        UpdateSourceQuery sourceQuery = sqlQueryModelFactory.createUpdateSourceQuery();
        sourceQuery.setQueryExpr(aUpdateQuery);
        assign.setUpdateSource((UpdateSource)sourceQuery);
        return assign;
    }

    public QueryUpdateStatement createUpdateStatement(TableInDatabase aTargetTable, TableCorrelation aAsTable, List aAssignmentList, QuerySearchCondition aWhereCond) {
        QueryUpdateStatement sqlUpdate = sqlQueryModelFactory.createQueryUpdateStatement();
        if (aAsTable != null) {
            aTargetTable.setTableCorrelation(aAsTable);
        }
        sqlUpdate.setTargetTable(aTargetTable);
        EList assignmentList = sqlUpdate.getAssignmentClause();
        if (aAssignmentList != null) {
            assignmentList.addAll((Collection)aAssignmentList);
        }
        sqlUpdate.setWhereClause(aWhereCond);
        return sqlUpdate;
    }

    public CallStatement createCallStatement(ProcedureReference procRef, List argList) {
        CallStatement callStmt = sqlQueryModelFactory.createCallStatement();
        callStmt.setProcedureRef(procRef);
        if (argList != null) {
            EList callStmtArgList = callStmt.getArgumentList();
            for (Object obj : argList) {
                callStmtArgList.add(obj);
            }
        }
        return callStmt;
    }

    public DataType createUserDefinedTypeFromDomainName(String domainName) {
        return null;
    }

    public ValueExpressionVariable createVariableExpression(String aVarName) {
        ValueExpressionVariable varExpr = sqlQueryModelFactory.createValueExpressionVariable();
        if (aVarName != null) {
            String hostVarPrefix = String.valueOf(this.sourceFormat.getHostVariablePrefix());
            if (aVarName.startsWith(hostVarPrefix)) {
                aVarName = aVarName.substring(1);
            }
            varExpr.setName(aVarName);
        }
        return varExpr;
    }

    public ValueExpressionRow createValueExpressionRow(List aExprList) {
        ValueExpressionRow valExprRow = sqlQueryModelFactory.createValueExpressionRow();
        if (aExprList != null) {
            valExprRow.getValueExprList().addAll((Collection)aExprList);
        }
        return valExprRow;
    }

    public ValuesRow createValuesRow(List aValueExprList) {
        ValuesRow valuesRow = sqlQueryModelFactory.createValuesRow();
        if (aValueExprList != null) {
            valuesRow.getExprList().addAll((Collection)aValueExprList);
        }
        return valuesRow;
    }

    public ValuesRow createValuesRow(QueryValueExpression aValueExpr) {
        ValuesRow valuesRow = sqlQueryModelFactory.createValuesRow();
        if (aValueExpr instanceof ValueExpressionNested) {
            ValueExpressionNested nest = (ValueExpressionNested)aValueExpr;
            aValueExpr = nest.getNestedValueExpr();
        }
        if (aValueExpr != null) {
            valuesRow.getExprList().add((Object)aValueExpr);
        }
        return valuesRow;
    }

    public List createValuesRowList(List aValuesRowList, ValuesRow aValuesRow) {
        if (aValuesRowList == null) {
            aValuesRowList = new Vector<ValuesRow>();
        }
        aValuesRowList.add(aValuesRow);
        return aValuesRowList;
    }

    public WithTableSpecification createWithTableSpecification(String aTableIdentifier, List aColumnNameList, QueryExpressionBody aWithSource) {
        WithTableSpecification withTable = sqlQueryModelFactory.createWithTableSpecification();
        withTable.setName(StatementHelper.convertSQLIdentifierToCatalogFormat((String)aTableIdentifier, (char)this.getDelimitedIdentifierQuote()));
        if (aColumnNameList != null && !aColumnNameList.isEmpty()) {
            withTable.getColumnNameList().addAll((Collection)aColumnNameList);
        }
        withTable.setWithTableQueryExpr(aWithSource);
        return withTable;
    }

    public List createWithTableSpecificationList(List aTableWithSpecList, WithTableSpecification aTableWithSpec) {
        if (aTableWithSpecList == null) {
            aTableWithSpecList = new Vector<WithTableSpecification>();
        }
        aTableWithSpecList.add(aTableWithSpec);
        return aTableWithSpecList;
    }

    public static boolean isColumnFunction(String aFuncName) {
        String tempName = aFuncName.trim().toUpperCase();
        return SQLQueryParserFactory.isDistinctColumnFunction(tempName) || tempName.equals("CORR") || tempName.equals("CORRELATION") || tempName.equals("COVAR") || tempName.equals("COVARIANCE") || tempName.equals("GROUPING") || tempName.equals("REGR_AVGX") || tempName.equals("REGR_AVGY") || tempName.equals("REGR_COUNT") || tempName.equals("REGR_INTERCEPT") || tempName.equals("REGR_ICPT") || tempName.equals("REGR_R2") || tempName.equals("REGR_SLOPE") || tempName.equals("REGR_SXX") || tempName.equals("REGR_SXY") || tempName.equals("REGR_SYY");
    }

    public static boolean isDistinctColumnFunction(String aFuncName) {
        String tempName = aFuncName.trim().toUpperCase();
        return tempName.equals("AVG") || tempName.equals("COUNT") || tempName.equals("COUNT_BIG") || tempName.equals("MAX") || tempName.equals("MIN") || tempName.equals("STDDEV") || tempName.equals("SUM") || tempName.equals("VAR") || tempName.equals("VARIANCE");
    }

    public QuerySearchCondition negateCondition(QuerySearchCondition aSearchCond, boolean negate) {
        if (aSearchCond instanceof Predicate) {
            return this.negatePredicate((Predicate)aSearchCond, negate);
        }
        if (negate) {
            boolean isNegated = aSearchCond.isNegatedCondition();
            aSearchCond.setNegatedCondition(!isNegated);
        }
        return aSearchCond;
    }

    public Predicate negatePredicate(Predicate aPredicate, boolean negate) {
        if (negate) {
            boolean isNegated = aPredicate.isNegatedPredicate();
            aPredicate.setNegatedPredicate(!isNegated);
        }
        return aPredicate;
    }

    public QueryValueExpression setUnaryOperator(QueryValueExpression expr, int op) {
        expr.setUnaryOperator(ValueExpressionUnaryOperator.get((int)op));
        return expr;
    }
}

