/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.ContainerInstantiatorUtils;
import org.eclipse.ecf.core.provider.ContainerIntentException;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.IDUtil;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.osgi.framework.ServiceReference;

public abstract class AbstractHostContainerSelector
extends AbstractContainerSelector {
    private static final String REQUIRE_SERVER_PROP = "org.eclipse.ecf.osgi.service.remoteserviceadmin.hostcontainerselector.requireserver";
    private static final String EXCLUDED_DESCRIPTIONS_PROP = "org.eclipse.ecf.osgi.service.remoteserviceadmin.hostcontainerselector.excludeddescriptions";
    private boolean requireServer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.service.remoteserviceadmin.hostcontainerselector.requireserver", "true"));
    private List<String> excludedDescriptions;
    protected String[] defaultConfigTypes;

    protected void setExcludedDescriptions(List<String> excludedDescriptions) {
        this.excludedDescriptions = excludedDescriptions == null ? Collections.EMPTY_LIST : excludedDescriptions;
    }

    protected List<String> getExcludedDescriptions() {
        return this.excludedDescriptions;
    }

    protected void setRequireServer(boolean requireServerDescriptionForExport) {
        this.requireServer = requireServerDescriptionForExport;
    }

    protected boolean getRequireServerDescription() {
        return this.requireServer;
    }

    public AbstractHostContainerSelector(String[] defaultConfigTypes) {
        this.defaultConfigTypes = defaultConfigTypes;
        String propValue = System.getProperty(EXCLUDED_DESCRIPTIONS_PROP);
        String[] excludedVals = propValue == null ? new String[]{} : propValue.trim().split(",");
        this.setExcludedDescriptions(Arrays.asList(excludedVals));
    }

    protected Collection selectExistingHostContainers(ServiceReference serviceReference, Map<String, Object> overridingProperties, String[] serviceExportedInterfaces, String[] serviceExportedConfigs, String[] serviceIntents) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        IContainer[] containers = this.getContainers();
        if (containers == null || containers.length == 0) {
            return results;
        }
        int i = 0;
        while (i < containers.length) {
            ID cID = containers[i].getID();
            this.trace("selectExistingHostContainers", "Considering existing container=" + cID);
            IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
            if (adapter == null) {
                this.trace("selectExistingHostContainers", "Existing container=" + cID + " does not implement IRemoteServiceContainerAdapter");
            } else {
                ContainerTypeDescription description = this.getContainerTypeDescription(containers[i]);
                if (description == null) {
                    this.trace("selectExistingHostContainers", "Existing container=" + cID + " does not have container type description");
                } else if (!description.isServer()) {
                    this.trace("selectExistingHostContainers", "Existing container=" + cID + " is not server");
                } else if (this.matchExistingHostContainer(serviceReference, overridingProperties, containers[i], adapter, description, serviceExportedConfigs, serviceIntents)) {
                    this.trace("selectExistingHostContainers", "INCLUDING containerID=" + containers[i].getID() + " configs=" + (serviceExportedConfigs == null ? "null" : Arrays.asList(serviceExportedConfigs).toString()) + " intents=" + (serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString()));
                    results.add(new RemoteServiceContainer(containers[i], adapter));
                } else {
                    this.trace("selectExistingHostContainers", "EXCLUDING containerID=" + containers[i].getID() + " configs=" + (serviceExportedConfigs == null ? "null" : Arrays.asList(serviceExportedConfigs).toString()) + " intents=" + (serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString()));
                }
            }
            ++i;
        }
        return results;
    }

    protected boolean matchHostContainerToConnectTarget(ServiceReference serviceReference, Map<String, Object> properties, IContainer container) {
        String target = (String)properties.get("ecf.endpoint.connecttarget.id");
        if (target == null) {
            return true;
        }
        ID connectedID = container.getConnectedID();
        if (connectedID == null) {
            try {
                this.connectHostContainer(serviceReference, properties, container, target);
            }
            catch (Exception e) {
                this.logException("doConnectContainer containerID=" + container.getID() + " target=" + target, e);
                return false;
            }
            return true;
        }
        ID targetID = this.createTargetID(container, target);
        return connectedID.equals((Object)targetID);
    }

    protected boolean matchExistingHostContainer(ServiceReference serviceReference, Map<String, Object> properties, IContainer container, IRemoteServiceContainerAdapter adapter, ContainerTypeDescription description, String[] requiredConfigTypes, String[] requiredServiceIntents) {
        return this.matchRequireServer(description) && this.matchNotExcluded(description) && this.matchHostSupportedConfigTypes(requiredConfigTypes, description) && this.matchHostSupportedIntents(requiredServiceIntents, description, container) && this.matchHostContainerID(serviceReference, properties, container) && this.matchHostContainerToConnectTarget(serviceReference, properties, container);
    }

    protected boolean matchHostContainerID(ServiceReference serviceReference, Map<String, Object> properties, IContainer container) {
        ID containerID = container.getID();
        if (containerID == null) {
            return false;
        }
        ID requiredContainerID = (ID)properties.get("ecf.exported.containerid");
        if (requiredContainerID != null) {
            return requiredContainerID.equals((Object)containerID);
        }
        Namespace ns = containerID.getNamespace();
        Object cid = properties.get("ecf.exported.containerfactoryargs");
        if (cid == null) {
            return true;
        }
        ID cID = null;
        if (cid instanceof ID) {
            cID = (ID)cid;
        } else if (cid instanceof String) {
            cID = IDUtil.createID(ns, (String)cid);
        } else if (cid instanceof Object[]) {
            Object cido = ((Object[])cid)[0];
            cID = IDUtil.createID(ns, new Object[]{cido});
        }
        if (cID == null) {
            return true;
        }
        return containerID.equals((Object)cID);
    }

    protected boolean matchHostSupportedConfigTypes(String[] requiredConfigTypes, ContainerTypeDescription containerTypeDescription) {
        if (requiredConfigTypes == null) {
            return true;
        }
        this.trace("matchHostSupportedConfigTypes", "description=" + containerTypeDescription.getName() + " testing for requiredConfigTypes");
        String[] supportedConfigTypes = this.getSupportedConfigTypes(containerTypeDescription);
        if (supportedConfigTypes == null || supportedConfigTypes.length == 0) {
            this.trace("matchHostSupportedConfigTypes", "No supported configs found for description=" + containerTypeDescription.getName());
            return false;
        }
        List<String> supportedConfigTypesList = Arrays.asList(supportedConfigTypes);
        List<String> requiredConfigTypesList = Arrays.asList(requiredConfigTypes);
        boolean result = false;
        Iterator<String> i = requiredConfigTypesList.iterator();
        while (i.hasNext()) {
            result |= supportedConfigTypesList.contains(i.next());
        }
        if (!result) {
            this.trace("matchHostSupportedConfigTypes", "description=" + containerTypeDescription.getName() + " does not support all required config types");
        }
        return result;
    }

    protected Collection createAndConfigureHostContainers(ServiceReference serviceReference, Map<String, Object> properties, String[] serviceExportedInterfaces, String[] requiredConfigs, String[] serviceIntents) throws SelectContainerException {
        ArrayList<IRemoteServiceContainer> results = new ArrayList<IRemoteServiceContainer>();
        ContainerTypeDescription[] descriptions = this.getContainerTypeDescriptions();
        if (descriptions == null) {
            return Collections.EMPTY_LIST;
        }
        int i = 0;
        while (i < descriptions.length) {
            this.trace("createAndConfigureHostContainers", "Considering description=" + descriptions[i]);
            IRemoteServiceContainer matchingContainer = this.createMatchingContainer(descriptions[i], serviceReference, properties, serviceExportedInterfaces, requiredConfigs, serviceIntents);
            if (matchingContainer != null) {
                results.add(matchingContainer);
            }
            ++i;
        }
        return results;
    }

    protected ContainerTypeDescription[] getContainerTypeDescriptionsForDefaultConfigTypes(ContainerTypeDescription[] descriptions) {
        String[] defaultConfigTypes = this.getDefaultConfigTypes();
        if (defaultConfigTypes == null || defaultConfigTypes.length == 0) {
            return null;
        }
        ArrayList<ContainerTypeDescription> results = new ArrayList<ContainerTypeDescription>();
        int i = 0;
        while (i < descriptions.length) {
            String[] supportedConfigTypes = descriptions[i].getSupportedConfigs();
            if (supportedConfigTypes != null && this.matchDefaultConfigTypes(defaultConfigTypes, supportedConfigTypes)) {
                results.add(descriptions[i]);
            }
            ++i;
        }
        return results.toArray(new ContainerTypeDescription[0]);
    }

    protected boolean matchDefaultConfigTypes(String[] defaultConfigTypes, String[] supportedConfigTypes) {
        List<String> supportedConfigTypesList = Arrays.asList(supportedConfigTypes);
        int i = 0;
        while (i < defaultConfigTypes.length) {
            if (supportedConfigTypesList.contains(defaultConfigTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String[] getDefaultConfigTypes() {
        return this.defaultConfigTypes;
    }

    protected boolean matchRequireServer(ContainerTypeDescription description) {
        boolean result = false;
        boolean require = this.getRequireServerDescription();
        if (!require) {
            result = true;
            LogUtility.trace("matchRequireServer", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), "Server is not required for export, so description=" + description.getName() + " is allowed to export");
            return true;
        }
        result = description.isServer();
        LogUtility.trace("matchRequireServer", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), "Server is required for export, so description=" + description.getName() + (result ? " isServer() return true" : " IS NOT SERVER"));
        return result;
    }

    protected boolean matchNotExcluded(ContainerTypeDescription description) {
        boolean result = this.getExcludedDescriptions().contains(description.getName());
        LogUtility.trace("matchNotExcluded", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), "description=" + description.getName() + (result ? " EXCLUDED via excludedDescriptions=" + this.excludedDescriptions : " not excluded via excludedDescriptions=" + this.excludedDescriptions));
        return !result;
    }

    protected IRemoteServiceContainer createMatchingContainer(ContainerTypeDescription containerTypeDescription, ServiceReference serviceReference, Map<String, Object> properties, String[] serviceExportedInterfaces, String[] requiredConfigs, String[] serviceIntents) throws SelectContainerException {
        if (this.matchRequireServer(containerTypeDescription) && this.matchNotExcluded(containerTypeDescription) && this.matchHostSupportedConfigTypes(requiredConfigs, containerTypeDescription) && this.matchHostSupportedIntents(serviceIntents, containerTypeDescription)) {
            return this.createRSContainer(serviceReference, properties, containerTypeDescription, serviceIntents);
        }
        return null;
    }

    protected IRemoteServiceContainer createRSContainer(ServiceReference serviceReference, Map<String, Object> properties, ContainerTypeDescription containerTypeDescription) throws SelectContainerException {
        return this.createRSContainer(serviceReference, properties, containerTypeDescription, null);
    }

    protected IRemoteServiceContainer createRSContainer(ServiceReference serviceReference, Map<String, Object> properties, ContainerTypeDescription containerTypeDescription, String[] intents) throws SelectContainerException {
        this.trace("createRSContainer", "Creating container instance for ref=" + serviceReference + ";properties=" + properties + ";description=" + containerTypeDescription.getName() + ";intents=" + (intents == null ? "" : Arrays.asList(intents).toString()));
        IContainer container = this.createContainer(serviceReference, properties, containerTypeDescription, intents);
        if (container == null) {
            return null;
        }
        IRemoteServiceContainerAdapter adapter = (IRemoteServiceContainerAdapter)container.getAdapter(IRemoteServiceContainerAdapter.class);
        if (adapter == null) {
            LogUtility.logError("createRSContainer", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/containerselector", this.getClass(), "Container=" + container.getID() + " does not implement IRemoteServiceContainerAdapter");
            return null;
        }
        return new RemoteServiceContainer(container, adapter);
    }

    protected void connectHostContainer(ServiceReference serviceReference, Map<String, Object> properties, IContainer container, Object target) throws ContainerConnectException, IDCreateException {
        ID targetID = target instanceof String ? IDUtil.createID(container.getConnectNamespace(), (String)target) : IDUtil.createID(container.getConnectNamespace(), new Object[]{target});
        Object context = properties.get("ecf.exported.containerconnectcontext");
        IConnectContext connectContext = null;
        if (context != null) {
            connectContext = this.createConnectContext(serviceReference, properties, container, context);
        }
        container.connect(targetID, connectContext);
    }

    protected boolean matchHostSupportedIntents(String[] serviceRequiredIntents, ContainerTypeDescription containerTypeDescription) {
        return this.matchHostSupportedIntents(serviceRequiredIntents, containerTypeDescription, null);
    }

    protected boolean matchHostSupportedIntents(String[] serviceRequiredIntents, ContainerTypeDescription containerTypeDescription, IContainer container) {
        if (serviceRequiredIntents == null) {
            return true;
        }
        this.trace("matchHostSupportedIntents", "description=" + containerTypeDescription.getName() + " testing for serviceRequiredIntents=" + Arrays.asList(serviceRequiredIntents));
        String[] supportedIntents = this.getSupportedIntents(containerTypeDescription);
        if (supportedIntents == null) {
            this.trace("matchHostSupportedIntents", "description=" + containerTypeDescription.getName() + " does not have any supported intents");
            return false;
        }
        boolean result = true;
        int i = 0;
        while (i < serviceRequiredIntents.length) {
            boolean found = false;
            String[] stringArray = supportedIntents;
            int n = supportedIntents.length;
            int n2 = 0;
            while (n2 < n) {
                String supportedIntent = stringArray[n2];
                if (serviceRequiredIntents[i].equals(supportedIntent) || serviceRequiredIntents[i].startsWith(String.valueOf(supportedIntent) + ".")) {
                    found = true;
                    break;
                }
                ++n2;
            }
            result &= found;
            ++i;
        }
        if (!result) {
            this.trace("matchHostSupportedIntents", "description=" + containerTypeDescription.getName() + " does not have all required intents");
            return false;
        }
        if (container != null) {
            try {
                if (ContainerInstantiatorUtils.containsPrivateIntent((String[])serviceRequiredIntents)) {
                    ContainerInstantiatorUtils.checkPrivate((ID)container.getID());
                }
            }
            catch (ContainerIntentException e) {
                this.trace("matchHostSupportedIntents", "container=" + container.getID() + " does not have osgi private intent");
                return false;
            }
        }
        if (!result) {
            this.trace("matchHostSupportedIntents", "container=" + container.getID() + " does not have all required intents");
        }
        return result;
    }
}

