/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt.selection;

import java.util.function.Supplier;
import org.eclipse.emf.ecp.view.spi.swt.selection.IMasterDetailSelectionProvider;
import org.eclipse.emf.ecp.view.spi.swt.selection.NullSelectionProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;

public final class MasterDetailFocusAdapter
implements FocusListener {
    private final IMasterDetailSelectionProvider selectionProvider;
    private final Supplier<? extends Control> detailSupplier;

    public MasterDetailFocusAdapter(IMasterDetailSelectionProvider selectionProvider, Supplier<? extends Control> detailSupplier) {
        this.selectionProvider = selectionProvider;
        this.detailSupplier = detailSupplier;
    }

    public void focusGained(FocusEvent e) {
        this.selectionProvider.setDetailSelectionProvider(null);
    }

    public void focusLost(FocusEvent e) {
        e.display.asyncExec(() -> {
            Control detail = this.detailSupplier.get();
            if (detail != null && !detail.isDisposed() && this.isAncestorFocus(detail)) {
                this.selectionProvider.setDetailSelectionProvider((ISelectionProvider)NullSelectionProvider.INSTANCE);
            }
        });
    }

    private boolean isAncestorFocus(Control control) {
        boolean result = false;
        Control focus = control.getDisplay().getFocusControl();
        while (!result && focus != null) {
            result = focus == control;
            focus = focus.getParent();
        }
        return result;
    }
}

