/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.link;

import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.actions.link.AbstractLinkCreator;
import org.eclipse.jst.pagedesigner.actions.link.LinkUtil;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HtmlLinkCreator
extends AbstractLinkCreator {
    public Element makeLinkElement(EditPart part, DesignRange range) {
        if (part instanceof TextEditPart) {
            Text middleNode = LinkUtil.splitDomText(part, range);
            EditPart parent = part.getParent();
            Node parentNode = (Node)parent.getModel();
            Document doc = parentNode instanceof Document ? (Document)parentNode : parentNode.getOwnerDocument();
            Element htmlLink = doc.createElement("a");
            htmlLink.setAttribute("href", "");
            Text text = doc.createTextNode(middleNode.getNodeValue());
            htmlLink.appendChild(text);
            parentNode.replaceChild(htmlLink, middleNode);
            return htmlLink;
        }
        return null;
    }

    public String getSourcePreview(EditPart part, DesignRange range) {
        if (part instanceof TextEditPart) {
            TextEditPart textPart = (TextEditPart)part;
            int[] offsets = textPart.getSelectedRange();
            String displayData = textPart.getTextData();
            String linkExp = displayData.substring(offsets[0], offsets[1]);
            StringBuffer sb = new StringBuffer();
            sb.append("<a href=\"\">");
            sb.append(linkExp);
            sb.append("</a>");
            return sb.toString();
        }
        return null;
    }
}

