/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.DockerOperationCancelledException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.docker.ui.wizards.ImageSearch;
import org.eclipse.linuxtools.internal.docker.core.DefaultImagePullProgressHandler;
import org.eclipse.linuxtools.internal.docker.core.RegistryInfo;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.jobs.FindImageInfoRunnable;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerLinkDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerPortDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ImageRunSelectionPage
extends WizardPage {
    private static final int INDENT = 30;
    private static final String ERROR_PULLING_IMAGE = "ImagePullError.msg";
    private final DataBindingContext dbc = new DataBindingContext();
    private final ImageRunSelectionModel model;
    private final ILaunchConfiguration lastLaunchConfiguration;
    private Link pullImageLink;
    private WritableValue<String> writeValue;
    private static final int COLUMNS = 3;

    public ImageRunSelectionPage(IDockerImage selectedImage, ILaunchConfiguration lastLaunchConfiguration) {
        super("ImageSelectionPage", WizardMessages.getString("ImageSelectionPage.title"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImageSelectionPage.runImage"));
        this.setPageComplete(true);
        this.model = new ImageRunSelectionModel(selectedImage);
        this.lastLaunchConfiguration = lastLaunchConfiguration;
    }

    public ImageRunSelectionPage(IDockerConnection selectedConnection) {
        super("ImageSelectionPage", WizardMessages.getString("ImageSelectionPage.exposedPortTitle"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("ImageRunSelectionPage.exposedPortMsg"));
        this.setPageComplete(false);
        this.model = new ImageRunSelectionModel(selectedConnection);
        this.lastLaunchConfiguration = null;
    }

    public ImageRunSelectionModel getModel() {
        return this.model;
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollTop = new ScrolledComposite(parent, 768);
        scrollTop.setExpandVertical(true);
        scrollTop.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrollTop, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        this.setDefaultValues();
        this.createImageSettingsSection(container);
        this.createSectionSeparator(container, true);
        this.createPortSettingsSection(container);
        this.createLinkSettingsSection(container);
        this.createRunOptionsSection(container);
        IObservableValue imageSelectionObservable = BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedImageName").observe((Object)this.model);
        imageSelectionObservable.addValueChangeListener(this.onImageSelectionChange());
        this.writeValue = new WritableValue((Object)"", String.class);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        ImageSelectionValidator imageSelectionValidator = new ImageSelectionValidator((IObservableValue<String>)imageSelectionObservable);
        imageSelectionObservable.addValueChangeListener(this.onImageSelectionChange());
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)imageSelectionValidator);
        imageSelectionObservable.addValueChangeListener(this.onImageSelectionChange());
        IObservableValue containerNameObservable = BeanProperties.value(ImageRunSelectionModel.class, (String)"containerName").observe((Object)this.model);
        ContainerNameValidator containerNameValidator = new ContainerNameValidator(this.model.getSelectedConnection(), (IObservableValue<String>)containerNameObservable);
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)containerNameValidator);
        Object containerstatus = containerNameValidator.getValidationStatus().getValue();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        this.setStatusMessage(containerstatus);
        scrollTop.setContent((Control)container);
        Point point = container.computeSize(-1, -1);
        scrollTop.setSize(point);
        scrollTop.setMinSize(point);
        this.setControl((Control)scrollTop);
    }

    private void setStatusMessage(Object containerstatus) {
        if (containerstatus instanceof ValidationStatus) {
            ValidationStatus validationStatus = (ValidationStatus)containerstatus;
            if (validationStatus.getSeverity() == 4) {
                this.setMessage(validationStatus.getMessage(), 3);
            } else if (validationStatus.getSeverity() == 2) {
                this.setMessage(validationStatus.getMessage(), 2);
            }
        } else if (containerstatus instanceof IStatus) {
            IStatus status = (IStatus)containerstatus;
            if (status.getSeverity() == 4) {
                this.setMessage(status.getMessage(), 3);
            } else if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
    }

    private void createSectionSeparator(Composite container, boolean separator) {
        int SECTION_INDENT = 10;
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).indent(-1, 10).applyTo((Control)new Label(container, separator ? 258 : 0));
    }

    private void createImageSettingsSection(Composite container) {
        Label imageSelectionLabel = new Label(container, 0);
        imageSelectionLabel.setText(WizardMessages.getString("ImageRunSelectionPage.imageName"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        Combo imageSelectionCombo = new Combo(container, 2048);
        ComboViewer imageSelectionComboViewer = new ComboViewer(imageSelectionCombo);
        imageSelectionCombo.setToolTipText(WizardMessages.getString("ImageRunSelectionPage.selectTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)imageSelectionCombo);
        new ControlDecoration((Control)imageSelectionCombo, 16512);
        new ContentProposalAdapter((Control)imageSelectionCombo, (IControlContentAdapter)new ComboContentAdapter(){

            public void insertControlContents(Control control, String text, int cursorPosition) {
                Combo combo = (Combo)control;
                Point selection = combo.getSelection();
                combo.setText(text);
                selection.y = selection.x = text.length();
                combo.setSelection(selection);
            }
        }, this.getImageNameContentProposalProvider(imageSelectionCombo), null, null);
        Button searchImageButton = new Button(container, 0);
        searchImageButton.setText(WizardMessages.getString("ImageRunSelectionPage.search"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)searchImageButton);
        searchImageButton.addSelectionListener(this.onSearchImage());
        Label fillerLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)fillerLabel);
        this.pullImageLink = new Link(container, 0);
        this.pullImageLink.setText(WizardMessages.getString("ImageRunSelectionPage.pullImage"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.pullImageLink);
        this.pullImageLink.addSelectionListener(this.onPullImage());
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.pullImageLink), BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedImageNeedsPulling").observe((Object)this.model));
        imageSelectionComboViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.dbc.bindList((IObservableList)WidgetProperties.items().observe((Widget)imageSelectionCombo), BeanProperties.list(ImageRunSelectionModel.class, (String)"imageNames").observe((Object)this.model));
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)imageSelectionCombo), BeanProperties.value(ImageRunSelectionModel.class, (String)"selectedImageName").observe((Object)this.model));
        Label containerNameLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        containerNameLabel.setText(WizardMessages.getString("ImageRunSelectionPage.containerName"));
        Text containerNameText = new Text(container, 2048);
        containerNameText.setToolTipText(WizardMessages.getString("ImageRunSelectionPage.containerTooltip"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)containerNameText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)containerNameText), BeanProperties.value(ImageRunSelectionModel.class, (String)"containerName").observe((Object)this.model));
        Label entrypointLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        entrypointLabel.setText(WizardMessages.getString("ImageRunSelectionPage.entrypoint"));
        Text entrypointText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)entrypointText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)entrypointText), BeanProperties.value(ImageRunSelectionModel.class, (String)"entrypoint").observe((Object)this.model));
        Label commandLabel = new Label(container, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)imageSelectionLabel);
        commandLabel.setText(WizardMessages.getString("ImageRunSelectionPage.command"));
        Text commandText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)commandText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)new Label(container, 0));
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)commandText), BeanProperties.value(ImageRunSelectionModel.class, (String)"command").observe((Object)this.model));
    }

    private void createPortSettingsSection(Composite container) {
        Button publishAllPortsButton = new Button(container, 32);
        publishAllPortsButton.setText(WizardMessages.getString("ImageRunSelectionPage.publishAllPorts"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)publishAllPortsButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)publishAllPortsButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"publishAllPorts").observe((Object)this.model));
        Label portSettingsLabel = new Label(container, 0);
        portSettingsLabel.setText(WizardMessages.getString("ImageRunSelectionPage.portSettings"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).indent(30, 0).applyTo((Control)portSettingsLabel);
        CheckboxTableViewer exposedPortsTableViewer = this.createPortSettingsTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).indent(30, 0).hint(200, 70).applyTo((Control)exposedPortsTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunSelectionPage.addButton"));
        addButton.addSelectionListener(this.onAddPort(exposedPortsTableViewer));
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunSelectionPage.editButton"));
        editButton.setEnabled(false);
        editButton.addSelectionListener(this.onEditPort(exposedPortsTableViewer));
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunSelectionPage.remove"));
        removeButton.addSelectionListener(this.onRemovePorts((TableViewer)exposedPortsTableViewer));
        BeanProperties.value(ImageRunSelectionModel.class, (String)"publishAllPorts").observe((Object)this.model).addValueChangeListener(this.onPublishAllPortsChange(new Control[]{exposedPortsTableViewer.getTable(), addButton, removeButton}));
        ViewerSupport.bind((StructuredViewer)exposedPortsTableViewer, this.model.getExposedPorts(), (IValueProperty[])BeanProperties.values(ImageRunSelectionModel.ExposedPortModel.class, (String[])new String[]{"containerPort", "portType", "hostAddress", "hostPort"}));
        this.dbc.bindSet((IObservableSet)ViewerProperties.checkedElements(ImageRunSelectionModel.ExposedPortModel.class).observe((Viewer)exposedPortsTableViewer), BeanProperties.set((String)"selectedPorts").observe((Object)this.model));
        exposedPortsTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
        this.togglePortMappingControls(new Control[]{exposedPortsTableViewer.getTable(), addButton, removeButton});
    }

    private ISelectionChangedListener onSelectionChanged(Button ... targetButtons) {
        return e -> {
            if (e.getSelection().isEmpty()) {
                ImageRunSelectionPage.setControlsEnabled((Control[])targetButtons, false);
            } else {
                ImageRunSelectionPage.setControlsEnabled((Control[])targetButtons, true);
            }
        };
    }

    private CheckboxTableViewer createPortSettingsTable(Composite container) {
        Table table = new Table(container, 68384);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.containerPortColumn"), 100);
        this.createTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.typeColumn"), 50);
        this.createTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.hostAddressColumn"), 100);
        this.createTableViewerColum((TableViewer)tableViewer, WizardMessages.getString("ImageRunSelectionPage.hostPortColumn"), 100);
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        return tableViewer;
    }

    private TableViewerColumn createTableViewerColum(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private void createLinkSettingsSection(Composite container) {
        Label linksLabel = new Label(container, 0);
        linksLabel.setText(WizardMessages.getString("ImageRunSelectionPage.links"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)linksLabel);
        TableViewer linksTableViewer = this.createLinksTable(container);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).span(2, 1).hint(200, 50).indent(30, -1).applyTo((Control)linksTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunSelectionPage.addButton"));
        addButton.addSelectionListener(this.onAddLink());
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunSelectionPage.editButton"));
        editButton.setEnabled(false);
        editButton.addSelectionListener(this.onEditLink(linksTableViewer));
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunSelectionPage.remove"));
        removeButton.addSelectionListener(this.onRemoveLinks(linksTableViewer));
        removeButton.setEnabled(false);
        ViewerSupport.bind((StructuredViewer)linksTableViewer, this.model.getLinks(), (IValueProperty[])BeanProperties.values(ImageRunSelectionModel.ContainerLinkModel.class, (String[])new String[]{"containerName", "containerAlias"}));
        linksTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private TableViewer createLinksTable(Composite container) {
        Table table = new Table(container, 2818);
        TableViewer tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableViewerColum(tableViewer, WizardMessages.getString("ImageRunSelectionPage.containerNameColumn"), 200);
        this.createTableViewerColum(tableViewer, WizardMessages.getString("ImageRunSelectionPage.aliasColumn"), 150);
        return tableViewer;
    }

    private SelectionListener onAddLink() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerLinkDialog dialog = new ContainerLinkDialog(this.getShell(), this.model.getSelectedConnection());
            dialog.create();
            if (dialog.open() == 0) {
                this.model.addLink(dialog.getContainerName(), dialog.getContainerAlias());
            }
        });
    }

    private SelectionListener onEditLink(TableViewer linksTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = linksTableViewer.getStructuredSelection();
            ImageRunSelectionModel.ContainerLinkModel selectedContainerLink = (ImageRunSelectionModel.ContainerLinkModel)selection.getFirstElement();
            ContainerLinkDialog dialog = new ContainerLinkDialog(this.getShell(), this.model.getSelectedConnection(), selectedContainerLink);
            dialog.create();
            if (dialog.open() == 0) {
                selectedContainerLink.setContainerName(dialog.getContainerName());
                selectedContainerLink.setContainerAlias(dialog.getContainerAlias());
                linksTableViewer.refresh();
            }
        });
    }

    private SelectionListener onRemoveLinks(TableViewer linksTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = linksTableViewer.getStructuredSelection();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.model.removeLink((ImageRunSelectionModel.ContainerLinkModel)iterator.next());
            }
        });
    }

    private void createRunOptionsSection(Composite container) {
        Button interactiveButton = new Button(container, 32);
        interactiveButton.setText(WizardMessages.getString("ImageRunSelectionPage.openStdin"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)interactiveButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)interactiveButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"interactiveMode").observe((Object)this.model));
        Button allocatePseudoTTY = new Button(container, 32);
        allocatePseudoTTY.setText(WizardMessages.getString("ImageRunSelectionPage.tty"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)allocatePseudoTTY);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)allocatePseudoTTY), BeanProperties.value(ImageRunSelectionModel.class, (String)"allocatePseudoTTY").observe((Object)this.model));
        Button removeWhenExitsButton = new Button(container, 32);
        removeWhenExitsButton.setText(WizardMessages.getString("ImageRunSelectionPage.autoRemove"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)removeWhenExitsButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)removeWhenExitsButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"removeWhenExits").observe((Object)this.model));
        Button privilegedButton = new Button(container, 32);
        privilegedButton.setText(WizardMessages.getString("ImageRunSelectionPage.privileged"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)privilegedButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)privilegedButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"privileged").observe((Object)this.model));
        Button unconfinedButton = new Button(container, 32);
        unconfinedButton.setText(WizardMessages.getString("ImageRunSelectionPage.unconfined"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)unconfinedButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)unconfinedButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"unconfined").observe((Object)this.model));
        Button basicSecurityButton = new Button(container, 32);
        basicSecurityButton.setText(WizardMessages.getString("ImageRunSelectionPage.basicSecurity"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)basicSecurityButton);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)basicSecurityButton), BeanProperties.value(ImageRunSelectionModel.class, (String)"basicSecurity").observe((Object)this.model));
    }

    private IContentProposalProvider getImageNameContentProposalProvider(Combo imageSelectionCombo) {
        return (contents, position) -> {
            ArrayList<ContentProposal> proposals = new ArrayList<ContentProposal>();
            String[] stringArray = imageSelectionCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String imageName = stringArray[n2];
                if (imageName.contains(contents)) {
                    proposals.add(new ContentProposal(imageName, imageName, imageName, position));
                }
                ++n2;
            }
            return proposals.toArray(new IContentProposal[0]);
        };
    }

    private IValueChangeListener onImageSelectionChange() {
        return event -> {
            IDockerImage selectedImage = this.model.getSelectedImage();
            if (selectedImage == null) {
                this.model.setExposedPorts(Collections.emptyList());
                return;
            }
            IDockerImageInfo selectedImageInfo = this.getImageInfo(selectedImage);
            this.applyImageInfo(selectedImageInfo);
        };
    }

    private SelectionListener onPullImage() {
        return SelectionListener.widgetDefaultSelectedAdapter(e -> this.pullSelectedImage());
    }

    private IValueChangeListener onPublishAllPortsChange(Control ... controls) {
        return event -> this.togglePortMappingControls(controls);
    }

    private SelectionListener onSearchImage() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ImageSearch imageSearchWizard = new ImageSearch(this.model.getSelectedConnection(), this.model.getSelectedImageName(), (IRegistry)new RegistryInfo("https://index.docker.io", true));
            boolean completed = CommandUtils.openWizard((IWizard)imageSearchWizard, this.getShell());
            if (completed) {
                this.model.setSelectedImageName(imageSearchWizard.getSelectedImage());
            }
        });
    }

    private SelectionListener onAddPort(CheckboxTableViewer exposedPortsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerPortDialog dialog = new ContainerPortDialog(this.getShell());
            dialog.create();
            if (dialog.open() == 0) {
                ImageRunSelectionModel.ExposedPortModel port = dialog.getPort();
                port.setSelected(true);
                this.model.addAvailablePort(port);
                this.model.getSelectedPorts().add(port);
                exposedPortsTableViewer.setChecked((Object)port, true);
            }
        });
    }

    private SelectionListener onEditPort(CheckboxTableViewer exposedPortsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = exposedPortsTableViewer.getStructuredSelection();
            ImageRunSelectionModel.ExposedPortModel selectedContainerPort = (ImageRunSelectionModel.ExposedPortModel)selection.getFirstElement();
            ContainerPortDialog dialog = new ContainerPortDialog(this.getShell(), selectedContainerPort);
            dialog.create();
            if (dialog.open() == 0) {
                ImageRunSelectionModel.ExposedPortModel configuredPort = dialog.getPort();
                selectedContainerPort.setContainerPort(configuredPort.getContainerPort());
                selectedContainerPort.setHostAddress(configuredPort.getHostAddress());
                selectedContainerPort.setHostPort(configuredPort.getHostPort());
                exposedPortsTableViewer.refresh();
            }
        });
    }

    private SelectionListener onRemovePorts(TableViewer portsTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = portsTableViewer.getStructuredSelection();
            for (ImageRunSelectionModel.ExposedPortModel port : selection) {
                this.model.removeAvailablePort(port);
                this.model.getSelectedPorts().remove(port);
            }
        });
    }

    private void setDefaultValues() {
        IDockerImage selectedImage = this.model.getSelectedImage();
        if (selectedImage == null) {
            return;
        }
        IDockerImageInfo selectedImageInfo = this.getImageInfo(selectedImage);
        if (this.lastLaunchConfiguration != null) {
            try {
                this.model.setContainerName(this.lastLaunchConfiguration.getAttribute("containerName", ""));
                this.model.setEntrypoint(this.lastLaunchConfiguration.getAttribute("entryPoint", ""));
                this.model.setCommand(this.lastLaunchConfiguration.getAttribute("command", ""));
                this.model.setPublishAllPorts(this.lastLaunchConfiguration.getAttribute("publishAllPorts", false));
                List exposedPortInfos = this.lastLaunchConfiguration.getAttribute("publishedPorts", Collections.emptyList());
                List unusedPortInfos = this.lastLaunchConfiguration.getAttribute("unusedPorts", Collections.emptyList());
                if (selectedImageInfo != null) {
                    if (exposedPortInfos.isEmpty()) {
                        exposedPorts = ImageRunSelectionModel.ExposedPortModel.fromStrings(selectedImageInfo.config().exposedPorts());
                        this.model.setExposedPorts(exposedPorts);
                        this.model.setSelectedPorts(new HashSet<ImageRunSelectionModel.ExposedPortModel>(exposedPorts));
                    } else {
                        exposedPorts = ImageRunSelectionModel.ExposedPortModel.fromStrings(exposedPortInfos);
                        this.model.setExposedPorts(exposedPorts);
                        this.model.setSelectedPorts(new HashSet<ImageRunSelectionModel.ExposedPortModel>(exposedPorts));
                    }
                    for (String port : unusedPortInfos) {
                        ImageRunSelectionModel.ExposedPortModel portModel = ImageRunSelectionModel.ExposedPortModel.fromString(port);
                        portModel.setSelected(false);
                        this.model.addExposedPort(portModel);
                    }
                }
                this.model.setLinks(this.lastLaunchConfiguration.getAttribute("links", Collections.emptyList()));
                this.model.setRemoveWhenExits(this.lastLaunchConfiguration.getAttribute("autoRemove", false));
                this.model.setInteractiveMode(this.lastLaunchConfiguration.getAttribute("interactive", false));
                this.model.setAllocatePseudoTTY(this.lastLaunchConfiguration.getAttribute("allocatePseudoTTY", false));
                this.model.setPrivileged(this.lastLaunchConfiguration.getAttribute("privileged", false));
                this.model.setBasicSecurity(this.lastLaunchConfiguration.getAttribute("readonly", false));
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        } else {
            this.applyImageInfo(selectedImageInfo);
        }
    }

    private IDockerImageInfo getImageInfo(IDockerImage selectedImage) {
        try {
            FindImageInfoRunnable findImageInfoRunnable = new FindImageInfoRunnable(selectedImage);
            this.getContainer().run(true, true, (IRunnableWithProgress)findImageInfoRunnable);
            IDockerImageInfo selectedImageInfo = findImageInfoRunnable.getResult();
            return selectedImageInfo;
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
            return null;
        }
    }

    private void applyImageInfo(IDockerImageInfo selectedImageInfo) {
        if (selectedImageInfo != null && selectedImageInfo.config() != null) {
            List<ImageRunSelectionModel.ExposedPortModel> exposedPorts = ImageRunSelectionModel.ExposedPortModel.fromStrings(selectedImageInfo.config().exposedPorts());
            this.model.setExposedPorts(exposedPorts);
            this.model.setEntrypoint(selectedImageInfo.config().entrypoint());
            this.model.setCommand(selectedImageInfo.config().cmd());
        }
    }

    private void togglePortMappingControls(Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (this.model.isPublishAllPorts()) {
                control.setEnabled(false);
            } else {
                control.setEnabled(true);
            }
            ++n2;
        }
    }

    private void pullSelectedImage() {
        try {
            this.getContainer().run(true, true, monitor -> {
                block10: {
                    IDockerConnection connection = this.model.getSelectedConnection();
                    String imageName = this.model.getSelectedImageName();
                    monitor.beginTask(WizardMessages.getFormattedString("ImageRunSelectionPage.pullingTask", imageName), 1);
                    try {
                        connection.pullImage(imageName, (IDockerProgressHandler)new DefaultImagePullProgressHandler(connection, imageName, monitor));
                    }
                    catch (DockerOperationCancelledException dockerOperationCancelledException) {
                        monitor.done();
                        this.model.refreshImageNames();
                        if (this.model.getImageNames().contains(imageName)) {
                            this.model.setSelectedImageName(imageName);
                            this.model.setSelectedImageNeedsPulling(false);
                            Display.getDefault().syncExec(() -> this.writeValue.setValue((Object)Long.toString(System.currentTimeMillis())));
                        }
                        break block10;
                    }
                    catch (DockerException e) {
                        try {
                            Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(ERROR_PULLING_IMAGE, imageName), (String)e.getMessage()));
                        }
                        catch (Throwable throwable) {
                            monitor.done();
                            this.model.refreshImageNames();
                            if (this.model.getImageNames().contains(imageName)) {
                                this.model.setSelectedImageName(imageName);
                                this.model.setSelectedImageNeedsPulling(false);
                                Display.getDefault().syncExec(() -> this.writeValue.setValue((Object)Long.toString(System.currentTimeMillis())));
                            }
                            throw throwable;
                        }
                        monitor.done();
                        this.model.refreshImageNames();
                        if (this.model.getImageNames().contains(imageName)) {
                            this.model.setSelectedImageName(imageName);
                            this.model.setSelectedImageNeedsPulling(false);
                            Display.getDefault().syncExec(() -> this.writeValue.setValue((Object)Long.toString(System.currentTimeMillis())));
                        }
                        break block10;
                    }
                    monitor.done();
                    this.model.refreshImageNames();
                    if (this.model.getImageNames().contains(imageName)) {
                        this.model.setSelectedImageName(imageName);
                        this.model.setSelectedImageNeedsPulling(false);
                        Display.getDefault().syncExec(() -> this.writeValue.setValue((Object)Long.toString(System.currentTimeMillis())));
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            Activator.log(e);
        }
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    private class ContainerNameValidator
    extends MultiValidator {
        private final IDockerConnection connection;
        private final IObservableValue<String> containerNameObservable;

        ContainerNameValidator(IDockerConnection connection, IObservableValue<String> containerNameObservable) {
            this.connection = connection;
            this.containerNameObservable = containerNameObservable;
        }

        protected IStatus validate() {
            String containerName = (String)this.containerNameObservable.getValue();
            for (IDockerContainer container : this.connection.getContainers()) {
                if (!container.name().equals(containerName)) continue;
                return ValidationStatus.error((String)WizardMessages.getString("ImageRunSelectionPage.containerWithSameName"));
            }
            return ValidationStatus.ok();
        }

        public IObservableList<IObservable> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.containerNameObservable);
            return targets;
        }
    }

    private class ImageSelectionValidator
    extends MultiValidator {
        private final IObservableValue<String> imageSelectionObservable;

        ImageSelectionValidator(IObservableValue<String> imageSelectionObservable) {
            this.imageSelectionObservable = imageSelectionObservable;
        }

        protected IStatus validate() {
            ObservableTracker.getterCalled(ImageRunSelectionPage.this.writeValue);
            String selectedImageName = (String)this.imageSelectionObservable.getValue();
            if (selectedImageName.isEmpty()) {
                ImageRunSelectionPage.this.model.setSelectedImageNeedsPulling(false);
                return ValidationStatus.error((String)WizardMessages.getString("ImageRunSelectionPage.specifyImageMsg"));
            }
            if (ImageRunSelectionPage.this.model.getSelectedImage() != null) {
                ImageRunSelectionPage.this.model.setSelectedImageNeedsPulling(false);
                return ValidationStatus.ok();
            }
            ImageRunSelectionPage.this.model.setSelectedImageNeedsPulling(true);
            return ValidationStatus.warning((String)WizardMessages.getFormattedString("ImageRunSelectionPage.imageNotFoundMessage", selectedImageName));
        }

        public IObservableList<IObservable> getTargets() {
            WritableList targets = new WritableList();
            targets.add(this.imageSelectionObservable);
            return targets;
        }
    }
}

